drop TABLE  if exists  public.tb_zbph_process_processstate_dict;
CREATE TABLE public.tb_zbph_process_processstate_dict (
	f_id varchar(64) NULL,
	f_processstate varchar(64) NULL,
	f_processstatestr varchar(255) NULL,
	CONSTRAINT tb_zbph_process_processstate_dict_pk PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_process_processstate_dict_un UNIQUE (f_processstate)
);
-- Column comments

COMMENT ON COLUMN public.tb_zbph_process_processstate_dict.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_process_processstate_dict.f_processstate IS '流程状态值';
COMMENT ON COLUMN public.tb_zbph_process_processstate_dict.f_processstatestr IS '流程状态翻译值';

drop TABLE  if exists  public.tb_zbph_process_checkstate_dict;
CREATE TABLE public.tb_zbph_process_checkstate_dict (
	f_id varchar(64) NULL,
	f_checkstate varchar(64) NULL,
	f_checkstatestr varchar(255) NULL,
	CONSTRAINT tb_zbph_process_checkstate_dict_pk PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_process_checkstate_dict_un UNIQUE (f_checkstate)
);
COMMENT ON COLUMN public.tb_zbph_process_checkstate_dict.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_process_checkstate_dict.f_checkstate IS '审核状态值';
COMMENT ON COLUMN public.tb_zbph_process_checkstate_dict.f_checkstatestr IS '审核状态翻译值';

drop TABLE  if exists  public.tb_zbph_process_tasklistener_dict;
CREATE TABLE public.tb_zbph_process_tasklistener_dict (
	f_id varchar(64) NULL,
	f_name varchar(64) NULL,
	f_classname varchar(255) NULL,
	CONSTRAINT tb_zbph_process_tasklistener_dict_pk PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_process_tasklistener_dict_un UNIQUE (f_name)
);
COMMENT ON COLUMN public.tb_zbph_process_tasklistener_dict.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_process_tasklistener_dict.f_name IS '监听器名字';
COMMENT ON COLUMN public.tb_zbph_process_tasklistener_dict.f_classname IS '监听器命名空间';

INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('1', 'p0', '拟件');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('2', 'p01', '数据查验中');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('3', 'p02', '内业查验退回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('4', 'p03', '完成数据查验');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('5', 'p04', '待外业核查');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('6', 'p05', '外业核查中');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('7', 'p06', '完成外业核查');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('8', 'p07', '项目撤回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('9', 'p1', '县级审核中');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('10', 'p11', '县级退回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('11', 'p17', '县级撤回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('12', 'p18', '县级终止');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('13', 'p3', '市级审核中');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('14', 'p31', '市级退回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('15', 'p37', '市级撤回');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('16', 'p48', '省级终止');
INSERT INTO public.tb_zbph_process_processstate_dict (f_id, f_processstate, f_processstatestr) VALUES('17', 'p51', '已完成备案');

INSERT INTO public.tb_zbph_process_checkstate_dict (f_id, f_checkstate, f_checkstatestr) VALUES('1', 'p0', '拟件');
INSERT INTO public.tb_zbph_process_checkstate_dict (f_id, f_checkstate, f_checkstatestr) VALUES('2', 'p1', '县级审核中');
INSERT INTO public.tb_zbph_process_checkstate_dict (f_id, f_checkstate, f_checkstatestr) VALUES('3', 'p3', '市级审核中');
INSERT INTO public.tb_zbph_process_checkstate_dict (f_id, f_checkstate, f_checkstatestr) VALUES('4', 'p4', '省级审核中');
INSERT INTO public.tb_zbph_process_checkstate_dict (f_id, f_checkstate, f_checkstatestr) VALUES('5', 'p51', '已完成备案');


INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('1', '校验审核附件', 'com.geoway.onemap.zbph.service.base.impl.processtasklistener.CheckFileVerifyListener');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('2', '创建数据检验任务(项目立项)', 'com.geoway.onemap.zbph.service.xfsbcgdlx.impl.XfsbcgdLxManageServiceImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('3', '创建外业核查任务(项目立项)', 'com.geoway.onemap.zbph.service.xfsbcgdlx.impl.XfsbcgdLxManageServiceImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('4', '创建数据检验任务(项目验收)', 'com.geoway.onemap.zbph.service.xfsbcgdys.impl.XfsbcgdYsManageServiceImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('5', '创建外业核查任务(项目验收)', 'com.geoway.onemap.zbph.service.xfsbcgdys.impl.XfsbcgdYsManageServiceImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('6', '指标核减出库(指标核减)', 'com.geoway.onemap.zbph.service.zbtj.hj.impl.ZbhjckProcessImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('7', '校验耕地质量等别(图斑入库)', 'com.geoway.onemap.zbph.service.xfstbrk.impl.ZbkTbrkCheckGddjValidImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('8', '创建数据检验任务(图斑入库)', 'com.geoway.onemap.zbph.service.xfstbrk.impl.ZbkTbrkVerifyTaskCreateImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('9', '数据校验任务成功(图斑入库)', 'com.geoway.onemap.zbph.service.xfstbrk.impl.ZbkTbrkVerifyTaskFinishedImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('10', '删除补充耕地确认单(指标使用)', 'com.geoway.onemap.zbph.service.zgck.impl.ZgckProcessDeleteQrdImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('11', '指标使用出库(指标使用)', 'com.geoway.onemap.zbph.service.zgck.impl.ZgckProcessFinishedImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('12', '指标使用确认单生成(指标使用)', 'com.geoway.onemap.zbph.service.zgck.impl.ZgckProcessQrdImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('13', '指标使用项目终止(指标使用)', 'com.geoway.onemap.zbph.service.zgck.impl.ZgckProcessStopImpl');
INSERT INTO public.tb_zbph_process_tasklistener_dict (f_id, f_name, f_classname) VALUES('14', '指标使用指标退回(指标使用)', 'com.geoway.onemap.zbph.service.zgck.impl.ZgckProcessUnOutputImpl');