drop TABLE if exists tb_zbph_zbk_base;

CREATE TABLE tb_zbph_zbk_base (
	f_id varchar(64) NOT NULL,
	f_xzqdm varchar NULL, -- 行政区代码
	f_xzqmc varchar NULL, -- 行政区名称
	f_zbnd varchar(64) NULL, -- 指标年度
	f_ycbkslzb numeric(18, 6) NULL, -- 原储备库数量指标
	f_ycbkstzb numeric(18, 6) NULL, -- 原储备库水田指标
	f_ygjtcslzb numeric(18, 6) NULL, -- 原国家统筹数量指标
	f_ygjtcstzb numeric(18, 6) NULL, -- 原国家统筹水田指标
	f_cnslzb numeric(18, 6) NULL, -- 承诺数量指标
	f_cnstzb numeric(18, 6) NULL, -- 承诺水田指标
	f_updatetime timestamp(6) NULL, -- 更新时间
	CONSTRAINT tb_zbph_zbk_base_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbk_base IS '部系统基础指标库';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_base.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_zbnd IS '指标年度';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_ycbkslzb IS '原储备库数量指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_ycbkstzb IS '原储备库水田指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_ygjtcslzb IS '原国家统筹数量指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_ygjtcstzb IS '原国家统筹水田指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_cnslzb IS '承诺数量指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_cnstzb IS '承诺水田指标';
COMMENT ON COLUMN public.tb_zbph_zbk_base.f_updatetime IS '更新时间';