/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.support.SnowflakeIdWorker;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.MyTokenService;
import com.geoway.onemap.core.service.system.SysUserService;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.stxf.constant.LandShpParser;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.stxf.utils.ShpUtils;
import com.geoway.stxf.vo.UUIDFileVo;
import com.geoway.web.anno.RequireAuth;
import com.geoway.zhgd.domain.BaseFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/baseFile"})
public class BaseFileAction {
    Logger logger = Logger.getLogger(BaseFileAction.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private BaseFileService baseFileService;
    @Autowired
    LoginServiceUIS loginServiceUIS;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    MyTokenService tokenService;
    @Autowired
    ModelManageService modelManageService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page pages = this.baseFileService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/findAll.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findAll(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List pages = this.baseFileService.findAll(filterParam, sortParam);
            response.setData((Object)pages);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/findProjAttachs.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findProjAttachs(@RequestParam(name="projectId") String projectId, String type) {
        BaseObjectResponse response = new BaseObjectResponse();
        ArrayList attachs = new ArrayList();
        try {
            List list = this.baseFileService.findAll("Q_relationType_S_EQ=SHFJ;Q_relationId_S_EQ=" + projectId, "SORT_uploadTime_desc");
            attachs.addAll(list);
            String tableName = "";
            String fjType = "";
            if ("jhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_jhk_xmfw";
                fjType = "JHK1";
            } else if ("fhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_fhk_xmfw";
                fjType = "FHK1";
            } else if ("lsk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_lsk_xmfw";
                fjType = "LSK1";
            }
            List tbList = this.modelManageService.findList(tableName, null, " and f_project_id = '" + projectId + "'");
            ArrayList<String> xmfwIds = new ArrayList<String>();
            for (Map m : tbList) {
                xmfwIds.add(m.get("f_id").toString());
            }
            if (xmfwIds.size() > 0) {
                List pages = this.baseFileService.findAll("Q_relationType_S_EQ=" + fjType + ";Q_relationId_S_IN=" + org.apache.commons.lang3.StringUtils.join(xmfwIds, (String)","), "SORT_uploadTime_desc");
                attachs.addAll(pages);
            }
            response.setData(attachs);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/findProjectTBFJ.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findProjectTBFJ(@RequestParam(name="projectId") String projectId, String type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            JSONArray array = new JSONArray();
            String tableName = "";
            String fjType = "";
            if ("jhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_jhk_xmfw";
                fjType = "JHK1";
            } else if ("fhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_fhk_xmfw";
                fjType = "FHK1";
            } else if ("lsk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_lsk_xmfw";
                fjType = "LSK1";
            }
            List tbList = this.modelManageService.findList(tableName, null, " and f_project_id = '" + projectId + "'");
            response.setData((Object)tbList);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/findProjectXZGD.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findProjectXZGD(@RequestParam(name="projectId") String projectId, String type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String tableName = "";
            String fjType = "";
            if ("jhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_jhk_xzgdfw";
                fjType = "JHK1";
            } else if ("fhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_fhk_xzgdfw";
                fjType = "FHK1";
            } else if ("lsk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_lsk_xzgdfw";
                fjType = "LSK1";
            }
            List gdList = this.modelManageService.findList(tableName, null, " and f_project_id = '" + projectId + "'");
            response.setData((Object)gdList);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveBaseFile.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse saveBaseFile(@ModelAttribute BaseFile baseFile) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            BaseFile baseFileDb = this.baseFileService.saveBaseFile(baseFile);
            response.setData((Object)baseFileDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delBaseFileById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delBaseFileById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.baseFileService.delBaseFile(new String[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getBaseFileById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getBaseFileById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            BaseFile baseFile = this.baseFileService.findById(id);
            response.setData((Object)baseFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/updateFile.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse updateFile(HttpServletRequest request, @RequestParam(name="token", required=false) String token, @RequestParam(name="myfile", required=false) MultipartFile[] myfile, @RequestParam(required=false) String file_id, @RequestParam String relationId, @RequestParam String relationType) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (StringUtils.isBlank((String)this.uploadDir)) {
                this.uploadDir = request.getRealPath("/page/upload");
            }
            for (MultipartFile file : myfile) {
                Calendar a = Calendar.getInstance();
                String year = a.get(1) + "";
                String month = a.get(2) + 1 + "";
                String name = file.getOriginalFilename();
                File file2 = new File(this.uploadDir);
                if (!file2.exists() && !file2.mkdirs()) {
                    this.logger.error((Object)"\u4e0a\u4f20\u76ee\u5f55\u8bfb\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u914d\u7f6e\u8def\u5f84\u662f\u5426\u6b63\u786e\uff01");
                    response.setStatus("FAILURE");
                    response.setMessage("\u4e0a\u4f20\u76ee\u5f55\u8bfb\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u914d\u7f6e\u8def\u5f84\u662f\u5426\u6b63\u786e\uff01");
                    return response;
                }
                UUID uuid = UUID.randomUUID();
                String storePath = File.separator + year + File.separator + month + File.separator + uuid + File.separator;
                String upFilePath = this.uploadDir + storePath;
                File filedir = new File(upFilePath);
                if (!filedir.exists()) {
                    filedir.mkdirs();
                }
                File file3 = new File(upFilePath, name);
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)file3);
                BaseFile baseFile = this.baseFileService.uploadFile(file3, relationId, relationType, user);
                response.setData((Object)baseFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadAttach.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void downloadAttach(@RequestParam String fileId, @RequestParam(name="token", required=false) String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/octet-stream");
        if (StringUtils.isBlank((String)this.uploadDir)) {
            this.uploadDir = request.getRealPath("/page/upload");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        SysUser user = null;
        try {
            int length;
            File f;
            BaseFile baseFile;
            if (token != null) {
                user = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.querySysUserByToken(token) : this.tokenService.querySysUserByToken(token);
            }
            inputStream = "FWJ0".equals((baseFile = this.baseFileService.downLoadFile(fileId, user != null ? user.getId() : "")).getRelationType()) ? ((f = new File(baseFile.getCreatePath())).exists() ? new FileInputStream(new File(baseFile.getCreatePath())) : new FileInputStream(new File(this.uploadDir + baseFile.getCreatePath()))) : this.getFileOutputStream(baseFile);
            String fileName = URLEncoder.encode(baseFile.getFileName(), "UTF-8");
            String fileType = baseFile.getFileName().substring(baseFile.getFileName().lastIndexOf(".") + 1);
            if ("docx".equals(fileType)) {
                response.setContentType("application/msword");
            }
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            outputStream = response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = inputStream.read(b)) > 0) {
                outputStream.write(b, 0, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private InputStream getFileOutputStream(BaseFile baseFile) throws Exception {
        String tmpUrl;
        File tempFile;
        File f = new File(baseFile.getCreatePath());
        FileInputStream is = null;
        is = f.exists() ? new FileInputStream(new File(baseFile.getCreatePath())) : new FileInputStream(new File(this.uploadDir + baseFile.getCreatePath()));
        String onlyFileName = baseFile.getFileName().substring(0, baseFile.getFileName().lastIndexOf("."));
        String fileType = baseFile.getFileName().substring(baseFile.getFileName().lastIndexOf(".") + 1);
        String parentUrl = this.uploadDir + "/download-tmp";
        File parentFile = new File(parentUrl);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!(tempFile = new File(tmpUrl = parentUrl + "/" + onlyFileName + "_" + System.currentTimeMillis() + "." + fileType)).exists()) {
            tempFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(tempFile);
        FileChannel inputChannel = is.getChannel();
        FileChannel outputChannel = out.getChannel();
        outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        inputChannel.close();
        outputChannel.close();
        FileInputStream inputStream = new FileInputStream(tempFile);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/previewAttach.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void previewAttach(@RequestParam String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/pdf;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            this.logger.info((Object)String.format("\u6587\u4ef6\u9884\u89c8ID:%s", fileId));
            BaseFile baseFile = this.baseFileService.findById(fileId);
            response.setHeader("Content-Disposition", "inline;fileName=" + URLEncoder.encode(baseFile.getFileName(), "UTF-8"));
            if ("pdf".equals(baseFile.getFileFormat())) {
                response.setContentType("application/pdf");
                is = this.getFileOutputStream(baseFile);
            } else if ("jpg".equalsIgnoreCase(baseFile.getFileFormat())) {
                response.setContentType("image/jpeg");
                is = new FileInputStream(new File(this.uploadDir + baseFile.getCreatePath()));
            } else if ("mp4".equalsIgnoreCase(baseFile.getFileFormat())) {
                response.setContentType("video/mpeg4");
                File vfile = new File(this.uploadDir + baseFile.getCreatePath());
                is = new FileInputStream(vfile);
            } else {
                File f = new File(baseFile.getCreatePath());
                is = f.exists() ? new FileInputStream(new File(baseFile.getCreatePath())) : new FileInputStream(new File(this.uploadDir + baseFile.getCreatePath()));
            }
            os = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((length = is.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (IOException io) {
            this.logger.error((Object)io.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            os.close();
            is.close();
        }
    }

    @RequestMapping(value={"/uploadTxtOrShpFile.do"}, headers={"Accept=*/*"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public BaseObjectResponse uploadFile(HttpServletRequest request, @RequestParam(value="fileData") MultipartFile file) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String folder = this.uploadDir + "/temp/" + UUID.randomUUID().toString();
            new File(folder).mkdirs();
            String tempFileName = folder + "/" + fileName;
            File tempFile = new File(tempFileName);
            file.transferTo(tempFile);
            JSONObject xmxx = new JSONObject();
            if (".txt".equalsIgnoreCase(suffix)) {
                Map txtInfo = ShpUtils.readTxt2WKTWithoutProj((File)tempFile);
                xmxx = (JSONObject)txtInfo.get("geoJsonMap");
                JSONArray geometries = xmxx.getJSONArray("geometries");
                xmxx.put("spatialInfo", (Object)this.baseFileService.convertHJUpPropName(xmxx.getJSONObject("spatialInfo")));
                ArrayList dkzbs = new ArrayList();
                for (int i = 0; i < geometries.size(); ++i) {
                    String jsonstring = geometries.get(i).toString();
                    JSONObject json = JSONObject.parseObject((String)jsonstring);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : json.keySet()) {
                        if ("\u5730\u5757\u53f7".equals(key)) {
                            map.put("f_dikuai_no", json.get((Object)key));
                        }
                        if ("\u5730\u5757\u540d\u79f0".equals(key)) {
                            map.put("f_pl_name", json.get((Object)key));
                        }
                        if ("wkt".equals(key)) {
                            map.put("f_shap", json.get((Object)key));
                        }
                        if ("\u5730\u5757\u9762\u79ef".equals(key)) {
                            map.put("f_dikuai_area", json.get((Object)key));
                        }
                        if ("\u7528\u9014".equals(key)) {
                            map.put("f_purpose", json.get((Object)key));
                        }
                        if ("\u56fe\u5e45\u53f7".equals(key)) {
                            map.put("f_map_no", json.get((Object)key));
                        }
                        if ("rings".equals(key)) {
                            map.put("f_rings", json.get((Object)key));
                        }
                        if ("\u56fe\u6591\u7c7b\u578b".equals(key)) {
                            map.put("f_patchtype", json.get((Object)key));
                        }
                        if ("\u5730\u7c7b".equals(key)) {
                            map.put("f_landtype", json.get((Object)key));
                        }
                        if ("\u5e73\u5747\u8d28\u91cf\u7b49\u522b".equals(key)) {
                            map.put("f_avggrade1", json.get((Object)key));
                        }
                        if (!"\u6539\u9020\u540e\u5e73\u5747\u8d28\u91cf\u7b49\u522b".equals(key)) continue;
                        map.put("f_avggrade2", json.get((Object)key));
                    }
                    dkzbs.add(map);
                }
                xmxx.put("dkzb", dkzbs);
            } else if (".zip".equalsIgnoreCase(suffix)) {
                com.geoway.onemap.stxf.utils.FileUtils.unpack((String)tempFileName, (String)folder, (String)"gbk");
                String unpackFolder = folder + "/" + fileName.substring(0, fileName.lastIndexOf("."));
                for (File one : new File(unpackFolder).listFiles()) {
                    if (!one.getName().toLowerCase(Locale.ROOT).endsWith("shp")) continue;
                    xmxx = LandShpParser.parse((String)one.getAbsolutePath());
                    break;
                }
            }
            baseResponse.setData((Object)xmxx);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }

    @RequestMapping(value={"/uuidFiles"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse saveUUIDFiles(HttpServletRequest request, @RequestBody List<UUIDFileVo> uuidFileVos) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            for (UUIDFileVo uuidFileVo : uuidFileVos) {
                response.setData((Object)this.baseFileService.saveUUIDFiles(uuidFileVo.getRelationId(), uuidFileVo.getBaseFiles(), uuidFileVo.getUuids(), user));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadTemplate"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void downloadAttach(@RequestParam(name="fileName", required=false) String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream");
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            List tempFiles = this.baseFileService.searchTemplateFile(fileName);
            if (tempFiles == null || tempFiles.size() == 0) {
                return;
            }
            File tempFile = (File)tempFiles.get(0);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            inputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            response.reset();
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Content-Length", "" + tempFile.length());
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(buffer);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }
}

