/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.onemap.core.dto.TDTPOIQueryParam;
import com.geoway.onemap.core.service.TDTPoiService;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tdt"})
public class TDTQueryAction {
    private Logger logger = Logger.getLogger(TDTQueryAction.class);
    @Autowired
    TDTPoiService poiService;

    @RequestMapping(value={"/poi.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse addOne(HttpServletRequest request, @RequestParam(value="url") String url, @RequestParam(value="xzqdm") String xzqdm, @RequestParam(value="keyword") String keyword, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows, @RequestParam(value="bounds") String bounds) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            TDTPOIQueryParam queryParam = new TDTPOIQueryParam();
            queryParam.setCount(rows.toString());
            queryParam.setStart(page.toString());
            queryParam.setKeyWord(keyword);
            queryParam.setQueryType("1");
            queryParam.setLevel("10");
            queryParam.setSpecifyAdminCode(156 + xzqdm);
            queryParam.setMapBound(bounds);
            String userAgent = request.getHeader("user-agent");
            String result = this.poiService.queryPoiResult(queryParam, url, userAgent);
            JSONObject jsonObj = JSONObject.parseObject((String)result);
            response.setData((Object)jsonObj);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }
}

