/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.web.anno.RequireAuth;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zbph/task"})
public class BaseTaskController {
    @Autowired
    private BaseTaskManageService baseTaskManageService;

    @ApiOperation(value="\u521b\u5efa\u4efb\u52a1")
    @RequireAuth
    @RequestMapping(value={"/create.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse create(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            this.baseTaskManageService.create(map, user);
            return BaseObjectResponse.buildSuccessResponse((String)"\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u4efb\u52a1-\u65e0\u6587\u4ef6\u65b9\u5f0f")
    @RequireAuth
    @RequestMapping(value={"/createByJson.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse createByJson(HttpServletRequest request, @RequestBody Map<String, Object> map) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            this.baseTaskManageService.create(map, user);
            return BaseObjectResponse.buildSuccessResponse((String)"\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequireAuth
    @RequestMapping(value={"/listPage.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryPage(String filterParam, String sortParam, int page, int size, HttpServletRequest request) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Page pages = this.baseTaskManageService.queryPage(filterParam, sortParam, page, size, user);
            response.setTotal(Long.valueOf(pages.getTotalElements()));
            response.setRows(pages.getContent());
        }
        catch (Exception e) {
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequireAuth
    @RequestMapping(value={"/detail.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse detail(String id, HttpServletRequest request) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)this.baseTaskManageService.queryInfo(id));
            return baseObjectResponse;
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/download.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadByTaskId(HttpServletResponse response, String taskId) {
        this.baseTaskManageService.downloadByTaskId(response, taskId);
    }

    @RequireAuth
    @GetMapping(value={"/callBack.do"})
    @ResponseBody
    public void callBack(String swapId, String taskId) {
        this.baseTaskManageService.callBack(swapId, taskId);
    }

    @RequireAuth
    @GetMapping(value={"/callBack2.do"})
    @ResponseBody
    public void callBack2(String businessId, String uniqueTaskId) {
        this.baseTaskManageService.callBack2(businessId, uniqueTaskId);
    }
}

