-- 立项项目信息表
drop TABLE if exists tb_zbph_bcgdlx_xmxx;
CREATE TABLE public.tb_zbph_bcgdlx_xmxx (
	f_id varchar(64) NOT NULL,
	f_type varchar(50) NULL,
	f_xmmc varchar(100) NULL,
	f_xzqmc varchar(255) NULL,
	f_xmbh varchar(100) NULL,
	f_create_time timestamp(6) NULL,
	f_userid varchar(64) NULL,
	f_processid varchar(64) NULL,
	f_xzqdm varchar(20) NULL,
	f_check_state varchar(16) NULL,
	f_xzgd_shp_meta varchar(255) NULL,
	f_xzgd_cord_count int4 NULL,
	f_xmzgbm varchar(100) NULL,
	f_pf_pfrq varchar(100) NULL,
	f_pf_pfwh varchar(100) NULL,
	f_jhjgsj varchar(100) NULL,
	f_jhxmztz float8 NULL,
	f_jhjszgm float8 NULL,
	f_jhxzgdmj float8 NULL,
	f_jhxzstmj float8 NULL,
	f_jhtzgzgdmj float8 NULL,
	f_jhtzgzstmj float8 NULL,
	f_jhxzslzb float8 NULL,
	f_jhxzstzb float8 NULL,
	f_username varchar(50) NULL,
	f_usertel varchar(50) NULL,
	f_iswy int2 NULL,
	f_processstatestr varchar(64) NULL,
	f_processstate varchar(64) NULL,
	f_bz text NULL,
	f_update_time timestamp NULL,
	CONSTRAINT tb_zbph_bcgdlx_xmxx_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_bcgdlx_xmxx IS '立项项目信息表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_type IS '项目类型';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xzqmc IS '项目所在地';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_create_time IS '创建时间';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_userid IS '创建人ID';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_processid IS '流程实例ID';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xzqdm IS '行政区划代码';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_check_state IS '审核状态';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xzgd_shp_meta IS '新增耕地shp的投影、分带等信息';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xzgd_cord_count IS '新增耕地shp的坐标数量';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xmzgbm IS '项目主管部门';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_pf_pfrq IS '项目立项批复日期';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_pf_pfwh IS '项目立项批复文号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhjgsj IS '计划竣工时间';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhxmztz IS '计划项目总投资(万元)';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhjszgm IS '计划建设总规模(公顷)';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhxzgdmj IS '计划新增耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhxzstmj IS '计划新增水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhtzgzgdmj IS '计划提质改造耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhtzgzstmj IS '计划提质改造水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhxzslzb IS '计划新增数量指标';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_jhxzstzb IS '计划新增水田指标';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_username IS '填报人姓名';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_usertel IS '填报人电话';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_iswy IS '是否执行过外业核查：0无外业成果，1有外业成果';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_processstatestr IS '流程状态描述';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_processstate IS '流程状态';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_update_time IS '操作时间';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20001', 'tb_zbph_bcgdlx_xmxx', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20002', 'tb_zbph_bcgdlx_xmxx', 'f_type', '项目类型', 0, 'varchar', 50, NULL, 0, '', '', '', 2, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20003', 'tb_zbph_bcgdlx_xmxx', 'f_xmmc', '项目名称', 0, 'varchar', 100, NULL, 0, '', '', '', 3, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20004', 'tb_zbph_bcgdlx_xmxx', 'f_xzqmc', '项目所在地', 0, 'varchar', 255, NULL, 0, '', '', '', 5, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20005', 'tb_zbph_bcgdlx_xmxx', 'f_xmbh', '立项备案编号', 0, 'varchar', 100, NULL, 0, '', '', '', 6, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20006', 'tb_zbph_bcgdlx_xmxx', 'f_create_time', '创建时间', 0, 'timestamp', 6, NULL, 0, 'currentTime', '', '', 4, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20007', 'tb_zbph_bcgdlx_xmxx', 'f_userid', '创建人ID', 0, 'varchar', 64, NULL, 0, 'currentUser', '', '', 7, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20008', 'tb_zbph_bcgdlx_xmxx', 'f_processid', '流程ID', 0, 'varchar', 64, NULL, 0, '', '', '', 8, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20009', 'tb_zbph_bcgdlx_xmxx', 'f_xzqdm', '行政区划代码', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20010', 'tb_zbph_bcgdlx_xmxx', 'f_check_state', '项目状态', 0, 'varchar', 16, NULL, 0, 'p0', '', '', 10, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20011', 'tb_zbph_bcgdlx_xmxx', 'f_xzgd_shp_meta', '新增耕地shp元信息', 0, 'varchar', 255, NULL, 0, '', '', '', 14, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20012', 'tb_zbph_bcgdlx_xmxx', 'f_xzgd_cord_count', '新增耕地shp坐标数', 0, 'int4', 32, NULL, 0, '', '', '', 15, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20013', 'tb_zbph_bcgdlx_xmxx', 'f_xmzgbm', '项目主管部门', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20014', 'tb_zbph_bcgdlx_xmxx', 'f_pf_pfrq', '项目立项批复日期', 0, 'timestamp', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20015', 'tb_zbph_bcgdlx_xmxx', 'f_pf_pfwh', '项目立项批复文号', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20016', 'tb_zbph_bcgdlx_xmxx', 'f_jhjgsj', '计划竣工时间', 0, 'timestamp', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20017', 'tb_zbph_bcgdlx_xmxx', 'f_jhxmztz', '计划项目总投资(万元)', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20018', 'tb_zbph_bcgdlx_xmxx', 'f_jhjszgm', '计划建设总规模(公顷)', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20019', 'tb_zbph_bcgdlx_xmxx', 'f_jhxzgdmj', '计划新增耕地面积', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20020', 'tb_zbph_bcgdlx_xmxx', 'f_jhxzstmj', '计划新增水田面积', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20021', 'tb_zbph_bcgdlx_xmxx', 'f_jhtzgzgdmj', '计划提质改造耕地面积', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20022', 'tb_zbph_bcgdlx_xmxx', 'f_jhtzgzstmj', '计划提质改造水田面积', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20023', 'tb_zbph_bcgdlx_xmxx', 'f_jhxzslzb', '计划新增数量指标', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20024', 'tb_zbph_bcgdlx_xmxx', 'f_jhxzstzb', '计划新增水田指标', 0, 'numeric', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20025', 'tb_zbph_bcgdlx_xmxx', 'f_username', '填报人姓名', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20026', 'tb_zbph_bcgdlx_xmxx', 'f_usertel', '填报人电话', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, 22, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20027', 'tb_zbph_bcgdlx_xmxx', 'f_iswy', '是否外业核查过', 0, 'int2', 16, NULL, 0, '0', '', '', 16, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20028', 'tb_zbph_bcgdlx_xmxx', 'f_processstatestr', '流程状态信息', 0, 'varchar', 64, NULL, 0, '', '', '', 8, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20029', 'tb_zbph_bcgdlx_xmxx', 'f_processstate', '流程状态', 0, 'varchar', 64, NULL, 0, '', '', '', 8, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20030', 'tb_zbph_bcgdlx_xmxx', 'f_bz', '备注', 0, 'varchar', 10000, NULL, 0, '', '', '', 8, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20031', 'tb_zbph_bcgdlx_xmxx', 'f_update_time', '更新时间', 0, 'timestamp', 6, NULL, 0, '', '', '', 8, '6', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);

-- 立项项目拍照点位信息
drop TABLE if exists tb_zbph_bcgdlx_pzd;
CREATE TABLE tb_zbph_bcgdlx_pzd (
	f_id varchar(64) NOT NULL, -- 主键
	f_project_id varchar(64) NULL, -- 项目ID
	f_lat numeric(12, 9) NULL,
	f_lng numeric(12, 9) NULL,
	f_radius numeric(32, 9) NULL,
	f_type numeric(2) NULL, -- 1拍照点,2补充拍照点
	f_dk_no varchar(255) NULL, -- 地块号
	CONSTRAINT tb_zbph_bcgdlx_pzd_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_bcgdlx_pzd IS '立项项目拍照点位信息';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdlx_pzd.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_pzd.f_project_id IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_pzd.f_type IS '1拍照点,2补充拍照点';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_pzd.f_dk_no IS '地块号';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20101', 'tb_zbph_bcgdlx_pzd', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20102', 'tb_zbph_bcgdlx_pzd', 'f_type', '拍照点类型', 0, 'numeric', 2, 0, 0, '', '', '', 7, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20103', 'tb_zbph_bcgdlx_pzd', 'f_lat', '纬度', 0, 'numeric', 12, 9, 0, '', '', '', 4, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20104', 'tb_zbph_bcgdlx_pzd', 'f_lng', '经度', 0, 'numeric', 12, 9, 0, '', '', '', 5, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20105', 'tb_zbph_bcgdlx_pzd', 'f_radius', '半径', 0, 'numeric', 32, 9, 0, '', '', '', 6, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20106', 'tb_zbph_bcgdlx_pzd', 'f_project_id', '项目id', 0, 'varchar', 64, NULL, 0, '', '', '', 2, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20107', 'tb_zbph_bcgdlx_pzd', 'f_dk_no', '地块号', 0, 'varchar', 64, NULL, 0, '', '', '', 8, '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- 立项项目范围空间表
drop TABLE if exists tb_zbph_bcgdlx_xmfw;
CREATE TABLE tb_zbph_bcgdlx_xmfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_project_id varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	xzqmc varchar(50) NULL, -- 行政区名称
	xzqdm varchar(50) NULL, -- 行政区代码
	f_objectid int4 NULL,
	f_jbxx_xmmc varchar(255) NULL, -- 基本信息_项目名称
	f_jbxx_xzqmc varchar(255) NULL, -- 基本信息_行政区名称
	f_jbxx_xzqdm varchar(255) NULL, -- 行政区代码
	f_ys_xmbh varchar(255) NULL, -- 项目编号
	f_xmlx varchar(50) NULL, -- 项目类型
	f_dkmj numeric NULL, -- 地块面积
	f_shp_name varchar(255) NULL, -- shp文件名
	f_jzds int2 NULL, -- 界址点数
	f_dkbh varchar(200) NULL, -- 地块编号
	f_dkmc varchar(200) NULL, -- 地块名称
	f_txsx varchar(32) NULL, -- 图形属性
	f_tfh varchar(200) NULL, -- 图幅号
	f_dkyt varchar(200) NULL, -- 地块用途
	f_bz varchar(200) NULL, -- 备注
	CONSTRAINT tb_zbph_bcgdlx_xmfw_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_bcgdlx_xmfw_shape_idx ON public.tb_zbph_bcgdlx_xmfw USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_bcgdlx_xmfw IS '立项项目范围空间表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_project_id IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_jbxx_xmmc IS '基本信息_项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_jbxx_xzqmc IS '基本信息_行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_jbxx_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_ys_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_xmlx IS '项目类型';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_dkmj IS '地块面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_shp_name IS 'shp文件名';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_jzds IS '界址点数';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_dkbh IS '地块编号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_tfh IS '图幅号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_dkyt IS '地块用途';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmfw.f_bz IS '备注';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20201', 'tb_zbph_bcgdlx_xmfw', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20202', 'tb_zbph_bcgdlx_xmfw', 'f_project_id', '项目ID', 1, 'varchar', 64, NULL, 0, '', '', '', 3, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20203', 'tb_zbph_bcgdlx_xmfw', 'f_shape', '项目范围', 1, 'geometry', NULL, NULL, 0, '', '', '', 2, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20204', 'tb_zbph_bcgdlx_xmfw', 'xzqmc', '行政区名称', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20205', 'tb_zbph_bcgdlx_xmfw', 'xzqdm', '行政区代码', 0, 'varchar', 50, NULL, 0, '', '', '', 5, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20206', 'tb_zbph_bcgdlx_xmfw', 'f_objectid', '序号', 0, 'int4', 32, NULL, 0, '', '', '', 6, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20207', 'tb_zbph_bcgdlx_xmfw', 'f_jbxx_xmmc', '基本信息_项目名称', 0, 'varchar', 255, NULL, 0, '', '', '', 7, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20208', 'tb_zbph_bcgdlx_xmfw', 'f_jbxx_xzqmc', '基本信息_行政区名称', 0, 'varchar', 255, NULL, 0, '', '', '', 8, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20209', 'tb_zbph_bcgdlx_xmfw', 'f_jbxx_xzqdm', '基本信息_行政区代码', 0, 'varchar', 255, NULL, 0, '', '', '', 9, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20210', 'tb_zbph_bcgdlx_xmfw', 'f_ys_xmbh', '项目编号', 0, 'varchar', 255, NULL, 0, '', '', '', 10, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20211', 'tb_zbph_bcgdlx_xmfw', 'f_xmlx', '项目类型', 0, 'varchar', 50, NULL, 0, '', '', '', 11, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20212', 'tb_zbph_bcgdlx_xmfw', 'f_shp_name', 'shp文件名', 0, 'varchar', 255, NULL, 0, '', '', '', 13, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20213', 'tb_zbph_bcgdlx_xmfw', 'f_dkmj', '面积', 0, 'numeric', 0, NULL, 0, '', '', '', 12, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20214', 'tb_zbph_bcgdlx_xmfw', 'f_jzds', '界址点数', 0, 'int4', 16, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20215', 'tb_zbph_bcgdlx_xmfw', 'f_dkbh', '地块编号', 0, 'varchar', 200, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20216', 'tb_zbph_bcgdlx_xmfw', 'f_dkmc', '地块名称', 0, 'varchar', 200, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20217', 'tb_zbph_bcgdlx_xmfw', 'f_txsx', '图形属性', 0, 'varchar', 32, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20218', 'tb_zbph_bcgdlx_xmfw', 'f_tfh', '图幅号', 0, 'varchar', 200, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20219', 'tb_zbph_bcgdlx_xmfw', 'f_dkyt', '地块用途', 0, 'varchar', 200, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20220', 'tb_zbph_bcgdlx_xmfw', 'f_bz', '地块用途', 0, 'varchar', 200, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- 立项项目补充耕地地块空间表
drop TABLE if exists tb_zbph_bcgdlx_xzgdfw;
CREATE TABLE tb_zbph_bcgdlx_xzgdfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_project_id varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	xzqmc varchar(50) NULL, -- 行政区名称
	xzqdm varchar(50) NULL, -- 行政区代码
	f_ys_xmbh varchar(255) NULL, -- 项目编号
	f_jbxx_xmmc varchar(255) NULL, -- 项目名称
	f_objectid int4 NULL,
	f_dkbh varchar(50) NULL, -- 地块号
	f_dkmc varchar(255) NULL, -- 地块名称
	f_dkmj numeric NULL, -- 地块面积（默认单位：公顷）
	f_dkyt varchar(255) NULL, -- 用途
	f_tfh varchar(255) NULL, -- 图幅号（多个图幅号之间不能出现空格，通过顿号进行分割）
	f_tblx varchar(50) NULL, -- 图斑类型（新增、提质、改造、提质改造）
	f_dlbm varchar(50) NULL, -- 地类（水田、水浇地、旱地）
	f_gzqpjzldb varchar(50) NULL, -- 耕地平均质量等别（改造前平均质量等别）
	f_gzhpjzldb varchar(50) NULL, -- 改造后平均质量等别
	f_shp_name varchar(255) NULL, -- shp文件名
	f_yuliu varchar(255) NULL, -- 预留字段
	f_txsx varchar(32) NULL, -- 图形属性
	f_xzgdmj numeric NULL, -- 新增耕地面积
	f_xzstmj numeric NULL, -- 新增水田面积
	CONSTRAINT tb_zbph_bcgdlx_xzgdfw_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_bcgdlx_xzgdfw_shape_idx ON public.tb_zbph_bcgdlx_xzgdfw USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_bcgdlx_xzgdfw IS '立项项目补充耕地地块空间表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_project_id IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_ys_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_jbxx_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_dkbh IS '地块号';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_dkmj IS '地块面积（默认单位：公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_dkyt IS '用途';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_tfh IS '图幅号（多个图幅号之间不能出现空格，通过顿号进行分割）';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_tblx IS '图斑类型（新增、提质、改造、提质改造）';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_dlbm IS '地类（水田、水浇地、旱地）';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_gzqpjzldb IS '耕地平均质量等别（改造前平均质量等别）';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_gzhpjzldb IS '改造后平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_shp_name IS 'shp文件名';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_yuliu IS '预留字段';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_xzgdmj IS '新增耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdlx_xzgdfw.f_xzstmj IS '新增水田面积';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20301', 'tb_zbph_bcgdlx_xzgdfw', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20302', 'tb_zbph_bcgdlx_xzgdfw', 'f_ys_xmbh', '项目编号', 0, 'varchar', 255, NULL, 0, '', '', '', 6, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20303', 'tb_zbph_bcgdlx_xzgdfw', 'f_objectid', '序号', 0, 'int4', 32, NULL, 0, '', '', '', 8, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20304', 'tb_zbph_bcgdlx_xzgdfw', 'f_shp_name', 'shp文件名', 0, 'varchar', 255, NULL, 0, '', '', '', 18, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20305', 'tb_zbph_bcgdlx_xzgdfw', 'f_tblx', '图斑类型', 0, 'varchar', 50, NULL, 0, '', '', '', 14, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20306', 'tb_zbph_bcgdlx_xzgdfw', 'f_dlbm', '地类', 0, 'varchar', 50, NULL, 0, '', '', '', 15, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20307', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkbh', '地块号', 0, 'varchar', 50, NULL, 0, '', '', '', 9, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20308', 'tb_zbph_bcgdlx_xzgdfw', 'f_shape', '图斑数据', 0, 'geometry', 0, NULL, 0, '', '', '', 3, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20309', 'tb_zbph_bcgdlx_xzgdfw', 'xzqdm', '行政区代码', 0, 'varchar', 50, NULL, 0, '', '', '', 5, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20310', 'tb_zbph_bcgdlx_xzgdfw', 'f_jbxx_xmmc', '项目名称', 0, 'varchar', 255, NULL, 0, '', '', '', 7, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20311', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkmc', '地块名称', 0, 'varchar', 255, NULL, 0, '', '', '', 10, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20312', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkyt', '用途', 0, 'varchar', 255, NULL, 0, '', '', '', 12, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20313', 'tb_zbph_bcgdlx_xzgdfw', 'f_tfh', '图幅号', 0, 'varchar', 255, NULL, 0, '', '', '', 13, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20314', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkmj', '地块面积', 0, 'numeric', 0, NULL, 0, '', '', '', 11, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20315', 'tb_zbph_bcgdlx_xzgdfw', 'f_gzhpjzldb', '改造后平均质量等别', 0, 'varchar', 50, NULL, 0, '', '', '', 17, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20316', 'tb_zbph_bcgdlx_xzgdfw', 'f_project_id', '项目ID', 0, 'varchar', 64, NULL, 0, '', '', '', 2, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20317', 'tb_zbph_bcgdlx_xzgdfw', 'xzqmc', '行政区名称', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20318', 'tb_zbph_bcgdlx_xzgdfw', 'f_yuliu', '预留', 0, 'varchar', 200, NULL, 0, '', '', '', 19, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20319', 'tb_zbph_bcgdlx_xzgdfw', 'f_gzqpjzldb', '耕地平均质量等别（改造前平均质量等别）', 0, 'varchar', 50, NULL, 0, '', '', '', 16, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20320', 'tb_zbph_bcgdlx_xzgdfw', 'f_xzgdmj', '新增耕地面积', 0, 'numeric', 0, NULL, 0, '', '', '', 20, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20321', 'tb_zbph_bcgdlx_xzgdfw', 'f_xzstmj', '新增水田面积', 0, 'numeric', 0, NULL, 0, '', '', '', 20, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
