/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.stxf.service.BaseFileDownloadService;
import com.geoway.zhgd.domain.BaseFileDownload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/baseFileDownload"})
public class BaseFileDownloadAction {
    @Autowired
    private BaseFileDownloadService baseFileDownloadService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public EasyUIResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page pages = this.baseFileDownloadService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveBaseFileDownload.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveBaseFileDownload(@ModelAttribute BaseFileDownload baseFileDownload) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            BaseFileDownload baseFileDownloadDb = this.baseFileDownloadService.saveBaseFileDownload(baseFileDownload);
            response.setData((Object)baseFileDownloadDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delBaseFileDownloadById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse delBaseFileDownloadById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.baseFileDownloadService.delBaseFileDownload(new String[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getBaseFileDownloadById"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getBaseFileDownloadById(@RequestParam(name="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            BaseFileDownload baseFileDownload = this.baseFileDownloadService.findById(id);
            response.setData((Object)baseFileDownload);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

