/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.util;

import com.deepoove.poi.XWPFTemplate;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WriteWordUtil {
    public void writeDocx(String path, Map<String, String> map) throws Exception {
        FileInputStream is = new FileInputStream(path);
        XWPFDocument doc = new XWPFDocument((InputStream)is);
    }

    private void replaceInPara(XWPFDocument doc, Map<String, Object> params) {
        Iterator iterator = doc.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph para = (XWPFParagraph)iterator.next();
            this.replaceInPara(para, params);
        }
    }

    private void replaceInPara(XWPFParagraph para, Map<String, Object> params) {
        String txt = para.getParagraphText();
        if (this.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            for (int i = 0; i < runs.size(); ++i) {
                XWPFRun run = (XWPFRun)runs.get(i);
                String runText = run.toString();
                int fontSize = run.getFontSize();
                String fontFamily = run.getFontFamily();
                boolean isBold = run.isBold();
                Matcher matcher = this.matcher(runText);
                if (!matcher.find()) continue;
                while ((matcher = this.matcher(runText)).find()) {
                    runText = matcher.replaceFirst(String.valueOf(params.get(matcher.group(1))));
                }
                para.removeRun(i);
                if (runText.equals("null")) {
                    runText = "";
                }
                XWPFRun xwpfRun = para.insertNewRun(i);
                xwpfRun.setFontSize(fontSize);
                xwpfRun.setFontFamily(fontFamily);
                xwpfRun.setBold(isBold);
                xwpfRun.setText(runText);
            }
        }
    }

    private void replaceInTable(XWPFDocument doc, Map<String, Object> params) {
        Iterator iterator = doc.getTablesIterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            List rows = table.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    String cellTextString = cell.getText();
                    for (Map.Entry<String, Object> e : params.entrySet()) {
                        if (!cellTextString.contains("${" + e.getKey() + "}")) continue;
                        cellTextString = cellTextString.replace("${" + e.getKey() + "}", e.getValue().toString());
                    }
                    cell.removeParagraph(0);
                    if (cellTextString.contains("${") && cellTextString.contains("}")) {
                        cellTextString = "";
                    }
                    cell.setText(cellTextString);
                }
            }
        }
    }

    private Matcher matcher(String str) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}", 2);
        Matcher matcher = pattern.matcher(str);
        return matcher;
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void printCoreProperties(POIXMLProperties.CoreProperties coreProps) {
        System.out.println(coreProps.getCategory());
        System.out.println(coreProps.getCreator());
        System.out.println(coreProps.getCreated());
        System.out.println(coreProps.getTitle());
    }

    public static String templateWrite(String filePath, Map<String, Object> params, String outFilePath) throws Exception {
        FileInputStream is = new FileInputStream(filePath);
        WriteWordUtil writeWordUtil = new WriteWordUtil();
        XWPFDocument doc = new XWPFDocument((InputStream)is);
        writeWordUtil.replaceInPara(doc, params);
        writeWordUtil.replaceInTable(doc, params);
        FileOutputStream os = new FileOutputStream(outFilePath);
        doc.write((OutputStream)os);
        writeWordUtil.close(os);
        writeWordUtil.close(is);
        os.flush();
        ((OutputStream)os).close();
        return "";
    }

    public static String templateWrite2(String filePath, Map<String, Object> params, String outFilePath) throws Exception {
        XWPFTemplate template = XWPFTemplate.compile((String)filePath).render(params);
        FileOutputStream out = new FileOutputStream(outFilePath);
        template.write((OutputStream)out);
        out.flush();
        out.close();
        template.close();
        return "";
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("f_name", "\u9879\u76ee1");
        params.put("f_check", "\u2611\u662f \u25a1\u5426");
        WriteWordUtil.templateWrite("d:/data/template-tchc.docx", params, "d:/data/zhjg/test.docx");
    }
}

