-- public.tb_zbph_zbk_rkmx_qdl definition

-- Drop table

-- DROP TABLE public.tb_zbph_zbk_rkmx_qdl;

CREATE TABLE public.tb_zbph_zbk_rkmx_qdl (
	f_id varchar NULL,
	f_qdlbm varchar NOT NULL, -- 前地类编码
	f_qdlmc varchar NOT NULL, -- 前地类名称
	f_rkzbgm numeric(20, 4) NOT NULL, -- 前地类-入库指标规模
	f_zbid varchar NULL, -- 关联rkmx表指标id
	f_dkid varchar NULL, -- 关联rkmx表指标所关联的dkid
	f_querytime varchar NULL, -- 查询前地类的年份（YYYY）
	f_sid varchar NULL, -- 入库流水号id
	f_zblx varchar NULL -- 指标类型
);
COMMENT ON TABLE public.tb_zbph_zbk_rkmx_qdl IS '入库指标前地类';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_qdlbm IS '前地类编码';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_qdlmc IS '前地类名称';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_rkzbgm IS '前地类-入库指标规模';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_zbid IS '关联rkmx表指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_dkid IS '关联rkmx表指标所关联的dkid';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_querytime IS '查询前地类的年份（YYYY）';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_sid IS '入库流水号id';
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx_qdl.f_zblx IS '指标类型';