/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import cn.hutool.core.util.StrUtil;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.support.SnowflakeIdWorker;
import com.geoway.onemap.biz.service.system.RedisService;
import com.geoway.onemap.stxf.utils.FileUnZipRar;
import com.geoway.onemap.stxf.utils.ShpUtils;
import com.geoway.onemap.zbph.service.base.GraphicAnalysisService;
import com.geoway.onemap.zbph.supoort.FileUploadUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/upload"})
public class UploadAction {
    private static final Logger log = LoggerFactory.getLogger(UploadAction.class);
    @Autowired
    RedisService redisService;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private GraphicAnalysisService graphicAnalysisService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.xzgdfw.field:}")
    protected String xzgdfwField;

    @RequestMapping(value={"/uploadShp.do"})
    @ResponseBody
    public BaseResponse uploadShpFile(HttpServletRequest request, @RequestParam(name="file") MultipartFile[] mfiles) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            File[] files = this.saveToDisk(mfiles, this.uploadDir + File.separator + "temp" + File.separator + UUID.randomUUID());
            String uuid = UUID.randomUUID().toString();
            ArrayList<String> path = new ArrayList<String>();
            for (File file : files) {
                path.add(file.getAbsolutePath());
                if (!file.getName().toLowerCase().endsWith(".shp")) continue;
                List properties = ShpUtils.getNoGeoProperties((String)file.getAbsolutePath());
                result.put("properties", properties);
                break;
            }
            String pathStr = StringUtils.join(path, (String)";");
            this.cachePath(uuid, Base64.encodeBase64String((byte[])pathStr.getBytes("UTF-8")));
            result.put("uuid", uuid);
            baseObjectResponse.setData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/uploadData.do"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public BaseResponse uploadData(HttpServletRequest request, @RequestParam(name="file") MultipartFile mfile) throws IOException {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        Map<String, String> rtnMap = new HashMap();
        String dataFileName = "";
        try {
            if (mfile == null) {
                return BaseResponse.buildFailuaResponse((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a");
            }
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            String fileName = mfile.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uuid = String.valueOf(worker.nextId());
            String tempFileName = this.uploadDir + File.separator + sdf.format(new Date()) + File.separator + uuid + File.separator + fileName;
            File tempFile = new File(tempFileName);
            tempFile.mkdirs();
            mfile.transferTo(tempFile);
            String createPath = "";
            if (".txt".equalsIgnoreCase(suffix)) {
                rtnMap = ShpUtils.readTxt2WKT((File)tempFile);
                dataFileName = fileName;
            } else if (".shp".equalsIgnoreCase(suffix)) {
                rtnMap = ShpUtils.readShp2WKT((String)tempFileName);
                dataFileName = fileName;
            } else if (".zip".equalsIgnoreCase(suffix)) {
                String destName = tempFileName.toLowerCase().replace(".zip", "");
                FileUnZipRar.unZipFiles((String)tempFileName, (String)destName);
                File dir = new File(destName);
                String shpPath = FileUnZipRar.seachFirstFileBySuffix((File)dir);
                String prjPath = FileUnZipRar.seachFirstPrjBySuffix((File)dir);
                String cpgPath = FileUnZipRar.seachFirstCpgBySuffix((File)dir);
                if (StrUtil.isEmpty((CharSequence)shpPath)) {
                    return BaseObjectResponse.buildFailuaResponse((String)"\u538b\u7f29\u5305\u4e2d\u6ca1\u627e\u5230\u6709\u6548 .shp\u6587\u4ef6\uff01");
                }
                if (StrUtil.isEmpty((CharSequence)shpPath)) {
                    return BaseObjectResponse.buildFailuaResponse((String)"\u538b\u7f29\u5305\u4e2d\u7f3a\u5c11\u7a7a\u95f4\u5b9a\u4e49 .prj\u6587\u4ef6\uff01");
                }
                List<String> propList = null;
                if (StrUtil.isNotEmpty((CharSequence)this.xzgdfwField)) {
                    propList = Arrays.asList(this.xzgdfwField.replaceAll(" ", "").split(","));
                }
                rtnMap = ShpUtils.readValidShp2WKT2((String)shpPath, (String)prjPath, (String)cpgPath, propList);
                this.cachePath(uuid, Base64.encodeBase64String((byte[])shpPath.getBytes("UTF-8")));
                dataFileName = shpPath.substring(shpPath.lastIndexOf(File.separator) + 1);
            } else if (".rar".equalsIgnoreCase(suffix)) {
                String destName = tempFileName.toLowerCase().replace(".rar", "");
                FileUnZipRar.unRarFile((String)tempFileName, (String)destName);
                File dir = new File(destName);
                String shpPath = FileUnZipRar.seachFirstFileBySuffix((File)dir);
                String prjPath = FileUnZipRar.seachFirstPrjBySuffix((File)dir);
                this.cachePath(uuid, Base64.encodeBase64String((byte[])shpPath.getBytes("UTF-8")));
                if (!StrUtil.isNotBlank((CharSequence)shpPath)) return BaseObjectResponse.buildFailuaResponse((String)"\u4e0d\u662f\u6709\u6548\u7684shp\u6587\u4ef6");
                rtnMap = ShpUtils.readShp2WKT2((String)shpPath, (String)prjPath);
                dataFileName = shpPath.substring(shpPath.lastIndexOf(File.separator) + 1);
            } else if (".xlsx".equalsIgnoreCase(suffix) || ".xls".equalsIgnoreCase(suffix)) {
                rtnMap = ShpUtils.readExcel2Wkt((File)tempFile);
            }
            createPath = tempFile.getAbsolutePath().substring(this.uploadDir.length());
            rtnMap.put("uuid", uuid);
            rtnMap.put("fileName", dataFileName);
            rtnMap.put("createPath", createPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getMessage();
            errMsg = errMsg.indexOf("LinearRing") > 0 ? "\u9762\u72b6\u56fe\u5f62\u5750\u6807\u6709\u4e0d\u5c01\u95ed\u60c5\u51b5\uff0c\u8bf7\u6838\u5b9e\uff01" : "\u5750\u6807\u683c\u5f0f\u6709\u8bef\u3001\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u6838\u5b9e\uff01";
            return BaseObjectResponse.buildFailuaResponse((String)errMsg);
        }
        if (rtnMap != null && "FAILURE".equals(rtnMap.get("status").toString())) {
            String msg = rtnMap.get("message").toString();
            return BaseObjectResponse.buildFailuaResponse((String)msg);
        }
        baseObjectResponse.setData(rtnMap);
        return baseObjectResponse;
    }

    @RequestMapping(value={"/uploadOne.do"})
    @ResponseBody
    public BaseResponse uploadOneFile(HttpServletRequest request, @RequestParam(name="file") MultipartFile mfile) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            String uuid = UUID.randomUUID().toString();
            result.put("createPath", this.fileUploadUtil.upload(mfile));
            result.put("uuid", uuid);
            baseObjectResponse.setData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @GetMapping(value={"/getUrl.do"})
    @ResponseBody
    public BaseResponse getUrl(@RequestParam String path) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        baseObjectResponse.setData((Object)this.fileUploadUtil.downloadUrl(path));
        return baseObjectResponse;
    }

    @PostMapping(value={"/getBatchUrl.do"})
    @ResponseBody
    public BaseResponse getBatchUrl(@RequestBody Map<String, String> map) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        baseObjectResponse.setData((Object)this.fileUploadUtil.batchDownloadUrl(map));
        return baseObjectResponse;
    }

    @RequestMapping(value={"/GraphicAnalysis.do"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public BaseResponse GraphicAnalysis(HttpServletRequest request, @RequestParam(name="file") MultipartFile mfile, String type) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            baseObjectResponse.setData((Object)this.graphicAnalysisService.analysis(mfile, type));
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return baseObjectResponse;
    }

    private File[] saveToDisk(MultipartFile[] files, String destFolder) throws Exception {
        File destDir = new File(destFolder);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] destFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            MultipartFile file = files[i];
            String fileName = file.getOriginalFilename();
            String fileFullName = destDir + File.separator + fileName;
            File dest = new File(fileFullName);
            file.transferTo(dest);
            destFiles[i] = dest;
        }
        return destFiles;
    }

    private synchronized void cachePath(String key, String val) {
        try {
            String old = this.redisService.get(key);
            String nowVal = (old == null ? "" : old + ";") + val;
            this.redisService.set(key, nowVal, 6000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

