/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import cn.hutool.core.util.StrUtil;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.dto.base.QrdDownloadDTO;
import com.geoway.onemap.zbph.dto.zgck.ZgckDTO;
import com.geoway.onemap.zbph.dto.zgck.ZgckYtgzDTO;
import com.geoway.onemap.zbph.service.zgck.ZgckBcgdDkDetailService;
import com.geoway.onemap.zbph.service.zgck.ZgckManagerService;
import com.geoway.onemap.zbph.service.zgck.ZgckXmxxService;
import com.geoway.stxf.action.zbph.BaseProcessXmxxController;
import com.geoway.web.anno.RequireAuth;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/zbph/zgck"})
public class ZgckAction
extends BaseProcessXmxxController<ZgckXmxx, ZgckXmxxService, ZgckDTO, ZgckManagerService> {
    private static final Logger log = LoggerFactory.getLogger(ZgckAction.class);
    @Autowired
    private ZgckBcgdDkDetailService bcgdDetailService;

    public ZgckAction(ZgckXmxxService xmxxService, ZgckManagerService managerService) {
        super(xmxxService, managerService);
    }

    @RequireAuth
    @RequestMapping(value={"/queryByXmmc.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryByXmmc(HttpServletRequest request, String xmmc) {
        try {
            String parm = "Q_f_processgroup_S_EQ=FNCK;Q_f_cklx_S_EQ=01;Q_f_processstate_S_EQ=p51;Q_f_xmmc_S_LK=" + xmmc;
            List zgckxm = ((ZgckXmxxService)this.service).findByFilter(parm);
            ArrayList<ZgckYtgzDTO> zgxmxx = new ArrayList<ZgckYtgzDTO>();
            for (ZgckXmxx zgckXmxx : zgckxm) {
                ZgckYtgzDTO zgckYtgzDTO = new ZgckYtgzDTO();
                zgckYtgzDTO.setXmmc(zgckXmxx.getXmmc());
                zgckYtgzDTO.setBcgdqrdbh(zgckXmxx.getBcgdxxqrdh());
                String url = ConfigConstant.SysConfig.System_Path + "/zbph/zgck/downloadQrd.do?xmid=" + zgckXmxx.getXmid() + "&isZip=false";
                zgckYtgzDTO.setGgqrdurl(url);
                zgxmxx.add(zgckYtgzDTO);
            }
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData(zgxmxx);
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("detail.json", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @Override
    @RequireAuth
    @RequestMapping(value={"/detail.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse detail(HttpServletRequest request, String xmid) {
        try {
            String dkxx = request.getParameter("dkxx");
            ZgckDTO dto = ((ZgckManagerService)this.managerService).detailByXmid(xmid, StrUtil.isBlank((CharSequence)dkxx) || dkxx.toString().equals("1"));
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)dto);
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("detail.json", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/findByZbId.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findByZbId(HttpServletRequest request, @RequestParam String zbId) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)this.bcgdDetailService.findByzbId(zbId));
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("/zbph/zgck/findByZbId.json", (Throwable)e);
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/blockSplit"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse blockSplit(HttpServletRequest request, @RequestParam String xmid) {
        try {
            this.lockUtil.getLock(((ZgckXmxx)((ZgckXmxxService)this.service).getDefault()).getLshType() + "_" + xmid);
            ((ZgckManagerService)this.managerService).blockSplit(xmid);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/findByXmbh.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findByXmbh(HttpServletRequest request, @RequestParam String xmbh) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)((ZgckManagerService)this.managerService).findByXmbh(xmbh));
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("/zbph/zgck/findByXmbh.json", (Throwable)e);
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/verification.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse verification(HttpServletRequest request, String xmid, String approvalOffice, String approvalTime, String verificationTime, String filterParam) {
        try {
            return BaseObjectResponse.buildSuccessResponse((String)((ZgckManagerService)this.managerService).updateVerification(xmid, approvalOffice, approvalTime, verificationTime, filterParam));
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/unhook.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse unhook(HttpServletRequest request, String xmid, String unhookInfo, String filterParam) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return BaseObjectResponse.buildSuccessResponse((String)((ZgckManagerService)this.managerService).unhook(xmid, unhookInfo, user, filterParam));
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/dlGroupArea.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse dlGroupArea(HttpServletRequest request, String taskId) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            BaseObjectResponse response = new BaseObjectResponse();
            response.setData((Object)((ZgckManagerService)this.managerService).getDlbmGroupArea(taskId));
            return response;
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/dataVerity.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse sendDataVerity(HttpServletRequest request, @RequestBody List<TaskBlockDTO> blocks) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            BaseObjectResponse response = new BaseObjectResponse();
            response.setData((Object)((ZgckManagerService)this.managerService).sendDataVerity(blocks));
            return response;
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/downloadQrd.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadQrd(HttpServletRequest request, HttpServletResponse response, String xmid, String filterParam, String qrdType, Boolean isZip, Boolean isDelOld) {
        QrdDownloadDTO qrdDownloadDTO = new QrdDownloadDTO();
        qrdDownloadDTO.setXmid(xmid);
        qrdDownloadDTO.setFilterParam(filterParam);
        qrdDownloadDTO.setIsZip(isZip);
        qrdDownloadDTO.setQrdType(qrdType);
        qrdDownloadDTO.setIsDelOld(isDelOld);
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            qrdDownloadDTO.setUser(user);
        }
        catch (Exception e) {
            SysUser user = new SysUser();
            user.setId("1");
            user.setUsername("admin");
            user.setAlisname("\u7cfb\u7edf\u7528\u6237");
            qrdDownloadDTO.setUser(user);
        }
        ((ZgckManagerService)this.managerService).downloadQrd(response, qrdDownloadDTO);
    }

    @RequestMapping(value={"/repeatVerify.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse blockRepeatVerify(@RequestBody List<String> wkts) {
        try {
            ((ZgckManagerService)this.managerService).blockRepeatVerify(wkts);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }
}

