-- public.v_zbph_zbk_zbtj_xzq source

CREATE OR REPLACE VIEW public.v_zbph_zbk_zbtj_xzq
AS SELECT sum(b.sygd) AS sygd,
    sum(b.syst) AS syst,
    sum(b.rkgd) AS rkgd,
    sum(b.rkst) AS rkst,
    sum(b.ckgd) AS ckgd,
    sum(b.ckst) AS ckst,
    b.zbxzqdm,
    b.f_zblx AS zblx,
    b.f_pcode AS pcode,
    b.f_zbxzqmc AS zbxzqmc,
    sum(b.sdgd) AS sdgd,
    sum(b.sdst) AS sdst
   FROM ( SELECT a.sygd,
            a.syst,
            a.rkgd,
            a.rkst,
            a.ckgd,
            a.ckst,
            a.sdgd,
            a.sdst,
            a.zbxzqdm,
            a.f_zblx,
            tr.f_pcode,
            tr.f_name AS f_zbxzqmc
           FROM ( SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                    sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    r.f_zbxzqdm AS zbxzqdm,
                    r.f_zblx
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY r.f_zbxzqdm, r.f_zblx
                UNION
                 SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                     sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    "substring"(r.f_zbxzqdm::text, 1, 4) || '00'::text AS zbxzqdm,
                    r.f_zblx
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY ("substring"(r.f_zbxzqdm::text, 1, 4) || '00'::text), r.f_zblx
                UNION
                 SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                     sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    "substring"(r.f_zbxzqdm::text, 1, 2) || '0000'::text AS zbxzqdm,
                    r.f_zblx
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY ("substring"(r.f_zbxzqdm::text, 1, 2) || '0000'::text), r.f_zblx) a
             LEFT JOIN tbime_region tr ON a.zbxzqdm::text = tr.f_code::text) b
  GROUP BY b.zbxzqdm, b.f_zblx, b.f_pcode, b.f_zbxzqmc;


-- public.v_zbph_zbk_zbtj_dl source

CREATE OR REPLACE VIEW public.v_zbph_zbk_zbtj_dl
AS SELECT sum(b.sygd) AS sygd,
    sum(b.syst) AS syst,
    sum(b.rkgd) AS rkgd,
    sum(b.rkst) AS rkst,
    sum(b.ckgd) AS ckgd,
    sum(b.ckst) AS ckst,
    b.zbxzqdm,
    b.f_zblx AS zblx,
    b.f_pcode AS pcode,
    b.f_zbxzqmc AS zbxzqmc,
    b.gddb,
    b.dlmc,
    b.dlbm,
    sum(b.sdgd) AS sdgd,
    sum(b.sdst) AS sdst
   FROM ( SELECT a.sygd,
            a.syst,
            a.rkgd,
            a.rkst,
            a.ckgd,
            a.ckst,
            a.sdgd,
            a.sdst,
            a.zbxzqdm,
            a.f_zblx,
            a.gddb,
            a.dlbm,
            a.dlmc,
            tr.f_pcode,
            tr.f_name AS f_zbxzqmc
           FROM ( SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                     sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    r.f_zbxzqdm AS zbxzqdm,
                    r.f_zblx,
                    r.f_gddb AS gddb,
                    r.f_dlmc AS dlmc,
                    r.f_dlbm AS dlbm
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY r.f_zbxzqdm, r.f_zblx, r.f_dlbm, r.f_dlmc, r.f_gddb
                UNION
                 SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                    sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    "substring"(r.f_zbxzqdm::text, 1, 4) || '00'::text AS zbxzqdm,
                    r.f_zblx,
                    r.f_gddb AS gddb,
                    r.f_dlmc AS dlmc,
                    r.f_dlbm AS dlbm
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY ("substring"(r.f_zbxzqdm::text, 1, 4) || '00'::text), r.f_zblx, r.f_dlbm, r.f_dlmc, r.f_gddb
                UNION
                 SELECT sum(s.f_gdmj_sy) AS sygd,
                    sum(s.f_stmj_sy) AS syst,
                    sum(s.f_gdmj) AS rkgd,
                    sum(s.f_stmj) AS rkst,
                    sum(s.f_gdmj_yy) AS ckgd,
                    sum(s.f_stmj_yy) AS ckst,
                     sum(s.f_gdmj_sd) AS sdgd,
                    sum(s.f_stmj_sd) AS sdst,
                    "substring"(r.f_zbxzqdm::text, 1, 2) || '0000'::text AS zbxzqdm,
                    r.f_zblx,
                    r.f_gddb AS gddb,
                    r.f_dlmc AS dlmc,
                    r.f_dlbm AS dlbm
                   FROM tb_zbph_zbk_sytj s
                     RIGHT JOIN tb_zbph_zbk_rkmx r ON s.f_zbid::text = r.f_id::text
                  GROUP BY ("substring"(r.f_zbxzqdm::text, 1, 2) || '0000'::text), r.f_zblx, r.f_dlbm, r.f_dlmc, r.f_gddb) a
             LEFT JOIN tbime_region tr ON a.zbxzqdm::text = tr.f_code::text) b
GROUP BY b.zbxzqdm, b.f_zblx, b.f_pcode, b.f_zbxzqmc, b.gddb, b.dlmc, b.dlbm;

INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89909000097','v_zbph_zbk_zbtj_dl','sdgd','锁定耕地',0,'numeric',64,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL);
INSERT INTO public.tb_model_group (f_id,f_groupcode,f_fieldid,f_fieldorder,f_tablename,f_visible) VALUES
	 ('89909000097','project-list','89909000097',14,'v_zbph_zbk_zbtj_dl',1);
INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89909000096','v_zbph_zbk_zbtj_dl','sdst','锁定水田',0,'numeric',64,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL);
INSERT INTO public.tb_model_group (f_id,f_groupcode,f_fieldid,f_fieldorder,f_tablename,f_visible) VALUES
	 ('89909000096','project-list','89909000096',14,'v_zbph_zbk_zbtj_dl',1);

INSERT INTO public.tb_model_fields
VALUES('95800001050', 'v_zbph_zbk_zbtj_xzq', 'sdst', '锁定水田(公顷)', 0, 'numeric', 64, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('95800001051', 'v_zbph_zbk_zbtj_xzq', 'sdgd', '锁定耕地(公顷)', 0, 'numeric', 64, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);



INSERT INTO public.tb_model_group (f_id,f_groupcode,f_fieldid,f_fieldorder,f_tablename,f_visible) VALUES
	 ('95800001050','project-list','95800001050',15,'v_zbph_zbk_zbtj_xzq',1),
	 ('95800001051','project-list','95800001051',16,'v_zbph_zbk_zbtj_xzq',1);
