--删除表
DROP TABLE public.tb_zbph_zbk_sytj_dk;
DROP TABLE public.tb_zbph_zbk_ckgcmx_dk;
DROP TABLE public.tb_zbph_zbk_ckmx_dk;
-- public.tb_zbph_zbk_sytj_dk definition

-- Drop table

-- DROP TABLE public.tb_zbph_zbk_sytj_dk;
--指标空间使用统计表
CREATE TABLE public.tb_zbph_zbk_sytj_dk (
	f_id varchar(64) NOT NULL DEFAULT 0, -- 主键
	f_zbid varchar(64) NOT NULL DEFAULT 0, -- 指标id
	f_gd_shape public.geometry NULL, -- 入库耕地矢量
	f_gd_shape_yy public.geometry NULL, -- 耕地矢量已用
	f_gd_shape_sy public.geometry NULL, -- 耕地矢量剩余
	f_gd_shape_sd public.geometry NULL, -- 耕地矢量锁定
	f_st_shape public.geometry NULL, -- 入库水田矢量
	f_st_shape_yy public.geometry NULL, -- 水田矢量已用
	f_st_shape_sy public.geometry NULL, -- 水田矢量剩余
	f_st_shape_sd public.geometry NULL, -- 水田矢量锁定
	f_cnzb_shape public.geometry NULL, -- 入库产能指标矢量
	f_cnzb_shape_yy public.geometry NULL, -- 产能指标矢量已用
	f_cnzb_shape_sy public.geometry NULL, -- 产能指标矢量剩余
	f_cnzb_shape_sd public.geometry NULL -- 产能指标矢量锁定
);
CREATE INDEX tb_zbph_zbk_sytj_f_zbid_idx_2 ON public.tb_zbph_zbk_sytj_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_sytj_dk IS '指标空间使用统计表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_zbid IS '指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gd_shape IS '入库耕地矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gd_shape_yy IS '耕地矢量已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gd_shape_sy IS '耕地矢量剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gd_shape_sd IS '耕地矢量锁定';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_st_shape IS '入库水田矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_st_shape_yy IS '水田矢量已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_st_shape_sy IS '水田矢量剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_st_shape_sd IS '水田矢量锁定';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_shape IS '入库产能指标矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_shape_yy IS '产能指标矢量已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_shape_sy IS '产能指标矢量剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_shape_sd IS '产能指标矢量锁定';

-- public.tb_zbph_zbk_ckgcmx_dk definition

-- Drop table

-- DROP TABLE public.tb_zbph_zbk_ckgcmx_dk;

--指标空间出库过程明细表

CREATE TABLE public.tb_zbph_zbk_ckgcmx_dk (
	f_id varchar(64) NOT NULL,
	f_gd_shape public.geometry NULL, -- 耕地矢量
	f_st_shape public.geometry NULL, -- 水田矢量
	f_cnzb_shape public.geometry NULL, -- 产能指标矢量
	f_zbid varchar(64) NOT NULL, -- 指标id
	f_sid varchar(64) NOT NULL, -- 流水号
	f_ckgcmx_id varchar NULL, -- 关联出库过程明细id
	CONSTRAINT tb_zbph_zbk_ckgcmx_dk_pkey_1 PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zbk_ckgcmx_dk_un_zbid_sid_1 UNIQUE (f_zbid, f_sid)
);
CREATE INDEX tb_zbph_zbk_ckgcmx_dk_f_sid_idx_1 ON public.tb_zbph_zbk_ckgcmx_dk USING btree (f_sid);
CREATE INDEX tb_zbph_zbk_ckgcmx_dk_f_zbid_idx_1 ON public.tb_zbph_zbk_ckgcmx_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_ckgcmx_dk IS '指标空间出库过程明细表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_gd_shape IS '耕地矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_st_shape IS '水田矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_cnzb_shape IS '产能指标矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbid IS '指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_sid IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_ckgcmx_id IS '关联出库过程明细id';

--指标库出库明细表-地块
-- public.tb_zbph_zbk_ckmx_dk definition

-- Drop table

-- DROP TABLE public.tb_zbph_zbk_ckmx_dk;

CREATE TABLE public.tb_zbph_zbk_ckmx_dk (
	f_id varchar(64) NOT NULL, -- 主键
	f_gd_shape public.geometry NULL, -- 耕地矢量
	f_st_shape public.geometry NULL, -- 水田矢量
	f_cnzb_shape public.geometry NULL, -- 产能指标
	f_zbid varchar(64) NOT NULL, -- 出库指标id
	f_sid varchar(64) NOT NULL, -- 出库流水号
	f_ckmx_id varchar NULL, -- 关联出库明细id
	CONSTRAINT tb_zbph_zbk_ckmx_dk_pkey_1 PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zbk_ckmx_dk_un_zbid_sid_1 UNIQUE (f_zbid, f_sid)
);
CREATE INDEX tb_zbph_zbk_ckmx_dk_f_sid_idx_1 ON public.tb_zbph_zbk_ckmx_dk USING btree (f_sid);
CREATE INDEX tb_zbph_zbk_ckmx_dk_f_zbid_idx_1 ON public.tb_zbph_zbk_ckmx_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_ckmx_dk IS '指标库出库明细表-地块';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_gd_shape IS '耕地矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_st_shape IS '水田矢量';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_cnzb_shape IS '产能指标';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbid IS '出库指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_sid IS '出库流水号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_ckmx_id IS '关联出库明细id';