/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.acti.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.system.SysRoleService;
import com.geoway.onemap.core.support.JsonUtils;
import com.geoway.onemap.stxf.service.GdbhService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class WorkflowService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ModelManageService modelManageService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    HistoryService historyService;
    @Autowired
    private SysRoleService roleService;
    @Autowired
    private GdbhService gdbhService;

    public List<String> startProcess(String processsKey, String businessKey, String tableName, String businessParam, String userId) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Object> visiables = this.getVisiables(processsKey);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{businessKey})) {
            throw new Exception("\u6d41\u7a0b\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
        }
        String[] bkArr = businessKey.split(",");
        for (int i = 0; i < bkArr.length; ++i) {
            String bk = bkArr[i];
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processsKey, visiables);
            this.runtimeService.updateBusinessKey(processInstance.getId(), bk);
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                HashMap<String, String> update = new HashMap<String, String>();
                update.put("f_id", bk);
                update.put("f_process_id", processInstance.getId());
                this.modelManageService.updateModel(update, tableName);
            }
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().singleResult();
            JSONObject busObj = null;
            if (StringUtils.isNotBlank((CharSequence)businessParam)) {
                Object jsobj = JSONObject.parse((String)businessParam);
                if (jsobj instanceof JSONArray) {
                    JSONArray jsonArray = JSONArray.parseArray((String)businessParam);
                    busObj = jsonArray.getJSONObject(i);
                } else if (jsobj instanceof JSONObject) {
                    busObj = JSONObject.parseObject((String)businessParam);
                }
            }
            this.claimThenComplete(tableName, task, userId, null, busObj);
            result.add(processInstance.getId());
        }
        return result;
    }

    public List<String> startProcessInstanceByKey(String processKey, String businessKey, Integer state, String tableName, String userId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, Object> visiables = this.getVisiables(processKey);
        for (String bk : businessKey.split(",")) {
            list.add(this.startProcessInstance(bk, processKey, userId, tableName, visiables, state));
        }
        return list;
    }

    public String claimThenComplete(String ids, String keyWF, String valueWF, String tableName, String businessParam, String otherBusinessParam, String userId) throws Exception {
        List<String> cmpKeys = this.doBussinessTask(ids, businessParam, tableName, keyWF, valueWF, userId);
        if (StringUtils.isNotBlank((CharSequence)otherBusinessParam)) {
            this.doOtherBusiness(otherBusinessParam, userId);
        }
        return StringUtils.join(cmpKeys, (String)",");
    }

    public void deleteProcessInstance(String businessKey, String tableName, Integer state) {
        List processInstances = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).includeProcessVariables().list();
        if (processInstances != null && processInstances.size() > 0) {
            for (ProcessInstance processInstance : processInstances) {
                String processId = processInstance.getId();
                this.runtimeService.deleteProcessInstance(processId, "\u7528\u6237\u64a4\u9500");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            this.modelManageService.updateProcessId(tableName, businessKey, null, Integer.valueOf(0), state);
        }
    }

    public void claimAndComplete(String ids, String keyWF, String valueWF, String tableName, String userId) {
        HashMap<String, Object> visiables = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)keyWF)) {
            visiables.put(keyWF, valueWF);
        }
        for (String id : ids.split(",")) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(id)).list();
            for (Task task : tasks) {
                this.claimComplate(tableName, task, userId, visiables);
            }
        }
    }

    private String claimThenComplete(String tableName, Task task, String userId, Map<String, Object> visiables, JSONObject businessParam) {
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        this.taskService.claim(task.getId(), userId);
        this.taskService.complete(task.getId(), visiables);
        if (Strings.isNotEmpty((CharSequence)tableName) && instance != null) {
            this.updateBusiness(tableName, task, instance, businessParam);
        }
        return task.getTaskDefinitionKey();
    }

    public Page<Map<String, Object>> findPages(String nodeName, String filterParam, String tableName, String groupCode, String sortParam, int rows, int page, String userId) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : nodeName.split(",")) {
            nameList.add(name);
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskNameIn(nameList)).list();
        ArrayList<String> processIds = new ArrayList<String>();
        for (Task task : tasks) {
            processIds.add(task.getProcessInstanceId());
        }
        String where = " and (f_process_id is null AND f_user_id = '" + userId + "')";
        if (tasks != null && tasks.size() > 0) {
            where = " and (f_process_id in ('" + StringUtils.join(processIds, (String)"','") + "') OR (f_user_id = '" + userId + "'))";
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            where = where + filterParam;
        }
        Page pages = this.modelManageService.findPageList(tableName, groupCode, where, sortParam, rows, page);
        return pages;
    }

    public List processDefinition() {
        List list = ((ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ArrayList re = new ArrayList();
        if (list != null && list.size() > 0) {
            for (ProcessDefinition processDefinition : list) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("\u6d41\u7a0b\u5b9a\u4e49ID", processDefinition.getId());
                m.put("\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", processDefinition.getName());
                m.put("\u6d41\u7a0b\u5b9a\u4e49\u7684key", processDefinition.getKey());
                m.put("\u6d41\u7a0b\u5b9a\u4e49\u7684\u7248\u672c", processDefinition.getVersion());
                m.put("\u8d44\u6e90\u540d\u79f0bpmn\u6587\u4ef6", processDefinition.getResourceName());
                m.put("\u8d44\u6e90\u540d\u79f0png\u6587\u4ef6", processDefinition.getDiagramResourceName());
                m.put("\u90e8\u7f72\u5bf9\u8c61ID", processDefinition.getDeploymentId());
                re.add(m);
            }
        }
        return re;
    }

    public String deletebyKey(String key) {
        List list = this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).list();
        StringBuffer stringBuffer = new StringBuffer();
        for (ProcessDefinition pd : list) {
            String idandversion = pd.getId() + "___" + pd.getVersion();
            stringBuffer.append(idandversion + ";");
            this.processEngine.getRepositoryService().deleteDeployment(pd.getDeploymentId(), true);
        }
        return stringBuffer.toString();
    }

    public List getProcessInstance(String key) {
        List instanceList = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(key).orderByProcessInstanceId().desc()).list();
        ArrayList re = new ArrayList();
        for (ProcessInstance instance : instanceList) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            String processId = instance.getId();
            m.put("id", processId);
            m.put("parentId", instance.getParentId());
            m.put("businessKey", instance.getBusinessKey());
            m.put("desc", instance.getDescription());
            m.put("name", instance.getName());
            m.put("startTime", instance.getStartTime().toLocaleString());
            m.put("isEnd", instance.isEnded());
            List his = this.processHis(processId);
            m.put("his", his);
            re.add(m);
        }
        return re;
    }

    public List<Map<String, String>> getProcessTaskByNode(String key, String nodeName) {
        List tasks;
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(key)).list();
        } else {
            ArrayList<String> nameList = new ArrayList<String>();
            for (String name : nodeName.split(",")) {
                nameList.add(name);
            }
            tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(key)).taskNameIn(nameList)).list();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        tasks.stream().forEach(a -> {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", a.getId());
            m.put("nodeName", a.getName());
            m.put("assignee", a.getAssignee());
            m.put("createTime", a.getCreateTime().toLocaleString());
            m.put("processInstanceId", a.getProcessInstanceId());
            m.put("processDefinitionId", a.getProcessDefinitionId());
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(a.getProcessInstanceId()).singleResult();
            if (instance != null) {
                String businessKey = instance.getBusinessKey();
                m.put("businessKey", businessKey);
            }
            list.add(m);
        });
        return list;
    }

    public List processHis(String processId) {
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId)).orderByTaskCreateTime()).asc()).list();
        ArrayList re = new ArrayList();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstanceList) {
            HashMap<String, String> m = new HashMap<String, String>();
            String parentId = historicTaskInstance.getParentTaskId();
            String taskId = historicTaskInstance.getId();
            String defId = historicTaskInstance.getTaskDefinitionKey();
            String defKey = historicTaskInstance.getTaskDefinitionKey();
            Date endTime = historicTaskInstance.getEndTime();
            Date startTime = historicTaskInstance.getStartTime();
            String name = historicTaskInstance.getName();
            String desc = historicTaskInstance.getDescription();
            m.put("parentId", parentId);
            m.put("taskId", taskId);
            m.put("defKey", defKey);
            m.put("endTime", endTime == null ? "" : endTime.toLocaleString());
            m.put("startTime", startTime == null ? "" : startTime.toLocaleString());
            m.put("name", name);
            m.put("desc", desc);
            if (endTime != null) {
                m.put("state", "\u5df2\u7ed3\u675f");
            } else {
                m.put("state", "\u8fd0\u884c\u4e2d");
            }
            re.add(m);
        }
        return re;
    }

    public Page<Map<String, Object>> findFHKTaskPages(String nodeName, String filterParam, String tableName, String groupCode, String sortParam, int rows, int page, String type, String userId) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : nodeName.split(",")) {
            nameList.add(name);
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskNameIn(nameList)).list();
        ArrayList<String> processIds = new ArrayList<String>();
        for (Task task : tasks) {
            processIds.add(task.getProcessInstanceId());
        }
        String where = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "end": {
                    where = " and f_check_result = 2";
                    break;
                }
                case "pass": {
                    where = " and f_check_result = 1";
                    break;
                }
                default: {
                    where = " and (f_process_id is null AND f_user_id = '" + userId + "')";
                    if (tasks != null && tasks.size() > 0) {
                        where = " and (f_process_id in ('" + StringUtils.join(processIds, (String)"','") + "') OR (f_process_id is null AND f_user_id = '" + userId + "'))";
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            where = " and (f_process_id is null AND f_user_id = '" + userId + "')";
            if (tasks != null && tasks.size() > 0) {
                where = " and (f_process_id in ('" + StringUtils.join(processIds, (String)"','") + "') OR ( f_user_id = '" + userId + "'))";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            where = where + filterParam;
        }
        return this.modelManageService.findPageList(tableName, groupCode, where, sortParam, rows, page);
    }

    public Page<Map<String, Object>> findJHKTaskPages(String tableName, String groupCode, String filterParam, String sortParam, String step, int rows, int page, SysUser user) {
        String sqlUser = "";
        String sqlToAudit = " and f_check_state in ('p1','p2','p3','p4')";
        String sqlPass = " and f_check_state = 'p51'";
        String sqlStop = " and f_check_state = 'p52'";
        String where = " and 1=1";
        if ("all".equals(step)) {
            where = sqlUser;
        } else if ("1".equals(step)) {
            where = sqlUser + sqlToAudit;
        } else if ("2".equals(step)) {
            where = sqlUser + sqlPass;
        } else if ("3".equals(step)) {
            where = sqlUser + sqlStop;
        } else if ("0".equals(step)) {
            where = " and f_check_state = 'p0'";
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            where = where + filterParam;
        }
        return this.modelManageService.findPageList(tableName, groupCode, where, sortParam, rows, page);
    }

    private Boolean isAdmin(SysUser user) {
        SimpleRole role;
        Set simpleRoles = user.getRoles();
        if (simpleRoles != null && simpleRoles.size() > 0 && (role = (SimpleRole)simpleRoles.stream().filter(item -> "\u7ba1\u7406\u5458".equals(item.getRolename())).findAny().orElse(null)) != null) {
            return true;
        }
        List roles = this.roleService.findRoleByUserId(user.getId());
        for (SysRole role2 : roles) {
            if (!"\u7ba1\u7406\u5458".equals(role2.getRolename())) continue;
            return true;
        }
        return false;
    }

    private List<String> doBussinessTask(String ids, String businessParam, String tableName, String keyWF, String valueWF, String userId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new Exception("{ids}\u6d41\u7a0bid\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> cmpKeys = new ArrayList<String>();
        HashMap<String, Object> visiables = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)keyWF)) {
            visiables.put(keyWF, valueWF);
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            String id = idArr[i];
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(id)).list();
            for (Task task : tasks) {
                JSONObject busObj = null;
                if (StringUtils.isNotBlank((CharSequence)businessParam)) {
                    Object jsobj = JSONObject.parse((String)businessParam);
                    if (jsobj instanceof JSONArray) {
                        JSONArray jsonArray = JSONArray.parseArray((String)businessParam);
                        busObj = jsonArray.getJSONObject(i);
                    } else if (jsobj instanceof JSONObject) {
                        busObj = JSONObject.parseObject((String)businessParam);
                    }
                }
                String key = this.claimThenComplete(tableName, task, userId, visiables, busObj);
                cmpKeys.add(key);
                if (!tableName.equals("tb_project_gdbh_cbbcgd_fhk") || !"check".equalsIgnoreCase(keyWF) || !"1".equalsIgnoreCase(valueWF)) continue;
                this.gdbhService.saveFHK2ZBK(busObj.getString("f_id"), userId, "+", "\u590d\u6838\u9879\u76ee\u5165\u5e93", null);
            }
        }
        return cmpKeys;
    }

    private Boolean updateBusiness(String tableName, Task task, ProcessInstance instance, JSONObject businessParam) {
        String busKey = instance.getBusinessKey();
        String defKey = task.getTaskDefinitionKey();
        try {
            HashMap modelObj = new HashMap();
            if (businessParam != null) {
                for (Map.Entry entry : businessParam.entrySet()) {
                    modelObj.put(entry.getKey().toString(), entry.getValue());
                }
                if (StringUtils.isNotBlank((CharSequence)businessParam.getString("f_id"))) {
                    busKey = businessParam.getString("f_id");
                }
                if (StringUtils.isNotBlank((CharSequence)businessParam.getString("f_check_state"))) {
                    defKey = businessParam.getString("f_check_state");
                }
            }
            modelObj.put("f_check_state", defKey);
            modelObj.put("f_id", busKey);
            this.modelManageService.updateModel(modelObj, tableName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void doOtherBusiness(String otherBusinessParam, String userId) throws Exception {
        Object jsobj = JSONObject.parse((String)otherBusinessParam);
        if (jsobj instanceof JSONArray) {
            JSONArray jsonArray = JSONArray.parseArray((String)otherBusinessParam);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject param = jsonArray.getJSONObject(i);
                String tableName = param.getString("tableName");
                Map data = JsonUtils.jsonToMap((JSONObject)param.getJSONObject("data"));
                if (StringUtils.isNotBlank((CharSequence)param.getString("mode")) && "add".equals(param.getString("mode"))) {
                    this.modelManageService.saveModel(data, tableName, userId, false);
                    continue;
                }
                this.modelManageService.updateModel(data, tableName);
            }
        } else if (jsobj instanceof JSONObject) {
            JSONObject param = JSONObject.parseObject((String)otherBusinessParam);
            String tableName = param.getString("tableName");
            Map data = JsonUtils.jsonToMap((JSONObject)param.getJSONObject("data"));
            if (StringUtils.isNotBlank((CharSequence)param.getString("mode")) && "add".equals(param.getString("mode"))) {
                this.modelManageService.saveModel(data, tableName, userId, false);
            } else {
                this.modelManageService.updateModel(data, tableName);
            }
        }
    }

    private String startProcessInstance(String businessKey, String key, String userId, String tableName, Map<String, Object> visiables, Integer state) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, visiables);
        this.runtimeService.updateBusinessKey(processInstance.getId(), businessKey);
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            this.modelManageService.updateProcessId(tableName, businessKey, processInstance.getId(), Integer.valueOf(1), state);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().singleResult();
        this.claimComplate(tableName, task, userId, null);
        return processInstance.getId();
    }

    private void claimComplate(String tableName, Task task, String userId, Map<String, Object> visiables) {
        this.taskService.claim(task.getId(), userId);
        this.taskService.complete(task.getId(), visiables);
        if (Strings.isNotEmpty((CharSequence)tableName)) {
            this.updateBusState(tableName, task);
        }
    }

    private boolean updateBusState(String tableName, Task task) {
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String busKey = instance.getBusinessKey();
        String defKey = task.getTaskDefinitionKey();
        HashMap<String, String> modelObj = new HashMap<String, String>();
        modelObj.put("f_check_state", defKey);
        modelObj.put("f_id", busKey);
        try {
            this.modelManageService.updateModel(modelObj, tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Map<String, Object> getVisiables(String key) throws Exception {
        HashMap<String, Object> visiables = new HashMap<String, Object>();
        switch (key) {
            case "myProcess_jhk": {
                break;
            }
            case "myProcess_fhk": {
                visiables.put("check", null);
                visiables.put("day", null);
                break;
            }
            case "myProcess_zbtr": {
                visiables.put("check", null);
                visiables.put("recheck", null);
                break;
            }
            case "myProcess_zbtc": {
                visiables.put("check", null);
                visiables.put("recheck", null);
                break;
            }
            default: {
                throw new Exception("\u6ca1\u6709\u8be5\u6d41\u7a0b\u7c7b\u578b");
            }
        }
        return visiables;
    }

    private String getNodeNameByRole(SysUser user) {
        List roles = this.roleService.findRoleByUserId(user.getId());
        String nodeName = null;
        for (SysRole role : roles) {
            if ("\u7ba1\u7406\u5458".equals(role.getRolename())) {
                nodeName = "\u8ba1\u5212\u5ba1\u6838";
                break;
            }
            if (!"\u4f5c\u4e1a\u5458".equals(role.getRolename())) continue;
            nodeName = "\u8ba1\u5212\u7533\u8bf7";
            break;
        }
        return nodeName;
    }
}

