/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.StringUtils;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.stxf.dto.FLZygdDTO;
import com.geoway.onemap.stxf.dto.FNZygdDTO;
import com.geoway.onemap.stxf.dto.UploadAttach;
import com.geoway.onemap.stxf.service.GdbhService;
import com.geoway.onemap.stxf.utils.FileUtils;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.web.anno.RequireAuth;
import com.geoway.zhgd.domain.ProjectGdbhCbbcgdYjk;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/gdbh"})
public class GdbhAction {
    private static final Logger log = LoggerFactory.getLogger(GdbhAction.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    GdbhService gdbhService;
    @Autowired
    private ModelManageService modelManageService;

    @RequireAuth
    @RequestMapping(value={"/importJHK.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse importJHK(HttpServletRequest request, @RequestParam(name="data") String data, @RequestParam(name="attach") String attach) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONObject data1 = JSONObject.parseObject((String)data);
            List attach1 = JSONArray.parseArray((String)attach, UploadAttach.class);
            return this.gdbhService.importJHK((Map)data1, attach1, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/updateXmxx.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse updateJHK(HttpServletRequest request, @RequestParam(name="data") String data, String attach, @RequestParam(name="type") String type) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (XmxxType.LX.type.equals(type)) {
                this.gdbhService.updateJhk(data, attach, user);
            } else if (XmxxType.YS.type.equals(type)) {
                this.gdbhService.updateFhk(data, attach, user);
            }
            return BaseObjectResponse.buildSuccessResponse((String)"\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/queryBlocks.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse updateJHK(HttpServletRequest request, @RequestParam String projectId, @RequestParam String type) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BaseObjectResponse baseResponse = new BaseObjectResponse();
            baseResponse.setData((Object)this.gdbhService.queryBlocks(projectId, type));
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/updateBlocks.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse updateBlocks(HttpServletRequest request, String blocks, String type) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.gdbhService.updateBlocks(blocks, type);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/inputZbk.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse inputZbk(HttpServletRequest request, String projectId) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.gdbhService.inputZbk(projectId, user);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/inputZbkZygd.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public BaseResponse inputZbkZygd(HttpServletRequest request, String projectId) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.gdbhService.inputZbkZygd(user, projectId);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importFHK.do"})
    @ResponseBody
    public BaseResponse importFHK(HttpServletRequest request, @RequestParam(name="data") String data, @RequestParam(name="attach") String attach) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            JSONObject data1 = JSONObject.parseObject((String)data);
            List attach1 = JSONArray.parseArray((String)attach, UploadAttach.class);
            return this.gdbhService.importFHK((Map)data1, attach1, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importFHK2ZBK.do"})
    @ResponseBody
    public BaseResponse importFHK2ZBK(HttpServletRequest request, @RequestParam(name="projectId") String projectId) throws Exception {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return BaseObjectResponse.buildSuccessResponse((String)this.gdbhService.saveFHK2ZBK(projectId, user.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/lockAllZYGD.do"})
    @ResponseBody
    public BaseResponse lockAllZYGD(HttpServletRequest request) {
        try {
            this.gdbhService.lockAllZygd();
            return BaseObjectResponse.buildSuccessResponse((String)"\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importFNZYGD.do"})
    @ResponseBody
    public BaseResponse importFNZYGD(HttpServletRequest request, @RequestBody FNZygdDTO fnZygdDTO) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return this.gdbhService.importFNZYGD(fnZygdDTO, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importZYGD.do"})
    @ResponseBody
    public BaseResponse importZYGD(HttpServletRequest request, @RequestBody FLZygdDTO FLZygdDTO2) {
        try {
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u63a5\u53e3\u5f00\u59cb\u6267\u884c\u65f6\u95f4:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now()));
            long start = System.currentTimeMillis();
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            BaseResponse baseResponse = this.gdbhService.importZYGD(FLZygdDTO2, user);
            long end = System.currentTimeMillis();
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u63a5\u53e3\u7ed3\u675f\u6267\u884c\u65f6\u95f4:%s\uff0c\u603b\u8017\u65f6:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now(), end - start));
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/bacthCheckZYGD.do"})
    @ResponseBody
    public BaseResponse bacthCheckZYGD(HttpServletRequest request, MultipartFile file, String userId, String userName) {
        try {
            return BaseObjectResponse.buildSuccessResponse((String)this.gdbhService.bacthCheckZYGD(userId, userName, file));
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/deleteZYGD.do"})
    @ResponseBody
    public BaseResponse deleteZYGD(HttpServletRequest request, @RequestParam String projectId) {
        try {
            this.gdbhService.deleteZYGD(projectId);
            return BaseObjectResponse.buildSuccessResponse((String)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/detailFNZYGD.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse detailFLZYGD(HttpServletRequest request, @RequestParam String projectId) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            return this.gdbhService.detailFNZYGD(projectId);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
            return baseObjectResponse;
        }
    }

    @RequestMapping(value={"/detailZYGD.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse detailZYGD(HttpServletRequest request, @RequestParam String projectId) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            return this.gdbhService.detailZYGD(projectId);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
            return baseObjectResponse;
        }
    }

    @RequireAuth
    @RequestMapping(value={"/checkZYGD.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse checkZYGD(HttpServletRequest request, @RequestBody Map<String, Object> data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List datas = (List)data.get("data");
            return this.gdbhService.checkZYGD(user, datas);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
            return baseResponse;
        }
    }

    @RequireAuth
    @RequestMapping(value={"/downloadZYGD.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse downloadZYGD(HttpServletRequest request, HttpServletResponse response, String projectId) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            this.gdbhService.downloadCheckCode(projectId, response);
            return BaseResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
    }

    @RequireAuth
    @RequestMapping(value={"/checkFNZYGD.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse checkFNZYGD(HttpServletRequest request, @RequestBody Map<String, Object> data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List datas = (List)data.get("data");
            return this.gdbhService.checkFNZYGD(user.getId(), datas);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
            return baseResponse;
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importLSK.do"})
    @ResponseBody
    public BaseResponse importLSK(HttpServletRequest request, @RequestParam(name="type") String type, @RequestParam(name="datatype") String datatype, @RequestParam(name="file") MultipartFile[] mfiles) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            String fileUri = File.separator + type + File.separator + UUID.randomUUID();
            File[] files = this.getFiles(mfiles, fileUri);
            return this.gdbhService.importLSK(files, user.getId(), datatype);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/importShpFile.do"})
    @ResponseBody
    public BaseResponse importShpFile(HttpServletRequest request, @RequestParam(name="check", required=false) Boolean check, @RequestParam(name="type") String type, @RequestParam(name="file") MultipartFile file) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            String fileUri = File.separator + type + File.separator + UUID.randomUUID();
            File[] files = this.getZipFile(file, fileUri);
            String projectId = this.gdbhService.importShpFile(files, fileUri, user.getId(), type, check);
            baseObjectResponse.setData((Object)projectId);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/generateJhkGty.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse generateJhkGty(HttpServletRequest request, @RequestParam String projectIds) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            this.gdbhService.generateJhkGty(projectIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/generateFhkGty.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse generateFhkGty(HttpServletRequest request, @RequestParam String projectIds) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return this.gdbhService.generateFhkGty(projectIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/getDkByPzd"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getDkByPzd(HttpServletRequest request, @RequestParam String projectId, @RequestParam String tableName, @RequestParam Double lng, @RequestParam Double lat, @RequestParam Double radius) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            Map map = this.gdbhService.getDkByPzd(projectId, tableName, lng, lat, radius);
            baseObjectResponse.setData((Object)map);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/findFHKTaskPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFHKTaskPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int rows, @RequestParam(name="tableName") String tableName, @RequestParam(name="groupCode", required=false) String groupCode) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page pages = this.modelManageService.findPageList(tableName, groupCode, filterParam, sortParam, rows, page);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/createJhkProject.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse createJhkProject(HttpServletRequest request) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Map pro = this.gdbhService.cretaeJhkProject(user);
            baseObjectResponse.setData((Object)pro);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/createFhkProject.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse createFhkProject(HttpServletRequest request) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Map pro = this.gdbhService.cretaeFhkProject(user);
            baseObjectResponse.setData((Object)pro);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/createYjkProject.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse createYjkProject(HttpServletRequest request) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Map pro = this.gdbhService.cretaeYjkProject(user);
            baseObjectResponse.setData((Object)pro);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/yjk/save.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse saveYjkInfo(@RequestBody ProjectGdbhCbbcgdYjk info, HttpServletRequest request) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            info.setXzqdm(user.getXzqdm());
            baseObjectResponse.setData((Object)this.gdbhService.saveYjkInfo(info));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/yjk/queryById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryYjkById(@RequestParam String id) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            baseObjectResponse.setData((Object)this.gdbhService.queryYjkById(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/yjk/queryPage.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryPageYjk(String yjbh, String name, Integer status, Integer ruleStatus, @RequestParam Integer page, @RequestParam Integer size, HttpServletRequest request) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            baseObjectResponse.setData((Object)this.gdbhService.queryPageYjk(yjbh, name, status, ruleStatus, user.getXzqdm(), page, size));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/yjk/deleteById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteYjkById(@RequestParam String id) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            this.gdbhService.deleteYjkById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/deleteWyFile.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteWyFile(@RequestParam String id, String type) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            String tableName = "";
            String fjType = "";
            if ("jhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_jhk_xzgdfw";
                fjType = "JHK1";
            } else if ("fhk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_fhk_xzgdfw";
                fjType = "FHK1";
            } else if ("lsk".equalsIgnoreCase(type)) {
                tableName = "tb_project_gdbh_cbbcgd_lsk_xzgdfw";
                fjType = "LSK1";
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                String[] idList = id.split(",");
                ArrayList<String> ids = new ArrayList<String>();
                if (idList != null && idList.length > 0) {
                    for (int i = 0; i < idList.length; ++i) {
                        ids.add("'" + idList[i] + "'");
                    }
                    List gdList = this.modelManageService.findFieldList(tableName, " and f_project_id in (" + String.join((CharSequence)",", ids) + ")", new String[]{"f_id"});
                    this.gdbhService.deleteWyFileById(gdList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String test() {
        return "test!";
    }

    private File[] getFiles(MultipartFile[] files, String fileUri) throws Exception {
        String destPath = this.uploadDir + fileUri + File.separator;
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] destFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            MultipartFile file = files[i];
            String fileName = file.getOriginalFilename();
            String fileFullName = destDir + File.separator + fileName;
            File dest = new File(fileFullName);
            file.transferTo(dest);
            destFiles[i] = dest;
        }
        return destFiles;
    }

    private File[] getZipFile(MultipartFile file, String fileUri) throws Exception {
        File[] files2;
        String destPath = this.uploadDir + fileUri + File.separator;
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        String fileName = file.getOriginalFilename();
        String fileFullName = destDir + File.separator + fileName;
        File dest = new File(fileFullName);
        file.transferTo(dest);
        String unZipPath = destDir + File.separator;
        FileUtils.unpack((File)dest, (File)destDir, (String)"gbk");
        File unZipDir = new File(unZipPath);
        File[] files = null;
        for (File file2 : files2 = unZipDir.listFiles()) {
            if (!file2.isDirectory()) continue;
            files = file2.listFiles();
        }
        return files;
    }
}

