/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelGroupService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.metadata.vo.Gather;
import com.geoway.onemap.biz.service.file.FileService;
import com.geoway.onemap.core.dao.RegionRepository;
import com.geoway.onemap.core.dao.zbtr.TbProjectGdbhCbbcgdZbtrXmRecordRepository;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.dto.MyLoginResponse;
import com.geoway.onemap.core.service.system.LoginService;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.MyTokenService;
import com.geoway.onemap.core.service.system.SysUserService;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.stxf.action.BaseAction;
import com.geoway.web.anno.RequireAuth;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model"})
public class ModelManageAction
extends BaseAction {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    LoginServiceUIS loginServiceUIS;
    @Autowired
    LoginService loginService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    MyTokenService tokenService;
    @Autowired
    ModelManageService modelManageService;
    @Autowired
    ModelGroupService modelGroupService;
    @Autowired
    ModelFieldsService modelFieldsService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    FileService fileService;
    @Autowired
    TbProjectGdbhCbbcgdZbtrXmRecordRepository tbProjectGdbhCbbcgdZbtrXmRecordRepository;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findPages(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="filter", required=false, defaultValue="") String filter, @RequestParam(name="sort", required=false, defaultValue="") String sort, @RequestParam(name="page", required=false) Integer page, @RequestParam(name="size", required=false) Integer size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        if (StringUtils.isBlank((CharSequence)sort)) {
            sort = "";
        }
        Page pager = this.modelManageService.findPageList(tableName, groupCode, filter, sort, size.intValue(), page.intValue());
        response.setRows(pager.getContent());
        response.setTotal(Long.valueOf(pager.getTotalElements()));
        return response;
    }

    @RequestMapping(value={"/downloadExcel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="filter", required=false, defaultValue="") String filter, @RequestParam(name="sort", required=false, defaultValue="") String sort, @RequestParam(name="page", required=false) Integer page, @RequestParam(name="size", required=false) Integer size) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        if (StringUtils.isBlank((CharSequence)sort)) {
            sort = "";
        }
        try {
            List list = this.modelManageService.findListPage(tableName, groupCode, filter, sort, size.intValue(), page.intValue());
            AbstractMap.SimpleEntry titleArrayPair = this.modelManageService.getFieldsTitle(tableName, groupCode);
            this.fileService.exportExcel(response, list, (String[])titleArrayPair.getKey(), (String[])titleArrayPair.getValue());
        }
        catch (Exception ex) {
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(ex.getMessage());
            ex.printStackTrace();
        }
    }

    @RequestMapping(value={"/findFieldAll.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFieldAll(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="filter", required=false, defaultValue="") String filter, @RequestParam(name="fields", required=false, defaultValue="") String fields, @RequestParam(name="sort", required=false, defaultValue="") String sort) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (StringUtils.isBlank((CharSequence)sort)) {
                sort = "";
            }
            List list = this.modelManageService.findFieldList(tableName, filter + sort, fields.split(","));
            response.setData((Object)list);
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    @RequestMapping(value={"/findAll.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findAll(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="filter", required=false, defaultValue="") String filter, @RequestParam(name="sort", required=false, defaultValue="") String sort) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (StringUtils.isBlank((CharSequence)sort)) {
                sort = "";
            }
            List list = this.modelManageService.findList(tableName, groupCode, filter + sort);
            response.setData((Object)list);
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    @RequestMapping(value={"/findFields.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFields(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="groupCode", required=false) String groupCode) {
        BaseObjectResponse response = new BaseObjectResponse();
        List list = this.modelGroupService.findModelFields(tableName, groupCode);
        response.setData((Object)list);
        return response;
    }

    @RequireAuth
    @RequestMapping(value={"/addModel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addModel(HttpServletRequest request, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="token", required=false) String token, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            JSONObject json = JSONObject.parseObject((String)data);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : json.keySet()) {
                map.put(key, json.get((Object)key));
            }
            Object id = this.modelManageService.saveModel(map, tableName, user.getId(), true);
            baseResponse.setData(id);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/addModelBatch.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addModelBatch(HttpServletRequest request, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="token", required=false) String token, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            JSONArray array = JSONArray.parseArray((String)data);
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : json.keySet()) {
                    map.put(key, json.get((Object)key));
                }
                Object id = this.modelManageService.saveModel(map, tableName, user.getId(), true);
                result.add(id);
            }
            baseResponse.setData(result);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/updateModel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse updateModel(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="token", required=false) String token, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            JSONObject json = JSONObject.parseObject((String)data);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : json.keySet()) {
                map.put(key, json.get((Object)key));
            }
            Object projectId = this.modelManageService.updateModel(map, tableName);
            baseResponse.setData(projectId);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/groupBy.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse groupBy(@RequestParam(name="tableName", required=true) String tableName, @RequestParam(name="filter", required=true) String filter, @RequestParam(name="groupByFields", required=true) String groupByFields, @RequestParam(name="statFields", required=true) String statFields) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String selectFields = groupByFields;
            JSONObject statFieldMap = JSONObject.parseObject((String)statFields);
            for (Map.Entry statField : statFieldMap.entrySet()) {
                switch (statField.getValue().toString()) {
                    case "count": {
                        selectFields = selectFields + String.format(",count(%s) as %s_count", statField.getKey(), statField.getKey());
                        break;
                    }
                    case "max": {
                        selectFields = selectFields + String.format(",max(%s) as %s_max", statField.getKey(), statField.getKey());
                        break;
                    }
                    case "min": {
                        selectFields = selectFields + String.format(",min(%s) as %s_min", statField.getKey(), statField.getKey());
                        break;
                    }
                    case "avg": {
                        selectFields = selectFields + String.format(",avg(%s) as %s_avg", statField.getKey(), statField.getKey());
                    }
                }
            }
            String sql = String.format("select %s from %s where 1=1 %s group by %s", selectFields, tableName, filter, groupByFields);
            List result = this.jdbcTemplate.queryForList(sql);
            baseResponse.setData((Object)result);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/batchUpdateModel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse batchUpdateModel(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="token", required=false) String token, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            JSONArray jsonArray = JSONArray.parseArray((String)data);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : json.keySet()) {
                    map.put(key, json.get((Object)key));
                }
                Object projectId = this.modelManageService.updateModel(map, tableName);
                result.add(projectId);
            }
            baseResponse.setData(result);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/batchCheckJHKProject.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse batchCheckJHKProject(HttpServletRequest request, @RequestParam(name="remark", required=false) String remark, @RequestParam(name="state", required=true) Integer state, @RequestParam(name="projectIds", required=true) String projectIds) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : projectIds.split(",")) {
                ids.add(id);
            }
            this.modelManageService.batchCheckJHKProject(ids, state, remark, user.getUsername());
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/delModel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delModel(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="id", required=false) String id, @RequestParam(name="token", required=false) String token) {
        BaseResponse baseResponse = BaseResponse.buildSuccessResponse();
        try {
            this.modelManageService.delObjectById(tableName, id);
        }
        catch (Exception e) {
            baseResponse = BaseResponse.buildFailuaResponse((Exception)e);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/delModel2.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delModel2(@RequestParam(name="tableName") String tableName, @RequestParam(name="where") String where, @RequestParam(name="token", required=false) String token) {
        BaseResponse baseResponse = BaseResponse.buildSuccessResponse();
        try {
            this.modelManageService.delObject(tableName, where);
        }
        catch (Exception e) {
            baseResponse = BaseResponse.buildFailuaResponse((Exception)e);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/delDiscardFhkByCode.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delDiscardFhk(@RequestParam(name="tableName", required=true) String tableName, @RequestParam(name="code", required=true) String code) {
        BaseResponse baseResponse = BaseResponse.buildSuccessResponse();
        try {
            String where = " and f_code = '" + code + "' and f_state is null and f_process_id is null";
            this.modelManageService.delObject(tableName, where);
        }
        catch (Exception e) {
            baseResponse = BaseResponse.buildFailuaResponse((Exception)e);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/delOldRepeatByCode.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delOldRepeatFhk(@RequestParam(name="tableName", required=true) String tableName, @RequestParam(name="code", required=true) String code) {
        BaseResponse baseResponse = BaseResponse.buildSuccessResponse();
        try {
            String where = " and f_code = '" + code + "' and f_state = 1 and f_process_id is null order by f_create_time desc";
            List list = this.modelManageService.findList(tableName, null, where);
            if (list != null && list.size() > 0) {
                ArrayList<String> ids = new ArrayList<String>();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    Map m;
                    Object oFid;
                    if (i <= 0 || (oFid = (m = (Map)list.get(i)).get("f_id")) == null) continue;
                    ids.add("'" + oFid.toString() + "'");
                }
                String delcondi = " and f_id in (" + StringUtils.join((Object[])ids.toArray(), (String)",") + ")";
                this.modelManageService.delObject(tableName, delcondi);
            }
        }
        catch (Exception e) {
            baseResponse = BaseResponse.buildFailuaResponse((Exception)e);
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequestMapping(value={"/getModelById.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getModelById(@RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="id", required=false) String id, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="token", required=false) String token) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            Map map = this.modelManageService.findObject(tableName, id, groupCode);
            baseResponse.setData((Object)map);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/getModeExtent.json"})
    @ResponseBody
    public BaseResponse getModelExtent(HttpServletRequest request, @RequestParam(name="tableName", required=true) String tableName, @RequestParam(name="filter", required=false) String filter) {
        SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        String boxWkt = this.modelManageService.calcObjExtent(tableName, filter);
        baseResponse.setData((Object)boxWkt);
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/checkFHKProject.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse checkFHKProject(HttpServletRequest request, @RequestParam(name="data", required=true) String data) {
        SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            JSONObject json = JSONObject.parseObject((String)data);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : json.keySet()) {
                map.put(key, json.get((Object)key));
            }
            this.modelManageService.checkFHKProject(map, user.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse.setMessage(e.getMessage());
            baseResponse.setStatus("FAILURE");
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/addFHKModel.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addFHKModel(HttpServletRequest request, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="token", required=false) String token, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            JSONObject json = JSONObject.parseObject((String)data);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : json.keySet()) {
                map.put(key, json.get((Object)key));
            }
            Object fid = map.get("f_id");
            this.modelManageService.updateProcessId(tableName, fid.toString(), "old-" + map.get("f_process_id"), null, Integer.valueOf(0));
            map.put("f_pid", fid);
            map.remove("f_id");
            map.remove("f_create_time");
            map.remove("f_check_time");
            map.remove("f_check_remark");
            map.remove("f_check_user_name");
            Object id = this.modelManageService.saveModel(map, tableName, user.getId(), false);
            baseResponse.setData(id);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/rectifyFhk.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse rectifyFhk(HttpServletRequest request, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="projectId", required=true) String projectId, @RequestParam(name="processId", required=true) String processId, @RequestParam(name="data", required=true) String data) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            Object id;
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            JSONObject json = JSONObject.parseObject((String)data);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : json.keySet()) {
                map.put(key, json.get((Object)key));
            }
            processId = processId.replace("old-", "");
            this.modelManageService.updateProcessId(tableName, projectId, "old-" + processId, null, Integer.valueOf(0));
            if (map.containsKey("f_id")) {
                if (!map.containsKey("f_pid") || map.get("f_pid") == null) {
                    String where = " and f_pid = '" + projectId + "'";
                    this.modelManageService.delObject(tableName, where);
                    map.put("f_newattach", 1);
                }
                map.put("f_pid", projectId);
                map.put("f_process_id", processId);
                id = this.modelManageService.updateModel(map, tableName);
            } else {
                map.put("f_pid", projectId);
                map.put("f_process_id", processId);
                map.put("f_newattach", 0);
                id = this.modelManageService.saveModel(map, tableName, user.getId(), false);
            }
            baseResponse.setData(id);
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/rectifyFhk2.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse rectifyFhk2(HttpServletRequest request, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="projectId", required=true) String projectId, @RequestParam(name="processId", required=true) String processId) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Map map = this.modelManageService.findObject(tableName, projectId, null);
            Object pid = map.get("f_pid");
            if (pid == null) {
                processId = processId.replace("old-", "");
                this.modelManageService.updateProcessId(tableName, projectId, "old-" + processId, null, Integer.valueOf(0));
                map.put("f_pid", projectId);
                map.put("f_process_id", processId);
                map.put("f_newattach", 0);
                map.put("f_state", 1);
                map.remove("f_id");
                Object id = this.modelManageService.saveModel(map, tableName, user.getId(), false);
                baseResponse.setData(id);
            }
        }
        catch (Exception e) {
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return baseResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/gather/{tableName}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse modelGather(HttpServletRequest request, @PathVariable String tableName, @RequestBody Gather gather) {
        MyLoginResponse userInfo;
        SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
        String regioncode = "000000";
        String token = (String)request.getAttribute("access_token");
        if (this.loginServiceUIS.isUISEnable()) {
            userInfo = this.loginServiceUIS.queryUserByToken(token);
            regioncode = userInfo.getRegionCode();
        } else {
            userInfo = this.loginService.queryUserMenusByToken(token, 1);
            regioncode = userInfo.getRegionCode();
        }
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        List re = this.modelManageService.gatherData(tableName, gather);
        baseResponse.setData((Object)re);
        return baseResponse;
    }
}

