/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.system.LoginService;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.MyTokenService;
import com.geoway.onemap.core.service.system.SysMenuService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/menu"})
public class SysMenuAction {
    private Logger logger = Logger.getLogger(SysMenuAction.class);
    @Autowired
    SysMenuService menuService;
    @Autowired
    MyTokenService myTokenService;
    @Autowired
    LoginServiceUIS loginServiceUIS;
    @Autowired
    LoginService loginService;

    @RequestMapping(value={"/listTree.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse listTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            if (StringUtils.isBlank((String)filterParam)) {
                filterParam = "";
            }
            filterParam = filterParam + ";Q_systemId_S_EQ=1";
            String sortParam = "SORT_level_ASC;SORT_sort_ASC";
            List catalogs = this.menuService.queryTreeByFilter(filterParam, sortParam);
            response.setTotal(Long.valueOf(catalogs.size()));
            response.setRows(catalogs);
        }
        catch (Exception ex) {
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listTreeByToken.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listTreeByToken(HttpServletRequest request, @RequestHeader(value="access_token", required=false) String accessToken, @RequestParam(value="token", required=false) String token) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            if (StringUtils.isBlank((String)token)) {
                token = accessToken;
            }
            List catalogs = null;
            catalogs = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.queryUserMenuTreeByTokenAndSystem(token, 1) : this.myTokenService.queryUserMenuTreeByTokenAndSystem(token, 1);
            response.setTotal(Long.valueOf(catalogs.size()));
            response.setRows(catalogs);
        }
        catch (Exception ex) {
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listTreeByAdmin.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listTreeByAdmin(HttpServletRequest request) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            List menus = null;
            SysUser user = this.loginService.AdminLogin("admin");
            menus = this.myTokenService.queryUserMenuTreeByAdminAndSystem(user, 1);
            response.setTotal(Long.valueOf(menus.size()));
            response.setRows(menus);
        }
        catch (Exception ex) {
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listAllValidMenusTree.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listAllValidMenusTree(HttpServletRequest request) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            List catalogs = new ArrayList();
            catalogs = this.myTokenService.queryAllValidMenusTree();
            response.setTotal(Long.valueOf(catalogs.size()));
            response.setRows(catalogs);
        }
        catch (Exception ex) {
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }
}

