/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.onemap.core.domain.system.SysRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.dto.MyLoginResponse;
import com.geoway.onemap.core.service.system.LoginService;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.MyTokenService;
import com.geoway.onemap.core.service.system.SysRoleService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserAction {
    private Logger logger = Logger.getLogger(UserAction.class);
    @Autowired
    LoginService loginService;
    @Autowired
    MyTokenService tokenService;
    @Autowired
    LoginServiceUIS loginServiceUIS;
    @Autowired
    private SysRoleService roleService;

    @RequestMapping(value={"/userInfo.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public MyLoginResponse userInfo(HttpServletRequest request, @RequestParam(value="token") String token) {
        MyLoginResponse response = null;
        try {
            response = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.queryUserByToken(token) : this.loginService.queryUserMenusByToken(token, 1);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getUserById.action"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse userDetailById(HttpServletRequest request, @RequestParam(value="token") String token, @RequestParam(value="userId") String userId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUser user = null;
            user = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.querySysUserById(token, userId) : this.tokenService.querySysUserById(token, userId);
            response.setData((Object)user);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/getCurrentRoleType.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse getCurrentRoleType(HttpServletRequest request, @RequestParam(value="token") String token) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUser user = null;
            user = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.querySysUserByToken(token) : this.tokenService.querySysUserByToken(token);
            List roles = this.roleService.findRoleByUserId(user.getId());
            String roleType = null;
            for (SysRole role : roles) {
                if ("\u7ba1\u7406\u5458".equals(role.getRolename())) {
                    roleType = "admin";
                    continue;
                }
                if ("\u4f5c\u4e1a\u5458".equals(role.getRolename())) {
                    roleType = "operator";
                    continue;
                }
                throw new Exception(String.format("\u65e0\u6cd5\u5224\u65ad\u7528\u6237[%S]\u662f\u7ba1\u7406\u5458\u6216\u8005\u4f5c\u4e1a\u5458\uff0c\u8bf7\u8fdb\u884c\u89d2\u8272\u5173\u8054", user.getUsername()));
            }
            response.setData(roleType);
        }
        catch (Exception e) {
            response.markFailure();
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

