/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.stxf.dto.TaskStatDTO;
import com.geoway.onemap.stxf.service.VerifyTaskService;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@PropertySource(value={"classpath:application-project.properties"})
@RestController
@RequestMapping(value={"/verify/task"})
public class VerifyTaskAction {
    @Autowired
    private VerifyTaskService verifyTaskService;
    @Autowired
    private DataVerifyTaskService dataVerifyTaskService;

    @RequestMapping(value={"/findOne.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findOne(String taskId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataVerifyTaskService.getTaskById(taskId));
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/findReulst.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findReulst(@RequestParam String projectId, String type, String limitType, Boolean result, Integer verify) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataVerifyTaskService.queryResult(projectId, type, limitType, result, verify));
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/findAnalysReulst.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findReulst(@RequestParam String projectId, String type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataVerifyTaskService.queryAnalysResult(projectId, type));
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/stat.action"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findReulst(@RequestBody TaskStatDTO taskStatDTO) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData(this.verifyTaskService.stat(taskStatDTO));
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

