/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.zbph.constant.base.EnumStatType;
import com.geoway.onemap.zbph.constant.base.EnumXzqLevel;
import com.geoway.onemap.zbph.domain.base.BaseXmxx;
import com.geoway.onemap.zbph.dto.base.XmxxDTO;
import com.geoway.onemap.zbph.service.base.AbstractXmxxManagerService;
import com.geoway.onemap.zbph.service.base.AbstractXmxxService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import com.geoway.web.anno.RequireAuth;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseXmxxController<T extends BaseXmxx, S extends AbstractXmxxService<T>, X extends XmxxDTO<T>, F extends AbstractXmxxManagerService<X, T, S>> {
    private static final Logger log = LoggerFactory.getLogger(BaseXmxxController.class);
    protected final S service;
    protected final F managerService;
    @Autowired
    protected LockUtil lockUtil;

    public BaseXmxxController(S xmxxService, F managerService) {
        this.service = xmxxService;
        this.managerService = managerService;
    }

    @ApiOperation(value="\u4fdd\u5b58\u9879\u76ee")
    @RequireAuth
    @RequestMapping(value={"/saveOrUpdate.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse saveOrUpdate(HttpServletRequest request, @RequestBody X xmxxDTO) {
        try {
            this.managerService.lock(xmxxDTO);
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return BaseObjectResponse.buildSuccessResponse((String)this.managerService.saveOrUpdate(xmxxDTO, user));
        }
        catch (Exception e) {
            log.error("saveOrUpdate.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u4e0a\u4e00\u4e2a\u4e0b\u4e00\u4e2a\u67e5\u8be2")
    @RequireAuth
    @RequestMapping(value={"/findPreCurNextIds.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findPreCurNextIds(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="xmid") String xmid) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)this.service.findPreCurNextIds(filterParam, sortParam, xmid));
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("findPreCurNextIds.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee")
    @RequireAuth
    @RequestMapping(value={"/delete.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delete(HttpServletRequest request, String xmid) {
        try {
            this.lockUtil.getLock(((BaseXmxx)this.service.getDefault()).getLshType() + "_" + xmid);
            this.managerService.deleteByXmid(xmid);
            return BaseObjectResponse.buildSuccessResponse((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("delete.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u9879\u76ee\u8be6\u60c5")
    @RequireAuth
    @RequestMapping(value={"/detail.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse detail(HttpServletRequest request, String xmid) {
        try {
            XmxxDTO dto = this.managerService.detailByXmid(xmid);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)dto);
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("detail.json", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/listPage.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryPage(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="groupCode", required=false, defaultValue="") String groupCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="rows", required=false, defaultValue="10") Integer rows) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Page pages = this.service.findPageByFilter(filterParam, sortParam, groupCode, page.intValue(), rows.intValue());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
            response.setRows(pages.getContent());
        }
        catch (Exception e) {
            log.error("listPage.json", (Throwable)e);
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="\u7edf\u8ba1stat")
    @RequestMapping(value={"/stat.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse stat(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="xzqLevel", required=false, defaultValue="") String xzqLvel, @RequestParam(value="statFields", required=false, defaultValue="") String statFields, @RequestParam(value="statMethods", required=false, defaultValue="") String statMethods, @RequestParam(value="groupFields", required=false, defaultValue="") String groupFields) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            HashMap statFieldMap = new HashMap();
            List statFieldLst = Arrays.stream(statFields.split(";")).collect(Collectors.toList());
            List statMethodLst = Arrays.stream(statMethods.split(";")).collect(Collectors.toList());
            for (int i = 0; i < statFieldLst.size(); ++i) {
                statFieldMap.put(statFieldLst.get(i), EnumStatType.fromValue((String)((String)statMethodLst.get(i))));
            }
            List data = null;
            if (StrUtil.isNotBlank((CharSequence)xzqLvel)) {
                EnumXzqLevel enumXzqLevel = EnumXzqLevel.fromValue((String)xzqLvel);
                data = this.service.stat(filterParam, enumXzqLevel, statFieldMap, groupFields.split(","));
            } else {
                data = this.service.stat(filterParam, statFieldMap, groupFields.split(","));
            }
            response.setData((Object)data);
        }
        catch (Exception e) {
            log.error("listPage.json", (Throwable)e);
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @RequestMapping(value={"/findFields.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFields(@RequestParam(name="groupCode", required=false, defaultValue="project-list") String groupCode) {
        BaseObjectResponse response = new BaseObjectResponse();
        List list = this.service.findGroupFields(groupCode);
        response.setData((Object)list);
        return response;
    }

    @ApiOperation(value="excel\u5bfc\u51fa")
    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="fileName", required=false, defaultValue="\u53f0\u8d26") String fileName, @RequestParam(name="groupCode", required=false, defaultValue="project-list") String groupCode, @RequestParam(name="map", required=false, defaultValue="") String map, @RequestParam(name="template", required=false, defaultValue="") String tempalte, @RequestParam(name="fieldMap", required=false, defaultValue="") String fieldMap) {
        Map valueMap = null;
        if (StrUtil.isNotBlank((CharSequence)map)) {
            valueMap = (Map)JSON.parseObject((String)map, Map.class);
        }
        LinkedHashMap fldMap = null;
        if (StrUtil.isNotBlank((CharSequence)fieldMap)) {
            fldMap = (LinkedHashMap)JSON.parseObject((String)fieldMap, LinkedHashMap.class);
        }
        this.service.exportExcel(response, fileName, filterParam, sortParam, groupCode, valueMap, tempalte, fldMap);
    }

    @ApiOperation(value="shp\u5bfc\u51fa")
    @RequestMapping(value={"/exportShp.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void exportShp(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="fileName", required=false, defaultValue="\u53f0\u8d26") String fileName, @RequestParam(name="groupCode", required=false, defaultValue="") String groupCode, @RequestParam(name="map", required=false, defaultValue="") String map) {
        Map fieldMap = null;
        if (StrUtil.isNotBlank((CharSequence)map)) {
            fieldMap = (Map)JSON.parseObject((String)map, Map.class);
        }
        this.service.exportShp(response, fileName, filterParam, sortParam, groupCode, fieldMap);
    }

    @RequestMapping(value={"/total.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryTotal(@RequestParam(value="filterParam", required=false, defaultValue="") String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        response.setData((Object)this.service.queryTotal(filterParam));
        return response;
    }
}

