/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.interceptor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.dao.SysConfigRepository;
import com.geoway.onemap.core.support.HttpConnectionUtil;
import com.geoway.sso.client.listener.LogoutListener;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.SessionMappingStorage;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LoginHandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SessionMappingStorage sessionMappingStorage;
    @Value(value="${sso.server.url}")
    private String serverUrl;
    @Value(value="${sso.app.id}")
    private String appId;
    @Value(value="${token.expire}")
    private Integer tokenExpire;
    @Value(value="${sso.enable}")
    private boolean ssoEnable;
    @Value(value="${sso.refresh.token:false}")
    private boolean refresh;
    @Value(value="${sso.refresh.time:300}")
    private int refreshTime;
    @Value(value="${access.verify.enable:true}")
    private Boolean enable;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private SysConfigRepository sysConfigDao;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean flag = super.preHandle(request, response, handler);
        String accessToken = request.getHeader("access_token");
        if (StringUtils.isNotBlank((CharSequence)accessToken) && request.getMethod().indexOf("logout") == -1) {
            Long expire = this.redisTemplate.getExpire((Object)accessToken);
            JSONObject tokenInfo = (JSONObject)this.redisTemplate.boundValueOps((Object)accessToken).get();
            if (this.ssoEnable) {
                if (expire > (long)this.refreshTime) {
                    return true;
                }
                if (this.refresh && tokenInfo != null) {
                    return this.refreshToken(tokenInfo.getString("refreshToken"));
                }
                Result<RpcAccessToken> queryResult = this.queryAccessToken(accessToken, request);
                if (queryResult.getData() == null) {
                    return true;
                }
                return true;
            }
            String key = "token:" + accessToken;
            String stringValue = this.redisTemplate.opsForValue().get((Object)key).toString();
            if (stringValue != null && stringValue.length() > 0) {
                String[] expireArr = stringValue.split(";");
                String user = expireArr[0];
                String userId = expireArr[1];
                String pwd = expireArr[2];
                long currentTime = System.currentTimeMillis();
                long expireTime = Convert.toLong((Object)expireArr[3], (Long)(currentTime + 900000L));
                long uisExpireTime = 0L;
                if (expireArr.length == 5) {
                    uisExpireTime = Convert.toLong((Object)expireArr[4], (Long)(currentTime + 900000L));
                }
                int expireHours = this.tokenExpire == null ? 2 : this.tokenExpire;
                long expireTime2 = currentTime + (long)expireHours * 3600L * 1000L;
                String expireInfo = user + ";" + userId + ";" + pwd + ";" + expireTime2;
                if (expireTime > currentTime && expireTime - currentTime < 1800000L) {
                    this.redisTemplate.opsForValue().set((Object)accessToken, (Object)userId, (long)expireHours, TimeUnit.HOURS);
                    this.redisTemplate.opsForValue().set((Object)key, (Object)expireInfo, (long)expireHours, TimeUnit.HOURS);
                }
                if (uisExpireTime > 0L && uisExpireTime < currentTime + 1800000L) {
                    String url = this.sysConfigDao.queryByKey("oauth.UISURL").getValue() + "/manager/Oauth/verifyToken/" + accessToken;
                    String result = HttpConnectionUtil.AccessUrl((String)url, (String)"");
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String status = jsonObject.getString("status");
                    if ("OK".equalsIgnoreCase(status)) {
                        long uisExpireTime2 = currentTime + 3600000L;
                        expireInfo = expireInfo + ";" + uisExpireTime2;
                        this.redisTemplate.opsForValue().set((Object)key, (Object)expireInfo);
                    } else {
                        this.markLoginResponse(response);
                        return false;
                    }
                }
            }
        }
        if (this.enable.booleanValue() && StringUtils.isEmpty((CharSequence)accessToken)) {
            this.markLoginResponse(response);
            return false;
        }
        return flag;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    }

    private void markLoginResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResopnse = new BaseResponse();
        baseResopnse.markNoLogin();
        baseResopnse.setMessage("\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }

    private Result<RpcAccessToken> queryAccessToken(String accessToken, HttpServletRequest request) {
        Result result = Oauth2Utils.queryAccessToken((String)this.serverUrl, (String)accessToken);
        if (result != null && result.isSuccess()) {
            this.setUserCache((RpcAccessToken)result.getData());
        }
        return result;
    }

    private boolean refreshToken(String refreshToken) {
        Result result = Oauth2Utils.refreshToken((String)this.serverUrl, (String)this.appId, (String)refreshToken);
        if (!result.isSuccess()) {
            this.logger.error("refreshToken has error, message:{}", (Object)result.getMessage());
            return false;
        }
        this.setUserCache((RpcAccessToken)result.getData());
        return true;
    }

    public void setUserCache(RpcAccessToken rpcAccessToken) {
        Integer expire = rpcAccessToken.getExpiresIn();
        SsoUser ssoUser = rpcAccessToken.getUser();
        String token = rpcAccessToken.getAccessToken();
        if (ObjectUtil.isNull((Object)ssoUser) || StringUtils.isBlank((CharSequence)token)) {
            return;
        }
        String key = "token:" + token;
        String userId = ssoUser.getId();
        String userName = ssoUser.getUserName();
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + (long)expire.intValue();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            String expireInfo = userName + ";" + userName + ";;" + expireTime;
            this.redisTemplate.opsForValue().set((Object)token, BeanUtil.toBean((Object)rpcAccessToken, JSONObject.class), (long)(expire - 60), TimeUnit.SECONDS);
            this.redisTemplate.opsForValue().set((Object)key, (Object)expireInfo, (long)(expire - 60), TimeUnit.SECONDS);
        }
    }

    protected SessionMappingStorage getSessionMappingStorage() {
        if (this.sessionMappingStorage == null) {
            this.sessionMappingStorage = LogoutListener.getSessionMappingStorage();
        }
        return this.sessionMappingStorage;
    }

    private boolean setAccessTokenInSession(RpcAccessToken rpcAccessToken, HttpServletRequest request) {
        if (rpcAccessToken == null) {
            return false;
        }
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        this.recordSession(request, rpcAccessToken.getAccessToken(), rpcAccessToken.getUser().getLoginName());
        return true;
    }

    private void recordSession(HttpServletRequest request, String accessToken, String userName) {
        HttpSession session = request.getSession();
        this.getSessionMappingStorage().removeBySessionById(session.getId());
        this.getSessionMappingStorage().addSessionById(accessToken, session);
        this.getSessionMappingStorage().removeTokenByUserName(userName);
        this.getSessionMappingStorage().addTokenByUserName(accessToken, userName);
    }
}

