ALTER TABLE public.tb_zbph_zbk_ckmx ADD f_ckxzqdm varchar(12) NULL;
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx.f_ckxzqdm IS '出库行政区划代码';
ALTER TABLE public.tb_zbph_zbk_ckmx ADD f_ckxzqmc varchar(64) NULL;
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx.f_ckxzqmc IS '出库行政区名称';


ALTER TABLE public.tb_zbph_zbk_ckgcmx ADD f_ckxzqdm varchar(12) NULL;
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx.f_ckxzqdm IS '出库行政区划代码';
ALTER TABLE public.tb_zbph_zbk_ckgcmx ADD f_ckxzqmc varchar(64) NULL;
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx.f_ckxzqmc IS '出库行政区名称';


ALTER TABLE public.tb_zbph_zbk_rkmx ADD f_lyid varchar(64) NULL;
COMMENT ON COLUMN public.tb_zbph_zbk_rkmx.f_lyid IS '指标来源id，调剂入库的时候,与出库明细中的主键id一一对应';

CREATE TABLE public.tb_zbph_zbk_czmx (
	f_id varchar(64) NULL,
	f_sid varchar(64) NULL,
	f_czxzqdm varchar(12) NULL,
	f_czxzqmc varchar(64) NULL,
	f_czlx varchar(64) NULL,
	f_zblx varchar(64) NULL,
	f_gdmj numeric(20, 4) NULL,
	f_stmj numeric(20, 4) NULL,
	f_cnzb numeric(20, 4) NULL,
	f_date timestamp(6) NULL,
	f_userid varchar(255) NULL,
	f_username varchar(255) NULL,
	f_zy varchar NULL,
	f_rkck varchar(12) NULL,
	f_zbxzqdm varchar(12) NULL,
	f_zbxzqmc varchar(64) NULL,
	CONSTRAINT tb_zbph_zbk_czmx_pk PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zbk_czmx_un UNIQUE (f_sid)
);
COMMENT ON TABLE public.tb_zbph_zbk_czmx IS '指标库操作明细';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_sid IS '操作流水号';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_czxzqdm IS '操作行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_czxzqmc IS '操作行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_czlx IS '操作类型';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_zblx IS '指标类型';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_gdmj IS '耕地指标';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_stmj IS '水田指标';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_cnzb IS '产能指标';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_date IS '操作时间';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_userid IS '用户id';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_username IS '用户名称';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_zy IS '操作摘要';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_rkck IS '出库还是入库';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_zbxzqdm IS '指标行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_czmx.f_zbxzqmc IS '指标行政区名称';
