drop table if exists  tb_zbph_process_model;
CREATE TABLE public.tb_zbph_process_model (
	f_id varchar(64) NOT NULL,
	f_name varchar(64) NULL,
	f_detail varchar NULL,
	f_group varchar(64) NULL,
	f_rolename varchar(255) NULL,
	f_enable int2 NULL,
	CONSTRAINT tb_zbpg_process_model_pk PRIMARY KEY (f_id)
);
CREATE UNIQUE INDEX tb_zbpg_process_model_f_name_idx ON public.tb_zbph_process_model USING btree (f_name);

INSERT INTO public.tb_zbph_process_model (f_id,f_name,f_detail,f_group,f_rolename,f_enable) VALUES
	 ('4','非粮图斑入库_县级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p41"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','县级填报,县级用户',0),
	 ('13','非粮出库_县级填报_市级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','县级填报,县级用户',0),
	 ('17','非农出库_市级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["市级填报"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','市级填报',0),
	 ('18','非农出库_县级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relatedRoles":["省级用户","省级审核"],
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','县级填报,县级用户',0),
	 ('11','非粮出库_县级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relatedRoles":["省级用户","省级审核"],
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','县级填报,县级用户',0),
	 ('16','非农出库_市级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["市级填报"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','市级填报',0),
	 ('2','非粮图斑入库_市级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p41"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','市级填报',0),
	 ('14','非粮出库_县级填报_县级审核_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p11"]
	},
	{
		"processState": "p1",
		"processStateStr": "县级审核",
		"checkState": "p1",
		"checkStateStr": "县级审核",
		"refusedState": "p11",
		"refusedStateStr": "县级退回",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','县级填报,县级用户',0),
	 ('22','新方式入库验收-县级','[{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0", "p02", "p31", "p41"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"]
	},
	{
		"processState": "p21",
		"processStateStr": "待外业核查",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p21"]
	},
	{
		"processState": "p22",
		"processStateStr": "外业核查中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p22"]
	},
	{
		"processState": "p23",
		"processStateStr": "完成外业核查",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p23"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"relatedRoles":["市级用户","市级审核"],
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relateStates": ["p3"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfsbcgdys.impl.XfsbcgdYsManageServiceImpl",
		      "invokeType":"before"
		   }
		]
	}
]','YS','县级填报,县级用户',1),
	 ('5','非粮图斑入库_县级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p31"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"relatedRoles":["市级用户","市级审核"],
		"refusedStateStr": "市级退回",
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','县级填报,县级用户',1);
INSERT INTO public.tb_zbph_process_model (f_id,f_name,f_detail,f_group,f_rolename,f_enable) VALUES
	 ('23','新方式入库立项-县级','[{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0", "p02", "p31", "p41"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"]
	},
	{
		"processState": "p21",
		"processStateStr": "待外业核查",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p21"]
	},
	{
		"processState": "p22",
		"processStateStr": "外业核查中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p22"]
	},
	{
		"processState": "p23",
		"processStateStr": "完成外业核查",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles": ["县级填报", "县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p23"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relateStates": ["p3"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','LX','县级填报,县级用户',1),
	 ('15','非农出库_省级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "省级拟件",
		"checkState": "p0",
		"checkStateStr": "省级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["省级填报"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','省级填报',0),
	 ('19','非农出库_县级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','县级填报,县级用户',1),
	 ('1','非粮图斑入库_省级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "省级拟件",
		"checkState": "p0",
		"checkStateStr": "省级拟件",
		"relatedRoles":["省级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p41"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "省级拟件",
		"relatedRoles":["省级填报"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "省级拟件",
		"relatedRoles":["省级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','省级填报',0),
	 ('21','非农出库_县级填报_县级审核_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p11"]
	},
	{
		"processState": "p1",
		"processStateStr": "县级审核",
		"checkState": "p1",
		"checkStateStr": "县级审核",
		"refusedState": "p11",
		"refusedStateStr": "县级退回",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','县级填报,县级用户',0),
	 ('20','非农出库_县级填报_市级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FNZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FNCK','县级填报,县级用户',0),
	 ('7','非粮图斑入库_县级填报_县级审核_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p11"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p1",
		"processStateStr": "县级审核中",
		"checkState": "p1",
		"checkStateStr": "县级审核",
		"refusedState": "p11",
		"relatedRoles":["县级审核"],
		"refusedStateStr": "县级退回",
		"relateStates": ["p1","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"relatedRoles":["市级用户","市级审核"],
		"refusedStateStr": "市级退回",
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','县级填报,县级用户',0),
	 ('8','非粮出库_省级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "省级拟件",
		"checkState": "p0",
		"checkStateStr": "省级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["省级填报"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','省级填报',0),
	 ('12','非粮出库_县级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["县级填报","县级用户"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','县级填报,县级用户',1),
	 ('9','非粮出库_市级填报_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["市级填报"],
		"relateStates": ["p0","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','市级填报',0);
INSERT INTO public.tb_zbph_process_model (f_id,f_name,f_detail,f_group,f_rolename,f_enable) VALUES
	 ('10','非粮出库_市级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"refusedState": "",
		"refusedStateStr": "",
        "relatedRoles":["市级填报"],
		"relateStates": ["p0","p31"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"refusedStateStr": "市级退回",
		"relatedRoles":["市级用户","市级审核"],
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"refusedState": "p41",
		"relatedRoles":["省级用户","省级审核"],
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"refusedState": "",
		"refusedStateStr": "",
		"relatedRoles":[],
		"relateStates": ["p51"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.zgck.impl.FLZgckProcessFinishedImpl",
		      "invokeType":"after"
		   }
		]
	}
]','FLCK','市级填报',0),
	 ('3','非粮图斑入库_市级填报_市级审核_省级审核','[
	{
		"processState": "p0",
		"processStateStr": "市级拟件",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p31"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "市级拟件",
		"relatedRoles":["市级填报"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"relatedRoles":["市级用户","市级审核"],
		"refusedStateStr": "市级退回",
		"relateStates": ["p3","p41"]
	},
	{
		"processState": "p4",
		"processStateStr": "省级审核中",
		"checkState": "p4",
		"checkStateStr": "省级审核",
		"relatedRoles":["省级用户","省级审核"],
		"refusedState": "p41",
		"refusedStateStr": "省级退回",
		"relateStates": ["p4"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','市级填报',0),
	 ('6','非粮图斑入库_县级填报_市级审核','[
	{
		"processState": "p0",
		"processStateStr": "县级拟件",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p0","p02","p31"]
	},
	{
		"processState": "p01",
		"processStateStr": "数据查验中",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "p02",
		"refusedStateStr": "内业查验退回",
		"relateStates": ["p01"],
		"taskListeners":[
		   {
		      "className":"com.geoway.onemap.zbph.service.xfshfgdtbrk.impl.ZbkhfgdTbrkVerifyTaskCreateImpl",
		      "invokeType":"after"
		   }
		]
	},
	{
		"processState": "p03",
		"processStateStr": "完成数据查验",
		"checkState": "p0",
		"checkStateStr": "县级拟件",
		"relatedRoles":["县级填报","县级用户"],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p03"]
	},
	{
		"processState": "p3",
		"processStateStr": "市级审核中",
		"checkState": "p3",
		"checkStateStr": "市级审核",
		"refusedState": "p31",
		"relatedRoles":["市级用户","市级审核"],
		"refusedStateStr": "市级退回",
		"relateStates": ["p3"]
	},
	{
		"processState": "p51",
		"processStateStr": "已完成备案",
		"checkState": "p51",
		"checkStateStr": "已完成备案",
		"relatedRoles":[],
		"refusedState": "",
		"refusedStateStr": "",
		"relateStates": ["p51"]
	}
]','FLTBRK','县级填报,县级用户',0);
