CREATE TABLE tb_zbph_yjxm_xmfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_xmid varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	f_jzds int2 NULL, -- 界址点数
	f_dkmj numeric NULL, -- 地块面积
	f_dkbh varchar(200) NULL, -- 地块编号
	f_dkmc varchar(200) NULL, -- 地块名称
	f_txsx varchar(32) NULL, -- 图形属性
	f_tfh varchar(200) NULL, -- 图幅号
	f_dkyt varchar(200) NULL, -- 地块用途
	f_bz varchar(200) NULL, -- 备注
	CONSTRAINT tb_zbph_yjxm_xmfw_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_yjxm_xmfw_shape_idx ON public.tb_zbph_yjxm_xmfw USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_yjxm_xmfw IS '预检库-项目范围';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_xmid IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_jzds IS '界址点数';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_dkmj IS '地块面积';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_dkbh IS '地块编号';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_tfh IS '图幅号';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_dkyt IS '地块用途';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmfw.f_bz IS '备注';

CREATE TABLE tb_zbph_yjxm_xmxx (
	f_id varchar(64) NOT NULL, -- 主键
	f_name varchar(100) NULL, -- 项目名称
	f_yjbh varchar(64) NULL, -- 预检编号
	f_xmnf timestamp NULL, -- 项目年份
	f_create_time timestamp NULL, -- 创建时间
	f_status int2 NULL, -- 200 完成 500 失败 0 分析中
	f_rule_status int2 NULL, -- 1 通过 2 不通过
	f_sort int8 NULL, -- 排序值
	f_xzqdm varchar(32) NULL, -- 行政区代码
	CONSTRAINT tb_zbph_yjxm_xmxx_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_yjxm_xmxx IS '预检库-项目表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_name IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_yjbh IS '预检编号';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_xmnf IS '项目年份';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_create_time IS '创建时间';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_status IS '200 完成 500 失败 0 分析中';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_rule_status IS '1 通过 2 不通过';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_sort IS '排序值';
COMMENT ON COLUMN public.tb_zbph_yjxm_xmxx.f_xzqdm IS '行政区代码';


CREATE TABLE tb_zbph_yjxm_xzgdfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_xmid varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	f_jzds int2 NULL, -- 界址点数
	f_dkmj numeric NULL, -- 地块面积
	f_dkbh varchar(200) NULL, -- 地块编号
	f_dkmc varchar(200) NULL, -- 地块名称
	f_txsx varchar(32) NULL, -- 图形属性
	f_tfh varchar(200) NULL, -- 图幅号
	f_dkyt varchar(200) NULL, -- 地块用途
	f_yuliu text NULL, -- 预留
	f_tblx varchar(64) NULL, -- 图斑类型
	f_dlbm varchar(200) NULL, -- 地类编码
	f_gzqpjzldb numeric NULL, -- 改造前平均质量等别
	f_gzhpjzldb numeric NULL, -- 改造后平均质量等别
	CONSTRAINT tb_zbph_yjxm_xzgdfw_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_yjxm_xzgdfw_shape_idx ON public.tb_zbph_yjxm_xzgdfw USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_yjxm_xzgdfw IS '预检库-补充耕地范围';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_xmid IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_jzds IS '界址点数';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_dkmj IS '地块面积';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_dkbh IS '地块编号';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_tfh IS '图幅号';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_dkyt IS '地块用途';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_yuliu IS '预留';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_tblx IS '图斑类型';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_dlbm IS '地类编码';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_gzqpjzldb IS '改造前平均质量等别';
COMMENT ON COLUMN public.tb_zbph_yjxm_xzgdfw.f_gzhpjzldb IS '改造后平均质量等别';