DROP MATERIALIZED VIEW if exists v_zbph_fnzgck_xmshzt_xzq cascade;
DROP MATERIALIZED VIEW if exists v_zbph_fnzgck_xmshzt_ring cascade;
DROP MATERIALIZED VIEW if exists v_zbph_fnzgck_xmshzt cascade;
DROP MATERIALIZED VIEW if exists v_zbph_fnzgck_xmtj_xzq cascade;
DROP MATERIALIZED VIEW if exists v_zbph_fnzgck_xmxz_barchart cascade;
drop table  if exists tb_zbph_zgck_xmxx;
-- public.tb_zbph_zgck_xmxx definition

-- Drop table

-- DROP TABLE public.tb_zbph_zgck_xmxx;

CREATE TABLE public.tb_zbph_zgck_xmxx (
	f_id varchar(64) NOT NULL,
	f_xmmc varchar(100) NULL,
	f_xzqmc varchar(255) NULL,
	f_xmbh varchar(100) NULL,
	f_create_time timestamptz(6) NULL,
	f_userid varchar(64) NULL,
	f_xzqdm varchar(20) NULL,
	f_processstate varchar(16) NULL,
	f_xmxz varchar(255) NULL,
	f_xmxz_code varchar(255) NULL,
	f_jsmj float8 NULL,
	f_zygdmj float8 NULL,
	f_xbcstgm float8 NULL,
	f_xbcgdsl float8 NULL,
	f_xbclscn float8 NULL,
	f_sfwdzz int2 NULL DEFAULT 0,
	f_sfkcn int2 NULL DEFAULT 0,
	f_cnrq timestamptz(6) NULL,
	f_sfgjzdjsxm int2 NULL DEFAULT 0,
	f_username varchar(255) NULL,
	f_usertel varchar(255) NULL,
	f_bz text NULL,
	f_hx_state int2 NOT NULL DEFAULT 0,
	f_hx_date timestamp(6) NULL,
	f_hx_bs varchar(64) NULL,
	f_bcgdsl float8 NULL DEFAULT 0,
	f_bcstgm float8 NULL DEFAULT 0,
	f_bclscn float8 NULL DEFAULT 0,
	f_bcggxmgs int4 NULL DEFAULT 0,
	f_cksid varchar(64) NULL,
	f_finish_time timestamp(6) NULL,
	f_update_time timestamp(6) NULL,
	f_processid varchar(64) NULL,
	f_processstatestr varchar(64) NULL,
	f_cklx varchar(64) NULL,
	f_xmxzqdm varchar(12) NULL,
	f_xmxzqmc varchar(64) NULL,
	f_processgroup varchar(64) NULL,
	CONSTRAINT tb_project_gdbh_cbbcgd_fnzygd_pkey_1 PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zgck_xmxx_name_ UNIQUE (f_cklx, f_xmmc)
);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_update_time_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_update_time);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_xmbh_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_xmbh);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_xmmc_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_xmmc);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_xmxz_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_xmxz);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_xmxzqdm_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_xmxzqdm);
CREATE INDEX tb_zbph_zgck_xmxx_fn_f_xzqdm_idx_1 ON public.tb_zbph_zgck_xmxx USING btree (f_xzqdm);

delete from tb_model_fields where f_tablename='tb_zbph_zgck_xmxx';
INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89900000010','tb_zbph_zgck_xmxx','f_processstatestr','项目状态',0,'varchar',100,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000039','tb_zbph_zgck_xmxx','f_xmxzqmc','项目所在地',0,'varchar',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000001','tb_zbph_zgck_xmxx','f_id','主键',1,'varchar',64,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000002','tb_zbph_zgck_xmxx','f_xmmc','项目名称',0,'varchar',100,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000003','tb_zbph_zgck_xmxx','f_xzqmc','项目所在地',0,'varchar',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000004','tb_zbph_zgck_xmxx','f_xmbh','项目编号',0,'varchar',100,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000005','tb_zbph_zgck_xmxx','f_create_time','创建时间',0,'timestamp',6,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000006','tb_zbph_zgck_xmxx','f_userid','创建人ID',0,'varchar',64,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000007','tb_zbph_zgck_xmxx','f_xzqdm','用户行政区划代码',0,'varchar',20,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000040','tb_zbph_zgck_xmxx','f_xmxzqdm','行政区划代码',0,'varchar',20,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL);
INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89900000008','tb_zbph_zgck_xmxx','f_processstate','项目状态',0,'varchar',16,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000009','tb_zbph_zgck_xmxx','f_processid','流程id',0,'varchar',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000014','tb_zbph_zgck_xmxx','f_xmxz','项目性质',0,'varchar',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000015','tb_zbph_zgck_xmxx','f_xmxz_code','项目性质代码',0,'varchar',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000016','tb_zbph_zgck_xmxx','f_jsmj','项目建设面积',0,'numeric',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000017','tb_zbph_zgck_xmxx','f_zygdmj','占用总耕地面积（公顷）',0,'numeric',8,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000018','tb_zbph_zgck_xmxx','f_xbcstgm','需补充水田规模（公顷）',0,'numeric',8,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000019','tb_zbph_zgck_xmxx','f_xbcgdsl','需补充耕地数量（公顷）',0,'numeric',8,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000020','tb_zbph_zgck_xmxx','f_xbclscn','需补充粮食产能（公斤）',0,'numeric',8,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000021','tb_zbph_zgck_xmxx','f_sfwdzz','是否稳定增长项目',0,'int2',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL);
INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89900000022','tb_zbph_zgck_xmxx','f_sfkcn','是否可承诺',0,'int2',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000023','tb_zbph_zgck_xmxx','f_cnrq','承诺日期',0,'timestamp',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000024','tb_zbph_zgck_xmxx','f_sfgjzdjsxm','国家重点建设项目（可使用国家统筹指标）',0,'int2',255,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000025','tb_zbph_zgck_xmxx','f_username','填报人姓名',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000026','tb_zbph_zgck_xmxx','f_usertel','填报人电话',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000027','tb_zbph_zgck_xmxx','f_bz','备注',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000028','tb_zbph_zgck_xmxx','f_hx_state','核销状态 0未核销 1核销',0,'int2',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000029','tb_zbph_zgck_xmxx','f_hx_date','核销时间',0,'timestamp',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000030','tb_zbph_zgck_xmxx','f_hx_bs','核销标识',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000031','tb_zbph_zgck_xmxx','f_bcgdsl','补充耕地数量',0,'numeric',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL);
INSERT INTO public.tb_model_fields (f_id,f_tablename,f_fieldname,f_alias,f_isprimary,f_fieldtype,f_length,f_precision,f_nullable,f_defaultvalue,f_codetableid,f_remark,f_order,f_tableid,f_isbase,f_islistshow,f_iswebedit,f_metainfo,f_displaytype,f_unique,f_ismust,f_diclevel,f_ischopredic) VALUES
	 ('89900000032','tb_zbph_zgck_xmxx','f_bcstgm','补充水田规模',0,'numeric',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000033','tb_zbph_zgck_xmxx','f_bclscn','补充粮食产能',0,'numeric',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000034','tb_zbph_zgck_xmxx','f_bcggxmgs','补充挂钩个数',0,'int4',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000035','tb_zbph_zgck_xmxx','f_cksid','出库流水号',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000036','tb_zbph_zgck_xmxx','f_cklx','出库类型',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,0,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000037','tb_zbph_zgck_xmxx','f_update_time','更新时间',0,'timestamp',6,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000038','tb_zbph_zgck_xmxx','f_finish_time','完成时间',0,'timestamp',6,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL),
	 ('89900000041','tb_zbph_zgck_xmxx','f_processgroup','流程组别',0,'varchar',50,NULL,0,NULL,NULL,NULL,30,'8',NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL);

delete from tb_model_group where f_tablename='tb_zbph_zgck_xmxx';
INSERT INTO public.tb_model_group (f_id,f_groupcode,f_fieldid,f_fieldorder,f_tablename,f_visible) VALUES
	 ('89900000002','project-list','89900000002',1,'tb_zbph_zgck_xmxx',1),
	 ('89900000003','project-list','89900000039',2,'tb_zbph_zgck_xmxx',1),
	 ('89900000005','project-list','89900000005',5,'tb_zbph_zgck_xmxx',1),
	 ('89900000014','project-list','89900000014',3,'tb_zbph_zgck_xmxx',1),
	 ('89900000010','project-list','89900000010',4,'tb_zbph_zgck_xmxx',1);

ALTER TABLE public.tb_zbph_zgck_xmxx_fl ADD f_processgroup varchar NULL;
update tb_zbph_zgck_xmxx_fl set f_processgroup='FLCK';
update tb_zbph_zgck_xmxx_fl set f_cklx='02';

ALTER TABLE public.tb_zbph_zgck_xmxx_fn ADD f_processgroup varchar NULL;
update tb_zbph_zgck_xmxx_fn set f_processgroup='FNCK';
update tb_zbph_zgck_xmxx_fn set f_cklx='01';

INSERT INTO tb_zbph_zgck_xmxx SELECT * from tb_zbph_zgck_xmxx_fl;
INSERT INTO tb_zbph_zgck_xmxx SELECT * from tb_zbph_zgck_xmxx_fn;

drop table if exists tb_zbph_zgck_xmxx_fl;
drop table if exists tb_zbph_zgck_xmxx_fn;


update tb_zbph_process_model set f_detail =replace(f_detail,'FNZgckProcessFinishedImpl','ZgckProcessFinishedImpl');
update tb_zbph_process_model set f_detail =replace(f_detail,'FLZgckProcessFinishedImpl','ZgckProcessFinishedImpl');


CREATE MATERIALIZED VIEW public.v_zbph_fnzgck_xmshzt
AS SELECT b.f_name,
    a.xzqhdm,
    sum(a."合计") AS "合计",
    sum(a."拟件") AS "拟件",
    sum(a."市级审核中") AS "市级审核中",
    sum(a."市级退回") AS "市级退回",
    sum(a."省级审核中") AS "省级审核中",
    sum(a."省级退回") AS "省级退回",
    sum(a."已完成备案") AS "已完成备案"
   FROM ( SELECT tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm,
            count(*) AS "合计",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
                    ELSE 0
                END) AS "拟件",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
                    ELSE 0
                END) AS "市级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
                    ELSE 0
                END) AS "市级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
                    ELSE 0
                END) AS "省级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
                    ELSE 0
                END) AS "省级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
                    ELSE 0
                END) AS "已完成备案"
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY tb_zbph_zgck_xmxx.f_xzqdm
        UNION
         SELECT "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm,
            count(*) AS "合计",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
                    ELSE 0
                END) AS "拟件",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
                    ELSE 0
                END) AS "市级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
                    ELSE 0
                END) AS "市级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
                    ELSE 0
                END) AS "省级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
                    ELSE 0
                END) AS "省级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
                    ELSE 0
                END) AS "已完成备案"
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text)
        UNION
         SELECT "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm,
            count(*) AS "合计",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
                    ELSE 0
                END) AS "拟件",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
                    ELSE 0
                END) AS "市级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
                    ELSE 0
                END) AS "市级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
                    ELSE 0
                END) AS "省级审核中",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
                    ELSE 0
                END) AS "省级退回",
            sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
                    ELSE 0
                END) AS "已完成备案"
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text)) a
     LEFT JOIN tbime_region b ON a.xzqhdm::text = b.f_code::text
  GROUP BY b.f_name, a.xzqhdm
WITH DATA;

CREATE MATERIALIZED VIEW public.v_zbph_fnzgck_xmshzt_ring
AS SELECT sum(a.value) AS value,
    a.type,
    a.xzqhdm
   FROM ((
                (
                        (
                                (
 SELECT count(*) AS value,
    '合计'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '合计'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
   ELSE 0
  END) AS value,
    '拟件'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '拟件'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
   ELSE 0
  END) AS value,
    '市级审核中'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '市级审核中'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
   ELSE 0
  END) AS value,
    '市级退回'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '市级退回'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
   ELSE 0
  END) AS value,
    '省级审核中'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '省级审核中'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
   ELSE 0
  END) AS value,
    '省级退回'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '省级退回'::text
UNION
 SELECT sum(
  CASE
   WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
   ELSE 0
  END) AS value,
    '已完成备案'::text AS type,
    tb_zbph_zgck_xmxx.f_xzqdm AS xzqhdm
   FROM tb_zbph_zgck_xmxx where f_cklx='01'
  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '已完成备案'::text
                                ) UNION ALL
                                 SELECT count(*) AS value,
                                    '合计'::text AS type,
                                    "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                                   FROM tb_zbph_zgck_xmxx where f_cklx='01'
                                  GROUP BY tb_zbph_zgck_xmxx.f_xzqdm, '合计'::text
                        ) UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '拟件'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '拟件'::text
                        UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '市级审核中'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '市级审核中'::text
                        UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '市级退回'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '市级退回'::text
                        UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '省级审核中'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '省级审核中'::text
                        UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '省级退回'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '省级退回'::text
                        UNION
                         SELECT sum(
                                CASE
                                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
                                    ELSE 0
                                END) AS value,
                            '已完成备案'::text AS type,
                            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm
                           FROM tb_zbph_zgck_xmxx where f_cklx='01'
                          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 4) || '00'::text), '已完成备案'::text
                ) UNION ALL
                 SELECT count(*) AS value,
                    '合计'::text AS type,
                    "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
                   FROM tb_zbph_zgck_xmxx where f_cklx='01'
                  GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '合计'::text
        ) UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p0'::text THEN 1
                    ELSE 0
                END) AS value,
            '拟件'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '拟件'::text
        UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p3'::text THEN 1
                    ELSE 0
                END) AS value,
            '市级审核中'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '市级审核中'::text
        UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p31'::text THEN 1
                    ELSE 0
                END) AS value,
            '市级退回'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '市级退回'::text
        UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p4'::text THEN 1
                    ELSE 0
                END) AS value,
            '省级审核中'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '省级审核中'::text
        UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p41'::text THEN 1
                    ELSE 0
                END) AS value,
            '省级退回'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '省级退回'::text
        UNION
         SELECT sum(
                CASE
                    WHEN tb_zbph_zgck_xmxx.f_processstate::text = 'p51'::text THEN 1
                    ELSE 0
                END) AS value,
            '已完成备案'::text AS type,
            "substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm
           FROM tb_zbph_zgck_xmxx where f_cklx='01'
          GROUP BY ("substring"(tb_zbph_zgck_xmxx.f_xzqdm::text, 1, 2) || '0000'::text), '已完成备案'::text) a
  GROUP BY a.type, a.xzqhdm
WITH DATA;

-- public.v_zbph_fnzgck_xmshzt_xzq source

CREATE MATERIALIZED VIEW public.v_zbph_fnzgck_xmshzt_xzq
AS SELECT f.f_xzqdm,
    count(*) AS "备案项目总数",
    count(*) FILTER (WHERE f.f_processstate::text = 'p0'::text) AS "拟件",
    count(*) FILTER (WHERE f.f_processstate::text = 'p3'::text OR f.f_processstate::text = 'p4'::text) AS "审核中",
    count(*) FILTER (WHERE f.f_processstate::text = 'p51'::text) AS "备案完成",
    count(*) FILTER (WHERE f.f_processstate::text = 'p31'::text OR f.f_processstate::text = 'p41'::text) AS "退回"
   FROM tb_zbph_zgck_xmxx f where f.f_cklx='01'
  GROUP BY f.f_xzqdm
WITH DATA;


CREATE MATERIALIZED VIEW public.v_zbph_fnzgck_xmtj_xzq
AS SELECT sum(a."备案项目总数") AS "备案项目总数",
    sum(a."拟件") AS "拟件",
    sum(a."审核中") AS "审核中",
    sum(a."备案完成") AS "备案完成",
    sum(a."退回") AS "退回",
    a.xzqhdm
   FROM ( SELECT f.f_xzqdm AS xzqhdm,
            count(*) AS "备案项目总数",
            count(*) FILTER (WHERE f.f_processstate::text = 'p0'::text) AS "拟件",
            count(*) FILTER (WHERE f.f_processstate::text = 'p3'::text OR f.f_processstate::text = 'p4'::text) AS "审核中",
            count(*) FILTER (WHERE f.f_processstate::text = 'p51'::text) AS "备案完成",
            count(*) FILTER (WHERE f.f_processstate::text = 'p31'::text OR f.f_processstate::text = 'p41'::text) AS "退回"
           FROM tb_zbph_zgck_xmxx f where f.f_cklx='01'
          GROUP BY f.f_xzqdm
        UNION ALL
         SELECT "substring"(f.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm,
            count(*) AS "备案项目总数",
            count(*) FILTER (WHERE f.f_processstate::text = 'p0'::text) AS "拟件",
            count(*) FILTER (WHERE f.f_processstate::text = 'p3'::text OR f.f_processstate::text = 'p4'::text) AS "审核中",
            count(*) FILTER (WHERE f.f_processstate::text = 'p51'::text) AS "备案完成",
            count(*) FILTER (WHERE f.f_processstate::text = 'p31'::text OR f.f_processstate::text = 'p41'::text) AS "退回"
           FROM tb_zbph_zgck_xmxx f where f.f_cklx='01'
          GROUP BY ("substring"(f.f_xzqdm::text, 1, 4) || '00'::text)
        UNION ALL
         SELECT "substring"(f.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm,
            count(*) AS "备案项目总数",
            count(*) FILTER (WHERE f.f_processstate::text = 'p0'::text) AS "拟件",
            count(*) FILTER (WHERE f.f_processstate::text = 'p3'::text OR f.f_processstate::text = 'p4'::text) AS "审核中",
            count(*) FILTER (WHERE f.f_processstate::text = 'p51'::text) AS "备案完成",
            count(*) FILTER (WHERE f.f_processstate::text = 'p31'::text OR f.f_processstate::text = 'p41'::text) AS "退回"
           FROM tb_zbph_zgck_xmxx f where f.f_cklx='01'
          GROUP BY ("substring"(f.f_xzqdm::text, 1, 2) || '0000'::text)) a
  GROUP BY a.xzqhdm
WITH DATA;

-- public.v_zbph_fnzgck_xmxz_barchart source

CREATE MATERIALIZED VIEW public.v_zbph_fnzgck_xmxz_barchart
AS SELECT sum(a."总数") AS "总数",
    sum(a."已完成备案数") AS "已完成备案数",
    a.xzqhdm,
    a.f_xmxz_code,
    a.f_xmxz
   FROM ( SELECT count(t.f_id) AS "总数",
            count(t.f_id) FILTER (WHERE t.f_processstate::text = 'p51'::text) AS "已完成备案数",
            t.f_xzqdm AS xzqhdm,
            t.f_xmxz_code,
            t.f_xmxz
           FROM tb_zbph_zgck_xmxx t  where t.f_cklx='01'
          GROUP BY t.f_xmxz_code, t.f_xmxz, t.f_xzqdm
        UNION ALL
         SELECT count(t.f_id) AS "总数",
            count(t.f_id) FILTER (WHERE t.f_processstate::text = 'p51'::text) AS "已完成备案数",
            "substring"(t.f_xzqdm::text, 1, 4) || '00'::text AS xzqhdm,
            t.f_xmxz_code,
            t.f_xmxz
           FROM tb_zbph_zgck_xmxx t where t.f_cklx='01'
          GROUP BY t.f_xmxz_code, t.f_xmxz, ("substring"(t.f_xzqdm::text, 1, 4) || '00'::text)
        UNION ALL
         SELECT count(t.f_id) AS "总数",
            count(t.f_id) FILTER (WHERE t.f_processstate::text = 'p51'::text) AS "已完成备案数",
            "substring"(t.f_xzqdm::text, 1, 2) || '0000'::text AS xzqhdm,
            t.f_xmxz_code,
            t.f_xmxz
           FROM tb_zbph_zgck_xmxx t where t.f_cklx='01'
          GROUP BY t.f_xmxz_code, t.f_xmxz, ("substring"(t.f_xzqdm::text, 1, 2) || '0000'::text)) a
  GROUP BY a.xzqhdm, a.f_xmxz_code, a.f_xmxz
WITH DATA;

