-- public.tb_zbph_zbtj_zbhj definition

-- Drop table

DROP TABLE if exists public.tb_zbph_zbtj_zbhj;
--新增指标核减信息表以及核减明细表
CREATE TABLE public.tb_zbph_zbtj_zbhj (
	f_id varchar(64) NOT NULL, -- 主键
	f_zbxzqmc varchar(100) NOT NULL, -- 指标所在行政区名称
	f_zbxzqdm varchar(12) NOT NULL, -- 指标所在行政区代码
	f_hjlx varchar(12) NOT NULL, -- 核减类别  字典
	f_cklx varchar NULL, -- 出库类型
	f_zbgm float8 NOT NULL DEFAULT 0, -- 本次核减指标规模
	f_stgm float8 NOT NULL DEFAULT 0, -- 本次核减水田规模
	f_lscn float8 NOT NULL DEFAULT 0, -- 本次核减粮食产能
	f_bz text NULL, -- 备注
	f_userid varchar(64) NULL, -- 填报人id
	f_username varchar(64) NULL, -- 填报人姓名
	f_create_time timestamp NULL, -- 填报时间
	f_processid varchar NULL, -- 流程id
	f_processstatestr varchar NULL, -- 流程状态描述
	f_processstate varchar NULL, -- 流程状态
	f_processgroup varchar NULL, -- 流程分组
	f_usertel varchar NULL, -- 填报人手机号
	f_xmmc varchar NULL, -- 项目名称
	f_xmbh varchar NULL, -- 流水号
	f_xzqdm varchar NULL, -- 操作行政区代码
	f_xzqmc varchar NULL, -- 操作行政区名称
	f_finish_time timestamp NULL, -- 审核时间
	f_update_time timestamp NULL, -- 更新时间
	CONSTRAINT tb_zbph_zbtj_zbhj_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_zbtj_zbhj_f_zbxzqdm_idx ON public.tb_zbph_zbtj_zbhj USING btree (f_zbxzqdm);
COMMENT ON TABLE public.tb_zbph_zbtj_zbhj IS '指标调剂指标冻结基本信息表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_zbxzqmc IS '指标所在行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_zbxzqdm IS '指标所在行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_hjlx IS '核减类别  字典';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_zbgm IS '本次核减指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_stgm IS '本次核减水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_userid IS '填报人id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_username IS '填报人姓名';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_create_time IS '填报时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_processid IS '流程id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_processstatestr IS '流程状态描述';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_processstate IS '流程状态';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_usertel IS '填报人手机号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_xmbh IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_xzqdm IS '操作行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_xzqmc IS '操作行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_finish_time IS '审核时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_update_time IS '更新时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_lscn IS '本次核减粮食产能';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_processgroup IS '流程分组';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhj.f_cklx IS '出库类型';


-- public.tb_zbph_zbtj_zbhjmx definition

-- Drop table

 DROP TABLE if exists public.tb_zbph_zbtj_zbhjmx;
CREATE TABLE public.tb_zbph_zbtj_zbhjmx (
	f_id varchar(64) NOT NULL, -- 主键
	f_bsm varchar(64) NULL, -- 图斑编号
	f_tbbh varchar(100) NULL, -- 图斑标识码
	f_hjzbgm float8 NULL DEFAULT 0, -- 核减指标规模
	f_hjstgm float8 NULL DEFAULT 0, -- 核减水田规模
	f_rkzbgm float8 NULL, -- 入库指标规模
	f_rkstgm float8 NULL, -- 入库水田规模
	f_xzqdm varchar(12) NULL, -- 行政区代码
	f_xzqmc varchar(64) NULL, -- 行政区名称
	f_sid varchar(64) NULL, -- 流水号
	f_update_time timestamp NULL, -- 审核时间
	f_create_time timestamp NULL, -- 填报时间
	f_xmid varchar(64) NULL, -- 核减f_id
	f_zbid varchar(64) NULL, -- 入库指标id
	f_rklscn float8 NULL DEFAULT 0, -- 入库粮食产能
	f_hjlscn float8 NULL DEFAULT 0 -- 核减粮食产能
);
CREATE INDEX tb_zbph_zbtj_zbhjmx_f_bsm_idx ON public.tb_zbph_zbtj_zbhjmx USING btree (f_bsm, f_tbbh);
COMMENT ON TABLE public.tb_zbph_zbtj_zbhjmx IS '指标核减明细';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_bsm IS '图斑编号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_tbbh IS '图斑标识码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_hjzbgm IS '核减指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_hjstgm IS '核减水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_rkzbgm IS '入库指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_rkstgm IS '入库水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_sid IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_update_time IS '审核时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_create_time IS '填报时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_xmid IS '核减f_id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_zbid IS '入库指标id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_rklscn IS '入库粮食产能';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjmx.f_hjlscn IS '核减粮食产能';

--新增指标核减库表字段
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000010', 'tb_zbph_zbtj_zbhj', 'f_stgm', '本次核减水田规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 10, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000012', 'tb_zbph_zbtj_zbhj', 'f_bz', '备注', 0, 'varchar', 10000, NULL, 0, NULL, NULL, NULL, 12, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000013', 'tb_zbph_zbtj_zbhj', 'f_userid', '用户id', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 13, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000014', 'tb_zbph_zbtj_zbhj', 'f_username', '用户名', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 14, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000015', 'tb_zbph_zbtj_zbhj', 'f_update_time', '操作时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 15, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000016', 'tb_zbph_zbtj_zbhj', 'f_processid', '流程id', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000017', 'tb_zbph_zbtj_zbhj', 'f_processstatestr', '流程状态描述', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000018', 'tb_zbph_zbtj_zbhj', 'f_processstate', '流转状态码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000022', 'tb_zbph_zbtj_zbhj', 'f_xzqdm', '行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000023', 'tb_zbph_zbtj_zbhj', 'f_xzqmc', '行政区名称', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 23, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000024', 'tb_zbph_zbtj_zbhj', 'f_create_time', '创建时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 24, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000025', 'tb_zbph_zbtj_zbhj', 'f_finish_time', '完成时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 25, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000026', 'tb_zbph_zbtj_zbhj', 'f_xmbh', '流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 26, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000027', 'tb_zbph_zbtj_zbhj', 'f_xmmc', '项目名称', 0, 'varchar', 255, NULL, 0, NULL, NULL, NULL, 27, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000028', 'tb_zbph_zbtj_zbhj', 'f_usertel', '电话', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 28, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000019', 'tb_zbph_zbtj_zbhj', 'f_processgroup', '流转分组', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('5300000020', 'tb_zbph_zbtj_zbhj', 'f_cklx', '出库类型', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000005', 'tb_zbph_zbtj_zbhj', 'f_hjlx', '核减类型', 0, 'varchar', 12, NULL, 0, NULL, 'zbhjDictType', NULL, 5, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000001', 'tb_zbph_zbtj_zbhj', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, '', NULL, NULL, 1, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000002', 'tb_zbph_zbtj_zbhj', 'f_zbxzqmc', '指标所在行政区名称', 0, 'varchar', 100, NULL, 0, NULL, NULL, NULL, 2, '8', NULL, 1, NULL, 'xzqmc', NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000003', 'tb_zbph_zbtj_zbhj', 'f_zbxzqdm', '指标所在行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 3, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000008', 'tb_zbph_zbtj_zbhj', 'f_lscn', '本次核减粮食产能', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 7, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('530000009', 'tb_zbph_zbtj_zbhj', 'f_zbgm', '本次核减指标规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 9, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);


--指标核减列表展示字段
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('530000002', 'project-list', '530000002', 1, 'tb_zbph_zbtj_zbhj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('530000005', 'project-list', '530000005', 2, 'tb_zbph_zbtj_zbhj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('530000009', 'project-list', '530000009', 3, 'tb_zbph_zbtj_zbhj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('5300000010', 'project-list', '5300000010', 4, 'tb_zbph_zbtj_zbhj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('5300000017', 'project-list', '5300000017', 5, 'tb_zbph_zbtj_zbhj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('5300000015', 'project-list', '5300000015', 6, 'tb_zbph_zbtj_zbhj', 1);

--修改入库图斑剩余统计视图v_zbph_tbrk_sytj
drop view if exists v_zbph_tbrk_sytj;
CREATE OR REPLACE VIEW public.v_zbph_tbrk_sytj
as SELECT tzzr.f_id AS id,
    tzzr.f_dkid AS dkid,
    tzzr.f_zblx AS zblx,
    tzzr.f_zbxzqdm AS zbxzqdm,
    tzzr.f_zbxzqmc AS zbxzqmc,
    tzzr.f_dkbh AS dkbh,
    tztz.bsm as bsm,
    tztz.dlbm,
    tztz.dlmc,
    tztz.gdpdjb,
    tztz.gddj,
    tztz.tbdlmj,
    tztz.importtime AS date,
    tztz.shape,
    tzzs.f_gdmj_yy AS yygdmj,
    tzzs.f_gdmj_sy AS sygdmj,
	tzzs.f_stmj_yy AS yystmj,
    tzzs.f_stmj_sy AS systmj,
        CASE
            WHEN tzzs.f_gdmj = tzzs.f_gdmj_yy THEN '全部挂钩'::text
            WHEN tzzs.f_gdmj_yy = 0::numeric THEN '未挂钩'::text
            WHEN tzzs.f_gdmj_yy < tzzs.f_gdmj THEN '部分挂钩'::text
            ELSE NULL::text
        END AS sytj
   FROM tb_zbph_zbk_rkmx tzzr
     LEFT JOIN tb_zbph_zbk_sytj tzzs ON tzzr.f_id::text = tzzs.f_zbid::text
     JOIN tb_zbph_tbrk_zbmx tztz ON tzzr.f_dkid::text = tztz.id::text;

--指标核减图斑列表新增展示字段
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('79860001042', 'v_zbph_tbrk_sytj', 'yygdmj', '已用耕地面积', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('79860001043', 'v_zbph_tbrk_sytj', 'sygdmj', '剩余耕地面积', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('79860001044', 'v_zbph_tbrk_sytj', 'yystmj', '已用水田面积', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('79860001045', 'v_zbph_tbrk_sytj', 'systmj', '剩余水田面积', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('79860001046', 'v_zbph_tbrk_sytj', 'bsm', '标识码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
--指标核减图斑列表新增展示字段
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010282', 'project-select', '79860001028', 1, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010302', 'project-select', '79860001030', 2, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010342', 'project-select', '79860001034', 3, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010352', 'project-select', '79860001035', 4, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010362', 'project-select', '79860001036', 5, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010372', 'project-select', '79860001037', 6, 'v_zbph_tbrk_sytj', 1);
INSERT INTO public.tb_model_group
(f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible)
VALUES('798600010432', 'project-select', '79860001043', 7, 'v_zbph_tbrk_sytj', 1);


--新增指标核减范围信息
-- public.tb_zbph_zbtj_zbhjtbfw definition
-- Drop table

DROP TABLE if exists  public.tb_zbph_zbtj_zbhjtbfw;
CREATE TABLE public.tb_zbph_zbtj_zbhjtbfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_xmid varchar(64) NULL, -- 指标核减id
	f_shape public.geometry(geometry, 4490) NULL, -- 问题图斑范围
	f_taskid varchar(64) NULL,
	CONSTRAINT tb_zbph_zbtj_zbhjtbfw_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbtj_zbhjtbfw IS '指标核减问题图斑范围';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjtbfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjtbfw.f_xmid IS '指标核减id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjtbfw.f_shape IS '问题图斑范围';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhjtbfw.f_taskid IS '分析任务id';



