-- 部级接口请求记录日志
create table tb_zbph_sync_bjjkqqjl
(
    f_id              varchar primary key not null,               -- 主键
    f_task_name       varchar             not null,               -- 任务名称
    f_interface_name  varchar             not null,               -- 接口名称
    f_interface_type  varchar             not null,               -- 接口类型 （上行接口、下行接口）
    f_status          varchar             not null,               -- 状态（0：交换成功、1：交换失败）
    f_request_time    timestamp           not null default now(), -- 请求时间
    f_request_param   varchar             not null,               -- 请求参数
    f_response_result varchar             not null                -- 响应结果
);
comment on table tb_zbph_sync_bjjkqqjl is '部级接口请求记录日志';
comment on column tb_zbph_sync_bjjkqqjl.f_id is '主键';
comment on column tb_zbph_sync_bjjkqqjl.f_task_name is '任务名称';
comment on column tb_zbph_sync_bjjkqqjl.f_interface_name is '接口名称';
comment on column tb_zbph_sync_bjjkqqjl.f_interface_type is '接口类型（上行接口、下行接口）';
comment on column tb_zbph_sync_bjjkqqjl.f_status is '状态（0：交换成功、1：交换失败）';
comment on column tb_zbph_sync_bjjkqqjl.f_request_time is '请求时间';
comment on column tb_zbph_sync_bjjkqqjl.f_request_param is '请求参数';
comment on column tb_zbph_sync_bjjkqqjl.f_response_result is '响应结果';

-- 操作明细部级相关字段注释
comment on column tb_zbph_zbk_czmx.f_gllsh is '关联流水号';
comment on column tb_zbph_zbk_czmx.f_sync_flag is '同步状态(0:未同步  1:同步中  2:已同步)';
comment on column tb_zbph_zbk_czmx.f_sync_time is '同步完成时间';


-- 部级指标操作明细同步数据表相关注释
comment on table tb_zbph_sync_bjzbczmx is '部级指标操作明细同步数据表';
comment on column tb_zbph_sync_bjzbczmx.f_id is '主键';
comment on column tb_zbph_sync_bjzbczmx.f_lsh is '部级流水号';
comment on column tb_zbph_sync_bjzbczmx.f_cbzbxzqdm is '储备指标行政区代码';
comment on column tb_zbph_sync_bjzbczmx.f_cbzbxzqmc is '储备指标行政区名称';
comment on column tb_zbph_sync_bjzbczmx.f_czxzqdm is '操作行政区代码';
comment on column tb_zbph_sync_bjzbczmx.f_czxzqmc is '操作行政区名称';
comment on column tb_zbph_sync_bjzbczmx.f_czlx is '操作类型';
comment on column tb_zbph_sync_bjzbczmx.f_zblx is '指标类型';
comment on column tb_zbph_sync_bjzbczmx.f_zbgm is '指标规模';
comment on column tb_zbph_sync_bjzbczmx.f_stgm is '水田规模';
comment on column tb_zbph_sync_bjzbczmx.f_czr is '操作人';
comment on column tb_zbph_sync_bjzbczmx.f_zy is '摘要';
comment on column tb_zbph_sync_bjzbczmx.f_czrq is '操作日期';
comment on column tb_zbph_sync_bjzbczmx.f_czlxzw is '操作类型名称';
comment on column tb_zbph_sync_bjzbczmx.f_zblxzw is '指标类型名称';
comment on column tb_zbph_sync_bjzbczmx.f_gllsh is '关联流水号';
comment on column tb_zbph_sync_bjzbczmx.f_czzt is '操作状态（0：未处理 1：处理中 2：已处理）';
comment on column tb_zbph_sync_bjzbczmx.f_sync_time is '同步时间';

-- 指标上限日志记录表
comment on table tb_zbph_sync_zbsx is '指标上限日志记录表';
comment on column tb_zbph_sync_zbsx.f_id is '主键';
comment on column tb_zbph_sync_zbsx.f_xzqdm is '行政区划代码';
comment on column tb_zbph_sync_zbsx.f_xzqmc is '行政区划名称';
comment on column tb_zbph_sync_zbsx.f_zbbbrksx is '指标报备入库上限';
comment on column tb_zbph_sync_zbsx.f_gxsj is '更新时间';
comment on column tb_zbph_sync_zbsx.f_bz is '备注';
comment on column tb_zbph_sync_zbsx.f_zbnd is '指标年度';
comment on column tb_zbph_sync_zbsx.f_sync_time is '同步时间';

-- 指标库基础表相关注释
comment on column tb_zbph_zbk_base.f_xrkbcgdzb is '入库补充耕地指标';

-- 基础指标库日志记录表
comment on table tb_zbph_sync_jczbk is '基础指标库日志记录表';
comment on column tb_zbph_sync_jczbk.f_id is '主键';
comment on column tb_zbph_sync_jczbk.f_xzqmc is '行政区划名称';
comment on column tb_zbph_sync_jczbk.f_xzqdm is '行政区划代码';
comment on column tb_zbph_sync_jczbk.f_ycbkslzb is '原储备库数量指标';
comment on column tb_zbph_sync_jczbk.f_ycbkstzb is '原储备库水田指标';
comment on column tb_zbph_sync_jczbk.f_ygjtcslzb is '原国家统筹数量指标';
comment on column tb_zbph_sync_jczbk.f_ygjtcstzb is '原国家统筹水田指标';
comment on column tb_zbph_sync_jczbk.f_xrkbcgdzb is '新入库补充耕地指标';
comment on column tb_zbph_sync_jczbk.f_cnslzb is '承诺数量指标';
comment on column tb_zbph_sync_jczbk.f_cnstzb is '承诺水田指标';
comment on column tb_zbph_sync_jczbk.f_gxsj is '更新时间';
comment on column tb_zbph_sync_jczbk.f_sjjhsj is '数据交换时间';
comment on column tb_zbph_sync_jczbk.f_bz is '备注';
comment on column tb_zbph_sync_jczbk.f_zbbbrksx is '指标报备入库上限';
comment on column tb_zbph_sync_jczbk.f_zbnd is '指标年度';

-- 前地类信息日志记录表
comment on table tb_zbph_sync_qdlxx is '前地类信息日志记录表';
comment on column tb_zbph_sync_qdlxx.f_id is '主键';
comment on column tb_zbph_sync_qdlxx.f_lsh is '流水号';
comment on column tb_zbph_sync_qdlxx.f_zbxzqdm is '指标行政区划代码';
comment on column tb_zbph_sync_qdlxx.f_czxzqdm is '操作行政区划代码';
comment on column tb_zbph_sync_qdlxx.f_czlx is '操作类型';
comment on column tb_zbph_sync_qdlxx.f_qdlmc is '前地类名称';
comment on column tb_zbph_sync_qdlxx.f_qdldm is '前地类代码';
comment on column tb_zbph_sync_qdlxx.f_rkzbgm is '入库指标规模';
comment on column tb_zbph_sync_qdlxx.f_rkzblx is '入库指标类型';
comment on column tb_zbph_sync_qdlxx.f_sjjhsj is '数据交换时间';
