--指标空间使用统计表
CREATE TABLE public.tb_zbph_zbk_sytj_dk (
	f_id varchar(64) NOT NULL DEFAULT 0, -- 主键
	f_zbid varchar(64) NOT NULL DEFAULT 0, -- 指标id
	f_gdmj public.geometry NULL, -- 入库耕地面积
	f_gdmj_yy public.geometry NULL, -- 耕地面积已用
	f_gdmj_sy public.geometry NULL, -- 耕地面积剩余
	f_gdmj_sd public.geometry NULL, -- 耕地面积锁定
	f_stmj public.geometry NULL, -- 入库水田面积
	f_stmj_yy public.geometry NULL, -- 水田面积已用
	f_stmj_sy public.geometry NULL, -- 水田面积剩余
	f_stmj_sd public.geometry NULL, -- 水田面积锁定
	f_cnzb public.geometry NULL, -- 入库产能指标
	f_cnzb_yy public.geometry NULL, -- 产能指标已用
	f_cnzb_sy public.geometry NULL, -- 产能指标剩余
	f_cnzb_sd public.geometry NULL -- 产能指标锁定
);
CREATE INDEX tb_zbph_zbk_sytj_f_zbid_idx_2 ON public.tb_zbph_zbk_sytj_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_sytj_dk IS '指标空间使用统计表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_zbid IS '指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gdmj IS '入库耕地面积';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gdmj_yy IS '耕地面积已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gdmj_sy IS '耕地面积剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_gdmj_sd IS '耕地面积锁定';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_stmj IS '入库水田面积';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_stmj_yy IS '水田面积已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_stmj_sy IS '水田面积剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_stmj_sd IS '水田面积锁定';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb IS '入库产能指标';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_yy IS '产能指标已用';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_sy IS '产能指标剩余';
COMMENT ON COLUMN public.tb_zbph_zbk_sytj_dk.f_cnzb_sd IS '产能指标锁定';

--指标空间出库过程明细表
CREATE TABLE public.tb_zbph_zbk_ckgcmx_dk (
	f_id varchar(64) NOT NULL,
	f_zbxzqdm varchar(12) NOT NULL, -- 指标所在行政区代码
	f_zbxzqmc varchar(100) NOT NULL, -- 指标所在行政区名称
	f_czxzqdm varchar(12) NOT NULL, -- 操作行政区代码
	f_czxzqmc varchar(100) NOT NULL, -- 操作行政区名称
	f_czlx varchar(64) NOT NULL, -- 操作类型
	f_gdmj public.geometry NULL, -- 耕地面积
	f_stmj public.geometry NULL, -- 水田面积
	f_cnzb public.geometry NULL, -- 产能指标
	f_xmbh varchar(64) NOT NULL, -- 出库项目编号
	f_xmmc varchar(100) NOT NULL, -- 出库项目名称
	f_date timestamp(6) NOT NULL, -- 指标时间
	f_userid varchar(64) NOT NULL, -- 操作用户id
	f_username varchar(64) NOT NULL, -- 操作用户名称
	f_zy text NULL, -- 摘要
	f_zbid varchar(64) NOT NULL, -- 指标id
	f_zblx varchar(64) NOT NULL, -- 指标类型
	f_zbxmbh varchar(64) NOT NULL, -- 指标项目编号
	f_zbxmmc varchar(64) NOT NULL, -- 指标项目名称
	f_zbdkbh varchar(64) NOT NULL, -- 指标地块编号
	f_dkxzqmc varchar(100) NOT NULL, -- 地块行政区名称
	f_dkxzqdm varchar(12) NOT NULL, -- 地块行政区代码
	f_zbgddb numeric(20, 4) NOT NULL DEFAULT 0, -- 指标耕地等别
	f_zbdkmc varchar(64) NOT NULL, -- 指标地块名称
	f_sid varchar(64) NOT NULL, -- 流水号
	f_ckxzqdm varchar(12) NULL, -- 出库行政区划代码
	f_ckxzqmc varchar(64) NULL, -- 出库行政区名称
	f_operdate timestamp(6) NULL DEFAULT NULL::timestamp without time zone, -- 入库操作时间
	f_ckgcmx_id varchar NULL, -- 关联出库过程明细id
	CONSTRAINT tb_zbph_zbk_ckgcmx_dk_pkey_1 PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zbk_ckgcmx_dk_un_zbid_sid_1 UNIQUE (f_zbid, f_sid)
);
CREATE INDEX tb_zbph_zbk_ckgcmx_dk_f_sid_idx_1 ON public.tb_zbph_zbk_ckgcmx_dk USING btree (f_sid);
CREATE INDEX tb_zbph_zbk_ckgcmx_dk_f_zbid_idx_1 ON public.tb_zbph_zbk_ckgcmx_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_ckgcmx_dk IS '指标空间出库过程明细表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbxzqdm IS '指标所在行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbxzqmc IS '指标所在行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_czxzqdm IS '操作行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_czxzqmc IS '操作行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_czlx IS '操作类型';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_gdmj IS '耕地面积';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_stmj IS '水田面积';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_cnzb IS '产能指标';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_xmbh IS '出库项目编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_xmmc IS '出库项目名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_date IS '指标时间';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_userid IS '操作用户id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_username IS '操作用户名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zy IS '摘要';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbid IS '指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zblx IS '指标类型';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbxmbh IS '指标项目编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbxmmc IS '指标项目名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbdkbh IS '指标地块编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_dkxzqmc IS '地块行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_dkxzqdm IS '地块行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbgddb IS '指标耕地等别';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_zbdkmc IS '指标地块名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_sid IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_ckxzqdm IS '出库行政区划代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_ckxzqmc IS '出库行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_operdate IS '入库操作时间';
COMMENT ON COLUMN public.tb_zbph_zbk_ckgcmx_dk.f_ckgcmx_id IS '关联出库过程明细id';

-- 指标库出库明细表-地块
CREATE TABLE public.tb_zbph_zbk_ckmx_dk (
	f_id varchar(64) NOT NULL, -- 主键
	f_zbxzqdm varchar(12) NOT NULL, -- 指标行政区代码
	f_zbxzqmc varchar(100) NOT NULL, -- 指标行政区名称
	f_czxzqdm varchar(12) NOT NULL, -- 操作行政区代码
	f_czxzqmc varchar(100) NOT NULL, -- 操作行政区名称
	f_czlx varchar(64) NOT NULL, -- 操作类型
	f_gdmj public.geometry NULL, -- 耕地面积
	f_stmj public.geometry NULL, -- 水田面积
	f_cnzb public.geometry NULL, -- 产能指标
	f_xmbh varchar(64) NOT NULL, -- 项目编号
	f_xmmc varchar(100) NOT NULL, -- 项目名称
	f_date timestamp(6) NOT NULL, -- 指标时间
	f_userid varchar(64) NOT NULL, -- 用户id
	f_username varchar(64) NOT NULL, -- 用户名称
	f_zy text NULL, -- 摘要
	f_zbid varchar(64) NOT NULL, -- 出库指标id
	f_zblx varchar(64) NOT NULL, -- 指标类型
	f_zbxmbh varchar(64) NOT NULL, -- 指标项目编号
	f_zbxmmc varchar(64) NOT NULL, -- 指标项目名称
	f_zbdkbh varchar(64) NOT NULL, -- 指标地块编号
	f_dkxzqmc varchar(100) NOT NULL, -- 地块行政区名称
	f_dkxzqdm varchar(12) NOT NULL, -- 地块行政区划代码
	f_zbgddb numeric(20, 4) NOT NULL DEFAULT 0, -- 指标耕地等别
	f_zbdkmc varchar(64) NOT NULL, -- 指标地块名称
	f_sid varchar(64) NOT NULL,
	f_ckxzqdm varchar(12) NULL, -- 出库行政区划代码
	f_ckxzqmc varchar(64) NULL, -- 出库行政区名称
	f_operdate timestamp(6) NULL DEFAULT NULL::timestamp without time zone, -- 入库操作时间
	f_ckmx_id varchar NULL, -- 关联出库明细id
	CONSTRAINT tb_zbph_zbk_ckmx_dk_pkey_1 PRIMARY KEY (f_id),
	CONSTRAINT tb_zbph_zbk_ckmx_dk_un_zbid_sid_1 UNIQUE (f_zbid, f_sid)
);
CREATE INDEX tb_zbph_zbk_ckmx_dk_f_sid_idx_1 ON public.tb_zbph_zbk_ckmx_dk USING btree (f_sid);
CREATE INDEX tb_zbph_zbk_ckmx_dk_f_zbid_idx_1 ON public.tb_zbph_zbk_ckmx_dk USING btree (f_zbid);
COMMENT ON TABLE public.tb_zbph_zbk_ckmx_dk IS '指标库出库明细表-地块';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbxzqdm IS '指标行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbxzqmc IS '指标行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_czxzqdm IS '操作行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_czxzqmc IS '操作行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_czlx IS '操作类型';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_gdmj IS '耕地面积';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_stmj IS '水田面积';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_cnzb IS '产能指标';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_date IS '指标时间';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_userid IS '用户id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_username IS '用户名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zy IS '摘要';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbid IS '出库指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zblx IS '指标类型';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbxmbh IS '指标项目编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbxmmc IS '指标项目名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbdkbh IS '指标地块编号';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_dkxzqmc IS '地块行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_dkxzqdm IS '地块行政区划代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbgddb IS '指标耕地等别';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_zbdkmc IS '指标地块名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_ckxzqdm IS '出库行政区划代码';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_ckxzqmc IS '出库行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_operdate IS '入库操作时间';
COMMENT ON COLUMN public.tb_zbph_zbk_ckmx_dk.f_ckmx_id IS '关联出库明细id';