/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.biz.aop.OpLog;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.dto.MyLoginResponse;
import com.geoway.onemap.core.service.system.AuthorityService;
import com.geoway.onemap.core.service.system.LoginService;
import com.geoway.onemap.core.service.system.LoginServiceUISImpl;
import com.geoway.onemap.core.service.system.MyTokenService;
import com.geoway.onemap.core.service.system.SysUserService;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/login"})
public class LoginAction {
    private Logger logger = Logger.getLogger(LoginAction.class);
    @Autowired
    LoginService loginService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    DefaultKaptcha defaultKaptcha;
    @Autowired
    MyTokenService tokenService;
    @Autowired
    LoginServiceUISImpl loginServiceUIS;
    @Autowired
    AuthorityService authorityService;

    @RequestMapping(value={"/captcha.jpeg"}, method={RequestMethod.GET}, produces={"image/jpeg"})
    @ResponseBody
    public byte[] captcha(HttpServletRequest request, HttpServletResponse response) {
        try {
            ServletOutputStream output = response.getOutputStream();
            String capText = this.defaultKaptcha.createText();
            HttpSession session = request.getSession();
            session.setAttribute("SIMPLE_CAPCHA_SESSION_KEY", (Object)capText);
            System.out.println("\u9a8c\u8bc1\u7801: " + capText);
            BufferedImage bi = this.defaultKaptcha.createImage(capText);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String uuid = UUID.randomUUID().toString();
            session.setAttribute("SIMPLE_CAPCHA_CACHE_KEY", (Object)uuid);
            this.loginService.storeCaptcha(uuid, capText);
            ImageIO.write((RenderedImage)bi, "png", out);
            return out.toByteArray();
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/captchaText.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse captchaText(HttpServletRequest request) {
        BaseResponse response = new BaseResponse();
        String capText = this.defaultKaptcha.createText();
        HttpSession session = request.getSession();
        System.out.println(session.getId());
        String uuid = UUID.randomUUID().toString();
        session.setAttribute("SIMPLE_CAPCHA_CACHE_KEY", (Object)uuid);
        this.loginService.storeCaptcha(uuid, capText);
        session.setAttribute("SIMPLE_CAPCHA_SESSION_KEY", (Object)capText);
        response.setMessage(capText);
        return response;
    }

    @RequestMapping(value={"/validate.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u767b\u5f55\u7cfb\u7edf", detail="\u767b\u5f55\u7cfb\u7edf", opType=OpLog.OpType.login, systemId=OpLog.SystemType.menhu)
    public MyLoginResponse addOne(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="code") String code) {
        MyLoginResponse response = null;
        try {
            Object captchaObj = request.getSession().getAttribute("SIMPLE_CAPCHA_SESSION_KEY");
            Object storeIdObj = request.getSession().getAttribute("SIMPLE_CAPCHA_CACHE_KEY");
            String storeId = storeIdObj != null ? storeIdObj.toString() : "";
            String captcha = this.loginService.queryCaptcha(storeId);
            response = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.checkLogin(username, password, captcha, code) : this.loginService.checkLogin(username, password, captcha, code);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/freshToken.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u5237\u65b0\u4ee4\u724c", detail="\u5237\u65b0\u4ee4\u724c", opType=OpLog.OpType.login, systemId=OpLog.SystemType.menhu)
    public MyLoginResponse freshToken(HttpServletRequest request, @RequestParam(value="username") String username) {
        MyLoginResponse response = null;
        try {
            response = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.freshToken(username) : this.loginService.freshToken(username);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/CAValidate.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u767b\u5f55\u7cfb\u7edf", detail="CA\u8bc1\u4e66\u767b\u5f55\u95e8\u6237\u7cfb\u7edf", opType=OpLog.OpType.login, systemId=OpLog.SystemType.menhu)
    public MyLoginResponse CAAddOne(HttpServletRequest request, @RequestParam(value="sn") String sn) {
        MyLoginResponse response = null;
        try {
            response = this.loginServiceUIS.checkLoginByCA(sn);
            request.getSession().setAttribute("access_token", (Object)response.getToken());
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/logout.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u9000\u51fa\u767b\u5f55", detail="\u9000\u51fa\u767b\u5f55", opType=OpLog.OpType.loginout, systemId=OpLog.SystemType.menhu)
    public BaseResponse logout(HttpServletRequest request, @RequestParam(value="token") String token) {
        BaseResponse response = new BaseResponse();
        try {
            request.getSession().invalidate();
            if (this.loginServiceUIS.isUISEnable()) {
                this.loginServiceUIS.logOut(token);
            } else {
                this.loginService.logOut(token);
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/userDetail.action"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse userDetail(HttpServletRequest request, @RequestParam(value="token") String token) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUser user = null;
            if (this.loginServiceUIS.isUISEnable()) {
                user = this.loginServiceUIS.querySysUserByToken(token);
                response.setMessage("uisTrue");
            } else {
                user = this.tokenService.querySysUserByToken(token);
                response.setMessage("uisFalse");
            }
            response.setData((Object)user);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/changePwd.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse changePwd(HttpServletRequest request, @RequestParam(value="token", required=false) String token, @RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            boolean uisEnable = this.loginServiceUIS.isUISEnable();
            if (token == null || token.length() <= 0) {
                token = request.getHeader("access_token");
            }
            SysUser user = new SysUser();
            user = uisEnable ? this.loginServiceUIS.querySysUserByToken(token) : this.tokenService.querySysUserByToken(token);
            if (user == null || ObjectUtils.isEmpty((Object)user)) {
                throw new IllegalAccessException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (!user.getPassword().equals(oldPwd)) {
                this.logger.error((Object)(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ":\u65e7\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25"));
                throw new IllegalAccessException("\u65e7\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25");
            }
            if (uisEnable) {
                JSONObject result = this.loginServiceUIS.changeUserPwd(token, user.getUsername(), user.getId(), newPwd);
                response.setMessage("uisTrue");
                response.setData((Object)result);
            } else {
                this.authorityService.ModifyUserPasswd(user.getId(), newPwd);
                response.setData((Object)"1");
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/userDetailInfo.action"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse userDetailInfo(HttpServletRequest request, @RequestParam(value="token") String token) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            JSONObject userJson = null;
            SysUser user = null;
            if (this.loginServiceUIS.isUISEnable()) {
                userJson = this.loginServiceUIS.querySysUserInfoByToken(token);
                response.setMessage("uisTrue");
                response.setData((Object)userJson);
            } else {
                user = this.tokenService.querySysUserByToken(token);
                response.setMessage("uisFalse");
                response.setData((Object)user);
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/modifyPassword.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u4fee\u6539\u7528\u6237\u5bc6\u7801", opType=OpLog.OpType.update)
    public BaseResponse modifyPassword(String userName, String id, String passwd, String token) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (this.loginServiceUIS.isUISEnable()) {
                JSONObject result = this.loginServiceUIS.modifyUserPwd(token, userName, id, passwd);
                response.setMessage("uisTrue");
                response.setData((Object)result);
            } else {
                this.authorityService.ModifyUserPasswd(id, passwd);
                response.setData((Object)"1");
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }
}

