/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.domain.Region;
import com.geoway.onemap.core.dto.RegionOriginResponse;
import com.geoway.onemap.core.dto.RegionResponse;
import com.geoway.onemap.core.service.RegionService;
import com.geoway.onemap.core.service.SysConfigService;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/region"})
public class RegionAction {
    private static Logger logger = Logger.getLogger(RegionAction.class);
    @Autowired
    RegionService regionService;
    @Autowired
    SysConfigService sysConfigService;

    @RequestMapping(value={"/listchildren.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RegionResponse getChildRegionsUsingJson(String pCode) {
        RegionResponse regionResp = new RegionResponse();
        try {
            if (StringUtils.isEmpty((Object)pCode)) {
                throw new IllegalArgumentException("\u53c2\u6570pCode\u4e0d\u5f97\u4e3a\u7a7a");
            }
            List results = this.regionService.queryRegionByPCode(pCode, null);
            regionResp.setTotalCount(results.size());
            regionResp.setResults(results);
        }
        catch (Exception ex) {
            regionResp.setStatus("FAILURE");
            regionResp.setMessage(ex.getMessage());
        }
        return regionResp;
    }

    @RequestMapping(value={"/listregions.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RegionResponse getRegionUsingJson(String pCode, Boolean isShowCountry) {
        RegionResponse regionResp = new RegionResponse();
        try {
            if (StringUtils.isEmpty((Object)pCode)) {
                pCode = "-1";
            }
            List results = new ArrayList();
            if (!isShowCountry.booleanValue()) {
                results = this.regionService.queryAllRegionsByPcode(pCode + "%", null);
            } else {
                pCode = "-1";
                results = this.regionService.queryRegionTreeLevel12(null);
            }
            regionResp.setTotalCount(results.size());
            regionResp.getResults().addAll(results);
        }
        catch (Exception ex) {
            regionResp.setStatus("FAILURE");
            regionResp.setMessage(ex.getMessage());
        }
        return regionResp;
    }

    @RequestMapping(value={"/listRegionTree.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RegionResponse listRegionTree(String pCode, Boolean isShowCountry) {
        RegionResponse regionResp = new RegionResponse();
        try {
            if (StringUtils.isEmpty((Object)pCode)) {
                pCode = "-1";
            }
            List results = new ArrayList();
            if (!isShowCountry.booleanValue()) {
                results = this.regionService.queryRegionTreeByPCode(pCode + "%", null);
            } else {
                pCode = "-1";
                results = this.regionService.queryRegionTreeLevel12(null);
            }
            regionResp.setTotalCount(results.size());
            regionResp.getResults().addAll(results);
        }
        catch (Exception ex) {
            regionResp.setStatus("FAILURE");
            regionResp.setMessage(ex.getMessage());
        }
        return regionResp;
    }

    @Cacheable(value={"regionlist"})
    @RequestMapping(value={"/listAllRegionTree.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RegionResponse listAllRegionTree(String pCode, Integer maxLevel, Integer catalogId) {
        RegionResponse regionResp = new RegionResponse();
        try {
            if (StringUtils.isEmpty((Object)pCode)) {
                pCode = "-1";
            }
            if (maxLevel == null) {
                maxLevel = 3;
            }
            List results = this.regionService.listAllRegionTree(pCode, maxLevel, null);
            regionResp.setTotalCount(results.size());
            regionResp.getResults().addAll(results);
        }
        catch (Exception ex) {
            regionResp.setStatus("FAILURE");
            regionResp.setMessage(ex.getMessage());
        }
        return regionResp;
    }

    @RequestMapping(value={"/querySsxTreeData.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse querySsxTreeData(String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List results = new ArrayList();
            if (!StringUtils.isEmpty((Object)code)) {
                results = this.regionService.querySsxTreeData(code, null);
            }
            response.setData(results);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/regionCotainPoint"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RegionOriginResponse getRegionContainGeom(double x, double y, int level) {
        RegionOriginResponse result = null;
        try {
            result = this.regionService.queryRegionByGeom(x, y, level);
            return result;
        }
        catch (Exception e) {
            result = new RegionOriginResponse();
            result.setStatus("FAILURE");
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @RequestMapping(value={"/queryRegionByHead.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryRegionByHead(HttpServletRequest request, String pCode, Boolean isShowCountry) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List results = new ArrayList();
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            levelList.add(2);
            if (isShowCountry.booleanValue()) {
                results = StringUtils.isEmpty((Object)pCode) ? this.regionService.queryAllData(null, levelList, null) : this.regionService.queryProviceBypCode(pCode + "%", null);
            }
            response.setData(results);
        }
        catch (Exception ex) {
            return BaseObjectResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/queryRegionByKeyWord.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryRegionByKeyWord(HttpServletRequest request, String pCode, String q, Boolean isShowCountry) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List results = new ArrayList();
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            levelList.add(2);
            if (!isShowCountry.booleanValue()) {
                results = StringUtils.isEmpty((Object)pCode) ? this.regionService.queryAllData(q + "%", levelList, null) : this.regionService.queryProviceBypKeyWord(pCode + "%", q + "%", null);
            }
            response.setData(results);
        }
        catch (Exception ex) {
            return BaseObjectResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/queryShape.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryShape(String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String result = null;
            if (!StringUtils.isEmpty((Object)code)) {
                Geometry geo = this.regionService.queryShapeByCode(code, null);
                result = geo.toString();
            }
            response.setData(result);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryTreeData.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryTree(String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List results = new ArrayList();
            if (!StringUtils.isEmpty((Object)code)) {
                results = this.regionService.queryTreeData(code, null);
            }
            response.setData(results);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryRegionByCode.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryRegionByCode(String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            Region results = new Region();
            if (!StringUtils.isEmpty((Object)code)) {
                results = this.regionService.queryRegionByCode(code, null);
            }
            response.setData((Object)results);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryShapeByProvince.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryShapeByProvince(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return BaseResponse.buildFailuaResponse((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.regionService.queryAllSimpleShapeByProvince(code);
            response.setData((Object)list);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/getRegionVersion.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getRegionVersion() {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String version = this.sysConfigService.findOne("region-version").getValue();
            response.setData((Object)version);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryByCode.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryByCode(String code, @RequestParam(value="catalogId", required=false) Integer catalogId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (!StringUtils.isEmpty((Object)code)) {
                Region region = new Region();
                region = catalogId != null ? this.regionService.queryRegionByCode(code, catalogId) : this.regionService.queryRegionByCode(code, null);
                response.setData((Object)region);
            }
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryByPcode.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryByPcode(String pcode, @RequestParam(value="catalogId", required=false) Integer catalogId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (!StringUtils.isEmpty((Object)pcode)) {
                List regions = this.regionService.queryRegionByPCode(pcode, catalogId);
                response.setData((Object)regions);
            }
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryByName.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryByName(String name) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (!StringUtils.isEmpty((Object)name)) {
                List list = this.regionService.queryByName(name, null);
                response.setData((Object)list);
            }
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/queryRegionChain.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryRegionChainByCode(String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.regionService.queryRegionChainByCode(code, null);
            response.setData((Object)list);
        }
        catch (Exception ex) {
            response.setStatus("FAILURE");
            response.setMessage(ex.getMessage());
        }
        return response;
    }
}

