/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.domain.SysConfig;
import com.geoway.onemap.core.domain.system.SysLogo;
import com.geoway.onemap.core.service.SysConfigService;
import com.geoway.onemap.core.service.system.SysLogoService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysconfig"})
public class SysConfigAction {
    private Logger logger = Logger.getLogger(SysConfigAction.class);
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SysLogoService sysLogoService;

    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findByKey(HttpServletRequest request, @RequestParam(value="key", required=true) String key) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysConfig config = this.sysConfigService.findOne(key);
            response.setData((Object)config);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @Cacheable(value={"sysparams"}, key="#filterParam")
    @RequestMapping(value={"/findByFilterParam"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findByFilterParam(HttpServletRequest request, @RequestParam(value="filterParam", required=true) String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.sysConfigService.queryByFilterParam(filterParam);
            response.setData((Object)list);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/findByType"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findByType(HttpServletRequest request, @RequestParam(value="type", required=true) Integer type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.sysConfigService.findAll(type);
            response.setData((Object)list);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/findLogo"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findLogo(HttpServletRequest request, @RequestParam(value="filterParam", required=true) String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysLogo logo = this.sysLogoService.findByFilterParam(filterParam);
            response.setData((Object)logo);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }
}

