/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.domain.ModelObjectinfo;
import com.geoway.base.metadata.service.ModelObjectinfoService;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.zbph.service.base.impl.EntityServiceUtil;
import com.geoway.web.anno.RequireAuth;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@PropertySource(value={"classpath:application-project.properties"})
@RestController
@RequestMapping(value={"/zbph/{serviceName}"})
public class BaseEntityController {
    private static final Logger log = LoggerFactory.getLogger(BaseEntityController.class);
    @Autowired
    private ModelObjectinfoService objectinfoService;

    @ApiOperation(value="1-\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/listPage.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryPage(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="groupCode", required=false, defaultValue="") String groupCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="rows", required=false, defaultValue="10") Integer rows, @PathVariable String serviceName) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            Page pages = service.findPageByFilter(filterParam, sortParam, groupCode, page.intValue(), rows.intValue());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
            response.setRows(pages.getContent());
        }
        catch (Exception e) {
            log.error("listPage.json", (Throwable)e);
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="2-\u67e5\u8be2total")
    @RequestMapping(value={"/listTotal.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryTotal(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="groupCode", required=false, defaultValue="") String groupCode, @PathVariable String serviceName) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            response.setData((Object)service.findByFilter(filterParam, sortParam, groupCode));
        }
        catch (Exception e) {
            log.error("listPage.json", (Throwable)e);
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="3-\u67e5\u8be2\u663e\u793a\u7684\u5b57\u6bb5\uff0c\u6307\u5b9agroupCode")
    @RequestMapping(value={"/findFields.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFields(@RequestParam(name="groupCode", required=false, defaultValue="project-list") String groupCode, @PathVariable String serviceName) {
        BaseObjectResponse response = new BaseObjectResponse();
        EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
        List list = service.findGroupFields(groupCode);
        response.setData((Object)list);
        return response;
    }

    @ApiOperation(value="4-\u4fdd\u5b58\u5b9e\u4f53")
    @RequireAuth
    @RequestMapping(value={"/saveOrUpdate.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse saveOrUpdate(HttpServletRequest request, @RequestBody HashMap entity, @PathVariable String serviceName) {
        try {
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            service.saveOrUpdate(entity, user);
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            log.error("saveOrUpdate.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="5-\u5220\u9664\u5b9e\u4f53")
    @RequireAuth
    @RequestMapping(value={"/delete.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delete(HttpServletRequest request, String id, @PathVariable String serviceName) {
        try {
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            service.deleteByid(id);
            return BaseObjectResponse.buildSuccessResponse((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("delete.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="6-\u5b9e\u4f53\u8be6\u60c5")
    @RequireAuth
    @RequestMapping(value={"/detail.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse detail(HttpServletRequest request, String id, @PathVariable String serviceName) {
        try {
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            HashMap result = service.findById(id);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)result);
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("detail.json", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @ApiOperation(value="7-\u5bfc\u51faexcel")
    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="fileName", required=false, defaultValue="\u53f0\u8d26") String fileName, @RequestParam(name="groupCode", required=false, defaultValue="project-list") String groupCode, @RequestParam(name="map", required=false, defaultValue="") String map, @RequestParam(name="template", required=false, defaultValue="") String tempalte, @PathVariable String serviceName) {
        Map fieldMap = null;
        if (StrUtil.isNotBlank((CharSequence)map)) {
            fieldMap = (Map)JSON.parseObject((String)map, Map.class);
        }
        EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
        service.exportExcel(response, fileName, filterParam, sortParam, groupCode, fieldMap, tempalte);
    }

    @ApiOperation(value="8-\u5bfc\u51fashp")
    @RequestMapping(value={"/exportShp.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void exportShp(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="fileName", required=false, defaultValue="\u53f0\u8d26") String fileName, @RequestParam(name="groupCode", required=false, defaultValue="") String groupCode, @RequestParam(name="map", required=false, defaultValue="") String map, @PathVariable String serviceName) {
        Map fieldMap = null;
        if (StrUtil.isNotBlank((CharSequence)map)) {
            fieldMap = (Map)JSON.parseObject((String)map, Map.class);
        }
        EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
        service.exportShp(response, fileName, filterParam, sortParam, groupCode, fieldMap);
    }

    @ApiOperation(value="9-\u67e5\u8be2\u6240\u6709")
    @RequestMapping(value={"/total.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse queryTotal(@RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @PathVariable String serviceName) {
        BaseObjectResponse response = new BaseObjectResponse();
        EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
        response.setData((Object)service.queryTotal(filterParam));
        return response;
    }

    @ApiOperation(value="10-\u4e0a\u4e00\u4e2a\u4e0b\u4e00\u4e2a\u67e5\u8be2")
    @RequireAuth
    @RequestMapping(value={"/findPreCurNextIds.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findPreCurNextIds(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="xmid") String xmid, @PathVariable String serviceName) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            EntityServiceUtil service = new EntityServiceUtil(this.getTableName(serviceName));
            baseObjectResponse.setData((Object)service.findPreCurNextIds(filterParam, sortParam, xmid));
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("findPreCurNextIds.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    private String getTableName(String serviceName) {
        ModelObjectinfo modelObjectinfo = this.objectinfoService.findByServiceName(serviceName);
        if (modelObjectinfo == null) {
            throw new RuntimeException("\u53c2\u6570\u6709\u8bef");
        }
        return modelObjectinfo.getTableName();
    }
}

