/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.zbph.domain.xfsgdtbrk.ZbkTbrkDetail;
import com.geoway.onemap.zbph.dto.xfstbrk.ZbkTbrkDTO;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkDetailService;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkManagerService;
import com.geoway.stxf.action.zbph.BaseProcessXmxxController;
import com.geoway.web.anno.RequireAuth;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/zbph/xfstbrk"})
public class XFSTbrkAction
extends BaseProcessXmxxController<ZbkTbrkDetail, ZbkTbrkDetailService, ZbkTbrkDTO, ZbkTbrkManagerService> {
    private static final Logger log = LoggerFactory.getLogger(XFSTbrkAction.class);

    public XFSTbrkAction(ZbkTbrkDetailService xmxxService, ZbkTbrkManagerService managerService) {
        super(xmxxService, managerService);
    }

    @RequireAuth
    @RequestMapping(value={"/input.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse input(HttpServletRequest request, @RequestParam(name="file") MultipartFile file, @RequestParam(name="processGroup", defaultValue="FLTBRK") String processGroup) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            return BaseObjectResponse.buildSuccessResponse((String)((ZbkTbrkManagerService)this.managerService).input(file, processGroup, user));
        }
        catch (Exception e) {
            log.error("/zbph/xfstbrk/inputTb.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/download.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadByTaskId(HttpServletResponse response, String taskId) {
        try {
            ((ZbkTbrkManagerService)this.managerService).downloadDataByTaskId(taskId, response);
        }
        catch (Exception e) {
            log.error("/zbph/xfstbrk/download.do", (Throwable)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/downloadLog.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadLogByTaskId(HttpServletResponse response, String taskId) {
        try {
            ((ZbkTbrkManagerService)this.managerService).downloadLogByTaskId(taskId, response);
        }
        catch (Exception e) {
            log.error("/zbph/xfstbrk/download.do", (Throwable)e);
        }
    }

    @RequestMapping(value={"/getStat.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse getStat(HttpServletRequest request, @RequestParam(name="processGroup", defaultValue="FLTBRK") String processGroup) {
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)((ZbkTbrkManagerService)this.managerService).getStat(user.getXzqdm(), processGroup));
            return baseObjectResponse;
        }
        catch (Exception ex) {
            log.error("/zbph/xfstbrk/getStat.json", (Throwable)ex);
            return BaseObjectResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @RequestMapping(value={"/getStatBatch.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse getStatBatch(HttpServletRequest request, String xzqdm, @RequestParam(name="processGroup", defaultValue="FLTBRK") String processGroup) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)((ZbkTbrkManagerService)this.managerService).getStat(Arrays.stream(xzqdm.split(",")).collect(Collectors.toList()), processGroup));
            return baseObjectResponse;
        }
        catch (Exception ex) {
            log.error("/zbph/xfstbrk/getStatBatch.json", (Throwable)ex);
            return BaseObjectResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/readExcel.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse readExcel(HttpServletRequest request, @RequestParam(name="file") MultipartFile file) {
        try {
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)((ZbkTbrkManagerService)this.managerService).readExcel(file));
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("/zbph/xfstbrk/readExcel.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }
}

