/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.util;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String objectToJson(Object data) {
        try {
            String string = MAPPER.writeValueAsString(data);
            return string;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject objectToJsonObject(Object data) {
        try {
            String str = JsonUtils.objectToJson(data);
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToPojo(String jsonData, Class<T> beanType) {
        try {
            Object t = MAPPER.readValue(jsonData, beanType);
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType) {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{beanType});
        try {
            List list = (List)MAPPER.readValue(jsonData, javaType);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> jsonToMap(JSONObject jsonObject) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            data.put((String)entry.getKey(), entry.getValue());
        }
        return data;
    }

    public static String combineJson(String srcJObjStr, String addJObjStr) {
        if (addJObjStr == null || addJObjStr.isEmpty()) {
            return srcJObjStr;
        }
        if (srcJObjStr == null || srcJObjStr.isEmpty()) {
            return addJObjStr;
        }
        JSONObject srcJObj = JSONObject.parseObject((String)srcJObjStr);
        JSONObject addJObj = JSONObject.parseObject((String)addJObjStr);
        Set itKeys = addJObj.keySet();
        for (String key : itKeys) {
            Object value = addJObj.get((Object)key);
            srcJObj.put(key, value);
        }
        return srcJObj.toJSONString();
    }
}

