-- public.tb_zbph_zbtj_zbhz definition

-- Drop table

DROP TABLE public.tb_zbph_zbtj_zbhz;

CREATE TABLE public.tb_zbph_zbtj_zbhz (
	f_id varchar(64) NOT NULL, -- 主键
	f_hcxzqmc varchar(100) NULL, -- 划出行政区名称
	f_hcxzqdm varchar(12) NULL, -- 划出行政区代码
	f_hrxzqmc varchar(100) NULL, -- 划入行政区名称
	f_hrxzqdm varchar(12) NULL, -- 划入行政区名称
	f_zblx int2 NULL, -- 指标类型 1-新方式入库 2-原储备库结转
	f_jybh varchar(100) NULL, -- 交易确认书编号
	f_hzyy int2 NULL, -- 划转原因 ：1交易；2拆借；3归还；4其他
	f_zbgm float8 NULL, -- 指标规模
	f_stgm float8 NULL, -- 水田规模
	f_cjje float8 NULL, -- 成交金额
	f_bz text NULL, -- 备注信息
	f_userid varchar(64) NULL, -- 操作人id
	f_username varchar(64) NULL, -- 操作人姓名
	f_update_time timestamp NULL, -- 操作时间
	f_czlx int2 NULL, -- 操作类型：1省级 2市级
	f_state int2 NULL, -- 划转状态：1划转、2撤销
	f_hzrklsh varchar(64) NULL, -- 划转_入库流水号
	f_hzcklsh varchar(64) NULL, -- 划转_出库流水号
	f_cxrklsh varchar(64) NULL, -- 撤销_入库流水号
	f_cxcklsh varchar(64) NULL, -- 撤销_出库流水号
	f_xzqdm varchar(12) NULL, -- 行政区代码
	f_xzqmc varchar(64) NULL, -- 行政区名称
	f_create_time timestamp NULL, -- 创建时间
	f_xmbh varchar(64) NULL, -- 流水号
	f_xmmc varchar(255) NULL, -- 项目名称
	f_usertel varchar(64) NULL, -- 用户电话号码
	f_finish_time timestamp NULL, -- 完成时间
	CONSTRAINT tb_zbph_zbtj_zbhz_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbtj_zbhz IS '指标调剂指标划转';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hcxzqmc IS '划出行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hcxzqdm IS '划出行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hrxzqmc IS '划入行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hrxzqdm IS '划入行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_zblx IS '指标类型 1-新方式入库 2-原储备库结转';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_jybh IS '交易确认书编号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hzyy IS '划转原因 ：1交易；2拆借；3归还；4其他';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_zbgm IS '指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_stgm IS '水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_cjje IS '成交金额';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_bz IS '备注信息';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_userid IS '操作人id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_username IS '操作人姓名';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_update_time IS '操作时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_czlx IS '操作类型：1省级 2市级';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_state IS '划转状态：1划转、2撤销';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hzrklsh IS '划转_入库流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_hzcklsh IS '划转_出库流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_cxrklsh IS '撤销_入库流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_cxcklsh IS '撤销_出库流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_create_time IS '创建时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_xmbh IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_usertel IS '用户电话号码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbhz.f_finish_time IS '完成时间';


-- public.tb_zbph_zbtj_zbdj definition

-- Drop table

DROP TABLE public.tb_zbph_zbtj_zbdj;

CREATE TABLE public.tb_zbph_zbtj_zbdj (
	f_id varchar(64) NOT NULL, -- 主键
	f_zbxzqmc varchar(100) NOT NULL, -- 指标所在行政区名称
	f_zbxzqdm varchar(12) NOT NULL, -- 指标所在行政区代码
	f_djyy int2 NOT NULL, -- 冻结原因  字典
	f_djjb int2 NOT NULL, -- 冻结级别  字典
	f_djnf varchar(4) NULL, -- 冻结年份
	f_zbgm float8 NOT NULL, -- 指标规模
	f_stgm float8 NULL, -- 水田规模
	f_bz text NULL, -- 备注
	f_userid varchar(64) NULL, -- 填报人id
	f_username varchar(64) NULL, -- 填报人
	f_create_time timestamp NULL, -- 创建时间(冻结时间)
	f_state int2 NULL, -- 冻结状态：1冻结、2解冻
	f_djlsh varchar(64) NULL, -- 冻结流水号
	f_jdlsh varchar(64) NULL, -- 解冻流水号
	f_update_time timestamp NULL, -- 操作时间
	f_xmbh varchar(64) NULL, -- 流水号
	f_xmmc varchar(255) NULL, -- 项目名称
	f_usertel varchar(64) NULL, -- 用户电话号码
	f_finish_time timestamp NULL, -- 完成时间
	f_xzqdm varchar(12) NULL, -- 行政区代码
	f_xzqmc varchar(64) NULL, -- 行政区名称
	f_jd_time timestamp NULL, -- 解冻时间
	CONSTRAINT tb_zbph_zbtj_zbdj_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbtj_zbdj IS '指标调剂指标冻结基本信息表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_zbxzqmc IS '指标所在行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_zbxzqdm IS '指标所在行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_djyy IS '冻结原因  字典';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_djjb IS '冻结级别  字典';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_djnf IS '冻结年份';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_zbgm IS '指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_stgm IS '水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_userid IS '填报人id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_username IS '填报人';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_create_time IS '创建时间(冻结时间)';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_state IS '冻结状态：1冻结、2解冻';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_djlsh IS '冻结流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_jdlsh IS '解冻流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_update_time IS '操作时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_xmbh IS '流水号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_usertel IS '用户电话号码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_finish_time IS '完成时间';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdj.f_jd_time IS '解冻时间';



-- public.tb_zbph_zbtj_zbdjmx definition

-- Drop table

DROP TABLE public.tb_zbph_zbtj_zbdjmx;

CREATE TABLE public.tb_zbph_zbtj_zbdjmx (
	f_id varchar(64) NOT NULL, -- 主键
	f_xmid varchar(64) NULL, -- 项目id
	f_xmmc varchar(100) NULL, -- 项目名称
	f_xmbh varchar(64) NULL, -- 项目编号
	f_djzbgm float8 NULL, -- 冻结指标规模
	f_djstgm float8 NULL, -- 冻结水田规模
	f_djid varchar(64) NULL, -- 外键：冻结基本信息id
	f_xmzbgm float8 NULL, -- 项目指标规模
	f_xmstgm float8 NULL, -- 项目水田规模
	f_xzqdm varchar(12) NULL, -- 行政区代码
	f_xzqmc varchar(64) NULL, -- 行政区名称
	f_jgysrq timestamp NULL, -- 竣工验收日期
	CONSTRAINT tb_zbph_zbtj_zbdjmx_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbtj_zbdjmx IS '指标调剂指标冻结明细表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xmid IS '项目id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_djzbgm IS '冻结指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_djstgm IS '冻结水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_djid IS '外键：冻结基本信息id';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xmzbgm IS '项目指标规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xmstgm IS '项目水田规模';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbtj_zbdjmx.f_jgysrq IS '竣工验收日期';



INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000001', 'tb_zbph_zbtj_zbhz', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, '', NULL, NULL, 1, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000002', 'tb_zbph_zbtj_zbhz', 'f_hcxzqmc', '划出行政区名称', 0, 'varchar', 100, NULL, 0, NULL, NULL, NULL, 2, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000003', 'tb_zbph_zbtj_zbhz', 'f_hcxzqdm', '划出行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 3, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000004', 'tb_zbph_zbtj_zbhz', 'f_hrxzqmc', '划入行政区名称', 0, 'varchar', 100, NULL, 0, NULL, NULL, NULL, 4, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000005', 'tb_zbph_zbtj_zbhz', 'f_hrxzqdm', '划入行政区名称', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 5, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000006', 'tb_zbph_zbtj_zbhz', 'f_zblx', '指标类型', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 6, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000007', 'tb_zbph_zbtj_zbhz', 'f_jybh', '交易确认书编号', 0, 'varchar', 100, NULL, 0, NULL, NULL, NULL, 7, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000008', 'tb_zbph_zbtj_zbhz', 'f_hzyy', '划转原因', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 8, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000009', 'tb_zbph_zbtj_zbhz', 'f_zbgm', '指标规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 9, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000010', 'tb_zbph_zbtj_zbhz', 'f_stgm', '水田规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 10, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000011', 'tb_zbph_zbtj_zbhz', 'f_cjje', '成交金额', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 11, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000012', 'tb_zbph_zbtj_zbhz', 'f_bz', '备注', 0, 'varchar', 10000, NULL, 0, NULL, NULL, NULL, 12, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000013', 'tb_zbph_zbtj_zbhz', 'f_userid', '用户id', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 13, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000014', 'tb_zbph_zbtj_zbhz', 'f_username', '用户名', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 14, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000015', 'tb_zbph_zbtj_zbhz', 'f_update_time', '操作时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 15, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000016', 'tb_zbph_zbtj_zbhz', 'f_czlx', '操作类型', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 16, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000017', 'tb_zbph_zbtj_zbhz', 'f_state', '状态', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 17, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000018', 'tb_zbph_zbtj_zbhz', 'f_hzrklsh', '划转_入库流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 18, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000019', 'tb_zbph_zbtj_zbhz', 'f_hzcklsh', '划转_出库流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 19, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000020', 'tb_zbph_zbtj_zbhz', 'f_cxrklsh', '撤销_入库流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 20, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000021', 'tb_zbph_zbtj_zbhz', 'f_cxcklsh', '撤销_出库流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 21, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000022', 'tb_zbph_zbtj_zbhz', 'f_xzqdm', '行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000023', 'tb_zbph_zbtj_zbhz', 'f_xzqmc', '行政区名称', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 23, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000024', 'tb_zbph_zbtj_zbhz', 'f_create_time', '创建时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 24, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000025', 'tb_zbph_zbtj_zbhz', 'f_finish_time', '完成时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 25, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000026', 'tb_zbph_zbtj_zbhz', 'f_xmbh', '流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 26, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000027', 'tb_zbph_zbtj_zbhz', 'f_xmmc', '项目名称', 0, 'varchar', 255, NULL, 0, NULL, NULL, NULL, 27, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('520000028', 'tb_zbph_zbtj_zbhz', 'f_usertel', '电话', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 28, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000001', 'tb_zbph_zbtj_zbdj', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, '', NULL, NULL, 1, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000002', 'tb_zbph_zbtj_zbdj', 'f_zbxzqmc', '指标行政区', 0, 'varchar', 100, NULL, 0, NULL, NULL, NULL, 2, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000003', 'tb_zbph_zbtj_zbdj', 'f_zbxzqdm', '指标所在行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 3, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000004', 'tb_zbph_zbtj_zbdj', 'f_djyy', '冻结原因', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 4, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000005', 'tb_zbph_zbtj_zbdj', 'f_djjb', '冻结级别', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 5, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000006', 'tb_zbph_zbtj_zbdj', 'f_djnf', '冻结年份', 0, 'varchar', 4, NULL, 0, NULL, NULL, NULL, 6, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000007', 'tb_zbph_zbtj_zbdj', 'f_zbgm', '指标规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 7, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000008', 'tb_zbph_zbtj_zbdj', 'f_stgm', '水田规模', 0, 'numeric', 12, NULL, 0, NULL, NULL, NULL, 8, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000009', 'tb_zbph_zbtj_zbdj', 'f_bz', '备注', 0, 'varchar', 10000, NULL, 0, NULL, NULL, NULL, 9, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000010', 'tb_zbph_zbtj_zbdj', 'f_userid', '用户id', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 10, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000011', 'tb_zbph_zbtj_zbdj', 'f_username', '用户名', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 11, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000012', 'tb_zbph_zbtj_zbdj', 'f_create_time', '创建时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 12, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000013', 'tb_zbph_zbtj_zbdj', 'f_state', '状态', 0, 'int2', 10, NULL, 0, NULL, NULL, NULL, 13, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000014', 'tb_zbph_zbtj_zbdj', 'f_djlsh', '冻结流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 14, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000015', 'tb_zbph_zbtj_zbdj', 'f_jdlsh', '解冻流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 15, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000016', 'tb_zbph_zbtj_zbdj', 'f_update_time', '操作时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 16, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000017', 'tb_zbph_zbtj_zbdj', 'f_xmbh', '流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 17, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000018', 'tb_zbph_zbtj_zbdj', 'f_xmmc', '项目名称', 0, 'varchar', 255, NULL, 0, NULL, NULL, NULL, 18, '8', NULL, 1, NULL, NULL, NULL, NULL, 0, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000019', 'tb_zbph_zbtj_zbdj', 'f_xzqdm', '行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 19, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000020', 'tb_zbph_zbtj_zbdj', 'f_xzqmc', '行政区名称', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 20, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000021', 'tb_zbph_zbtj_zbdj', 'f_usertel', '电话', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 21, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000022', 'tb_zbph_zbtj_zbdj', 'f_finish_time', '完成时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('521000023', 'tb_zbph_zbtj_zbdj', 'f_jd_time', '解冻时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 23, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);



INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000001', 'project-list', '521000017', 1, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000002', 'project-list', '521000002', 2, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000003', 'project-list', '521000020', 3, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000004', 'project-list', '521000004', 4, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000005', 'project-list', '521000007', 5, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000006', 'project-list', '521000008', 6, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000007', 'project-list', '521000016', 7, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000008', 'project-list', '521000011', 8, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000009', 'project-list', '521000013', 9, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('521000010', 'project-list', '521000001', 10, 'tb_zbph_zbtj_zbdj', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000001', 'project-list', '520000026', 1, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000002', 'project-list', '520000002', 2, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000003', 'project-list', '520000004', 3, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000004', 'project-list', '520000006', 4, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000005', 'project-list', '520000007', 5, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000006', 'project-list', '520000008', 6, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000007', 'project-list', '520000009', 7, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000008', 'project-list', '520000010', 8, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000009', 'project-list', '520000015', 9, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000010', 'project-list', '520000014', 10, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000011', 'project-list', '520000017', 11, 'tb_zbph_zbtj_zbhz', 1);
INSERT INTO public.tb_model_group (f_id, f_groupcode, f_fieldid, f_fieldorder, f_tablename, f_visible) VALUES('520000012', 'project-list', '520000001', 12, 'tb_zbph_zbtj_zbhz', 1);


