-- public.tb_zbph_tbrk_zbmx definition

-- Drop table

-- DROP TABLE public.tb_zbph_tbrk_zbmx;

CREATE TABLE public.tb_zbph_tbrk_zbmx (
	id serial4 NOT NULL, -- 自增主键
	shape public.geometry NULL,
	bsm varchar(64) NULL, -- 标识码
	ysdm varchar(64) NULL, -- 要素代码
	tbybh varchar(64) NULL, -- 图斑预编号
	tbbh varchar(64) NULL, -- 图斑编号
	dlbm varchar(4) NULL, -- 地类编码
	dlmc varchar(64) NULL, -- 地类名称
	qsxz varchar(64) NULL, -- 权属性质
	zldwdm varchar(64) NULL, -- 坐落单位代码
	zldwmc varchar(255) NULL, -- 坐落单位名称
	tbmj numeric(20, 4) NULL, -- 图斑面积
	kcdlbm varchar(64) NULL, -- 扣除地类编码
	kcxs numeric(20, 4) NULL, -- 扣除地类系数
	kcmj numeric(20, 4) NULL, -- 扣除地类面积
	tbdlmj numeric(20, 4) NULL, -- 图斑地类面积
	gdlx varchar(64) NULL, -- 耕地类型
	xzdwkd numeric(20, 4) NULL, -- 线状地物宽度
	tbxhdm varchar(4) NULL, -- 图斑细化代码
	tbxhmc varchar(15) NULL, -- 图斑细化名称
	zzsxdm varchar(4) NULL, -- 种植属性代码
	zzsxmc varchar(21) NULL, -- 种植属性名称
	gddb int4 NULL, -- 耕地等别
	czcsxm varchar(64) NULL, -- 城镇村属性码
	sjnf varchar(64) NULL, -- 数据年份
	mssm text NULL, -- 描述说明
	gdpdjb int4 NULL, -- 耕地坡度级别
	frdbs varchar(64) NULL, -- 飞入地标识
	hdmc varchar(255) NULL, -- 海岛名称
	bz text NULL, -- 备注
	gddj int4 NULL, -- 耕地等级
	importtime timestamp(6) NULL, -- 入库时间
	updatetime timestamp(6) NULL, -- 最新操作时间
	checkstate varchar(64) NULL, -- 数据状态
	rksid varchar(64) NULL, -- 入库流水号
	tbid varchar(64) NULL, -- 图斑id
	xzqdm varchar(12) NULL,
	xzqmc varchar(64) NULL,
	CONSTRAINT tb_zbph_tbrk_zbmx_bsm_um UNIQUE (bsm),
	CONSTRAINT tb_zbph_tbrk_zbmx_pkey PRIMARY KEY (id)
);
CREATE INDEX sidx_tb_zbph_tbrk_zbmx_shape ON public.tb_zbph_tbrk_zbmx USING gist (shape);

-- Column comments

COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.id IS '自增主键';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.bsm IS '标识码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.ysdm IS '要素代码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbybh IS '图斑预编号';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbbh IS '图斑编号';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.dlbm IS '地类编码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.dlmc IS '地类名称';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.qsxz IS '权属性质';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.zldwdm IS '坐落单位代码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.zldwmc IS '坐落单位名称';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbmj IS '图斑面积';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.kcdlbm IS '扣除地类编码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.kcxs IS '扣除地类系数';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.kcmj IS '扣除地类面积';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbdlmj IS '图斑地类面积';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.gdlx IS '耕地类型';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.xzdwkd IS '线状地物宽度';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbxhdm IS '图斑细化代码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbxhmc IS '图斑细化名称';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.zzsxdm IS '种植属性代码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.zzsxmc IS '种植属性名称';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.gddb IS '耕地等别';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.czcsxm IS '城镇村属性码';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.sjnf IS '数据年份';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.mssm IS '描述说明';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.gdpdjb IS '耕地坡度级别';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.frdbs IS '飞入地标识';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.hdmc IS '海岛名称';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.gddj IS '耕地等级';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.importtime IS '入库时间';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.updatetime IS '最新操作时间';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.checkstate IS '数据状态';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.rksid IS '入库流水号';
COMMENT ON COLUMN public.tb_zbph_tbrk_zbmx.tbid IS '图斑id';


-- public.tb_zbph_check definition

-- Drop table

-- DROP TABLE public.tb_zbph_check;

CREATE TABLE public.tb_zbph_check (
	f_id varchar(64) NULL, -- 主键
	f_xmid varchar(64) NULL, -- 项目id
	f_checkdate timestamp(6) NULL, -- 审核时间
	f_checkcomment text NULL, -- 审核备注
	f_checkstate varchar(64) NULL, -- 审核状态
	f_checkuserid varchar(64) NULL, -- 审核用户id
	f_checkusername varchar(255) NULL, -- 审核用户名称
	f_checkuserlevel varchar(64) NULL -- 审核用户级别
);
COMMENT ON TABLE public.tb_zbph_check IS '项目审核表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_check.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_check.f_xmid IS '项目id';
COMMENT ON COLUMN public.tb_zbph_check.f_checkdate IS '审核时间';
COMMENT ON COLUMN public.tb_zbph_check.f_checkcomment IS '审核备注';
COMMENT ON COLUMN public.tb_zbph_check.f_checkstate IS '审核状态';
COMMENT ON COLUMN public.tb_zbph_check.f_checkuserid IS '审核用户id';
COMMENT ON COLUMN public.tb_zbph_check.f_checkusername IS '审核用户名称';
COMMENT ON COLUMN public.tb_zbph_check.f_checkuserlevel IS '审核用户级别';

-- public.tb_zbph_zbk_pz definition

-- Drop table

-- DROP TABLE public.tb_zbph_zbk_pz;

CREATE TABLE public.tb_zbph_zbk_pz (
	f_id varchar NOT NULL, -- 主键
	f_xzqdm varchar NULL, -- 行政区代码
	f_xzqmc varchar NULL, -- 行政区名称
	f_xfszbrksx numeric(20, 4) NULL, -- 新方式指标入库上限
	CONSTRAINT tb_zbph_zbk_pz_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_zbk_pz IS '指标配置表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_zbk_pz.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_zbk_pz.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_zbk_pz.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_zbk_pz.f_xfszbrksx IS '新方式指标入库上限';



INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000011', 'tb_zbph_tbrk_zbmx', 'tbmj', '图斑面积', 0, 'numeric', 20, NULL, 0, NULL, NULL, NULL, 11, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000013', 'tb_zbph_tbrk_zbmx', 'kcxs', '扣除地类系数', 0, 'numeric', 20, NULL, 0, NULL, NULL, NULL, 13, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000014', 'tb_zbph_tbrk_zbmx', 'kcmj', '扣除地类面积', 0, 'numeric', 20, NULL, 0, NULL, NULL, NULL, 14, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000006', 'tb_zbph_tbrk_zbmx', 'dlbm', '地类编码', 0, 'varchar', 4, NULL, 0, NULL, NULL, NULL, 6, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000017', 'tb_zbph_tbrk_zbmx', 'xzdwkd', '线状地物宽度', 0, 'numeric', 20, NULL, 0, NULL, NULL, NULL, 17, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000018', 'tb_zbph_tbrk_zbmx', 'tbxhdm', '图斑细化代码', 0, 'varchar', 4, NULL, 0, NULL, NULL, NULL, 18, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000019', 'tb_zbph_tbrk_zbmx', 'tbxhmc', '图斑细化名称', 0, 'varchar', 15, NULL, 0, NULL, NULL, NULL, 19, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000020', 'tb_zbph_tbrk_zbmx', 'zzsxdm', '种植属性代码', 0, 'varchar', 4, NULL, 0, NULL, NULL, NULL, 20, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000021', 'tb_zbph_tbrk_zbmx', 'zzsxmc', '种植属性名称', 0, 'varchar', 21, NULL, 0, NULL, NULL, NULL, 21, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000030', 'tb_zbph_tbrk_zbmx', 'gddj', '耕地等级', 0, 'int4', 8, NULL, 0, NULL, NULL, NULL, 30, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000031', 'tb_zbph_tbrk_zbmx', 'importtime', '入库时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 31, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000032', 'tb_zbph_tbrk_zbmx', 'updatetime', '最新操作时间', 0, 'timestamp', 6, NULL, 0, '', NULL, NULL, 32, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000033', 'tb_zbph_tbrk_zbmx', 'checkstate', '数据状态', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 33, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000034', 'tb_zbph_tbrk_zbmx', 'rksid', '入库流水号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 34, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000035', 'tb_zbph_tbrk_zbmx', 'tbid', '图斑id', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 35, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000036', 'tb_zbph_tbrk_zbmx', 'xzqdm', '行政区代码', 0, 'varchar', 12, NULL, 0, NULL, NULL, NULL, 36, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000023', 'tb_zbph_tbrk_zbmx', 'czcsxm', '城镇村属性码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 23, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000024', 'tb_zbph_tbrk_zbmx', 'sjnf', '数据年份', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 24, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000027', 'tb_zbph_tbrk_zbmx', 'frdbs', '飞入地标识', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 27, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000028', 'tb_zbph_tbrk_zbmx', 'hdmc', '海岛名称', 0, 'varchar', 255, NULL, 0, NULL, NULL, NULL, 28, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000029', 'tb_zbph_tbrk_zbmx', 'bz', '备注', 0, 'text', 0, NULL, 0, NULL, NULL, NULL, 29, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000025', 'tb_zbph_tbrk_zbmx', 'mssm', '描述说明', 0, 'text', 0, NULL, 0, NULL, NULL, NULL, 25, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000037', 'tb_zbph_tbrk_zbmx', 'xzqmc', '所属行政区', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 37, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000022', 'tb_zbph_tbrk_zbmx', 'gddb', '耕地等别', 0, 'int4', 8, NULL, 0, NULL, NULL, NULL, 22, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000026', 'tb_zbph_tbrk_zbmx', 'gdpdjb', '耕地坡度级别', 0, 'int4', 8, NULL, 0, NULL, NULL, NULL, 26, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000010', 'tb_zbph_tbrk_zbmx', 'zldwmc', '坐落单位名称', 0, 'varchar', 255, NULL, 0, NULL, NULL, NULL, 10, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000012', 'tb_zbph_tbrk_zbmx', 'kcdlbm', '扣除地类编码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 12, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000016', 'tb_zbph_tbrk_zbmx', 'gdlx', '耕地类型', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 16, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000002', 'tb_zbph_tbrk_zbmx', 'bsm', '标识码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 2, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000003', 'tb_zbph_tbrk_zbmx', 'ysdm', '要素代码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 3, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000004', 'tb_zbph_tbrk_zbmx', 'tbybh', '图斑预编号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 4, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000005', 'tb_zbph_tbrk_zbmx', 'tbbh', '图斑编号', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 5, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000007', 'tb_zbph_tbrk_zbmx', 'dlmc', '地类名称', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 7, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000008', 'tb_zbph_tbrk_zbmx', 'qsxz', '权属性质', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 8, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000009', 'tb_zbph_tbrk_zbmx', 'zldwdm', '坐落单位代码', 0, 'varchar', 64, NULL, 0, NULL, NULL, NULL, 9, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000015', 'tb_zbph_tbrk_zbmx', 'tbdlmj', '图斑地类面积(公顷)', 0, 'numeric', 20, NULL, 0, NULL, NULL, NULL, 15, '8', NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields
(f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic)
VALUES('500000000001', 'tb_zbph_tbrk_zbmx', 'id', '主键', 1, 'varchar', 64, NULL, 0, '', NULL, NULL, 1, '8', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);




