CREATE TABLE tb_zbph_task_record (
    f_id varchar(64) NOT NULL,
    f_start_time timestamp(6) NULL, -- 执行时间
    f_end_time timestamp(6) NULL, -- 结束时间
    f_user_id varchar(64) NULL, -- 用户id
    f_user_name varchar(64) NULL, -- 用户名
    f_xzqdm varchar(32) NULL, -- 行政区代码
    f_xzqmc varchar(64) NULL, -- 行政区名称
    f_status int2 NULL, -- 0.进行中 1.完成  -1.失败
    f_msg text NULL, -- 错误信息
    f_type varchar(64) NULL, -- 业务类型
    f_custom_class varchar(255) NULL, -- 业务处理类
    f_param text NULL, -- 业务参数
    f_create_time timestamp(6) NULL, -- 任务创建时间
    CONSTRAINT tb_zbph_task_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE public.tb_zbph_task_record IS '任务管理表';
COMMENT ON COLUMN public.tb_zbph_task_record.f_start_time IS '执行时间';
COMMENT ON COLUMN public.tb_zbph_task_record.f_end_time IS '结束时间';
COMMENT ON COLUMN public.tb_zbph_task_record.f_user_id IS '用户id';
COMMENT ON COLUMN public.tb_zbph_task_record.f_user_name IS '用户名';
COMMENT ON COLUMN public.tb_zbph_task_record.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_task_record.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_task_record.f_status IS '0.进行中 1.完成  -1.失败';
COMMENT ON COLUMN public.tb_zbph_task_record.f_msg IS '错误信息';
COMMENT ON COLUMN public.tb_zbph_task_record.f_type IS '业务类型';
COMMENT ON COLUMN public.tb_zbph_task_record.f_custom_class IS '业务处理类';
COMMENT ON COLUMN public.tb_zbph_task_record.f_param IS '业务参数';
COMMENT ON COLUMN public.tb_zbph_task_record.f_create_time IS '任务创建时间';

INSERT INTO tb_cfg_dict (f_id, f_name, f_key, f_desc, f_createtime) VALUES('9412b7a0-0346-7da5-7668-6b33ea75349b', '任务管理-业务类型', 'task-manage-type', '任务管理的业务类型', '2024-07-19 14:54:18.000');
INSERT INTO tb_cfg_dict_value (f_id, f_itemtext, f_itemvalue, f_dictid, f_sort, f_json, f_pid, f_level) VALUES('9412b7a0-0346-7da5-7668-100001', 'FLTBRK', 'com.geoway.onemap.zbph.service.xfstbrk.impl.ZbkTbrkTaskExecuteServiceImpl', '9412b7a0-0346-7da5-7668-6b33ea75349b', 1, NULL, '-1', 1);
INSERT INTO tb_cfg_dict_value (f_id, f_itemtext, f_itemvalue, f_dictid, f_sort, f_json, f_pid, f_level) VALUES('9412b7a0-0346-7da5-7668-100002', 'FNTBRK', 'com.geoway.onemap.zbph.service.xfstbrk.impl.ZbkTbrkTaskExecuteServiceImpl', '9412b7a0-0346-7da5-7668-6b33ea75349b', 1, '', '-1', 1);
