-- public.v_zbph_zbk_dkmx_ggxm source
drop view if exists v_zbph_zbk_dkmx_ggxm;
CREATE OR REPLACE VIEW v_zbph_zbk_dkmx_ggxm
AS SELECT zgck.f_xmid AS xmid,
    min(zgck.f_xmmc::text) AS xmmc,
    min(zgck.f_xmbh::text) AS xmbh,
    min(zgck.f_xmxzqdm::text) AS xmxzqdm,
    min(zgck.f_xmxzqmc::text) AS xmxzqmc,
    rkmx.f_id AS zbid,
    rkmx.f_gddb AS gddb,
    min(rkmx.f_date) AS date,
    min(rkmx.f_dkbh::text) AS dkbh,
    sum(zgck.f_bcgdmj) AS bcgdmj,
    avg(zgck.f_xbcgdsl) AS xbcgdmj,
    sum(zgck.f_bcstmj) AS bcstmj,
    avg(zgck.f_xbcstgm) AS xbcstmj,
    rkmx.f_zbxzqmc AS zbxzqmc,
    rkmx.f_zbxzqdm AS zbxzqdm,
    avg(rkmx.f_gdmj) AS gdmj,
    avg(rkmx.f_stmj) AS stmj,
    avg(sytj.f_gdmj_yy) AS gdmjyy,
    avg(sytj.f_gdmj_sy) AS gdmjsy,
    avg(sytj.f_gdmj_sd) AS gdmjsd,
    avg(sytj.f_stmj_yy) AS stmjyy,
    avg(sytj.f_stmj_sy) AS stmjsy,
    avg(sytj.f_stmj_sd) AS stmjsd,
    avg(sytj.f_cnzb_yy) AS cnzbyy,
    avg(sytj.f_cnzb_sy) AS cnzbsy,
    avg(sytj.f_cnzb_sd) AS cnzbsd,
    min(rkmx.f_dlbm::text) AS dlbm,
    min(rkmx.f_dlmc::text) AS dlmc,
    avg(sytj.f_gdmj_sd + sytj.f_gdmj_sy) AS gdmjzzsy,
    avg(sytj.f_stmj_sd + sytj.f_stmj_sy) AS stmjzzsy,
    avg(sytj.f_cnzb_sd + sytj.f_cnzb_yy) AS cnzbzzsy
   FROM tb_zbph_zbk_rkmx rkmx
     LEFT JOIN ( SELECT zgck_dkxx.f_bcgdmj,
            zgck_dkxx.f_bcstmj,
            zgck_dkxx.f_zbid,
            zgck_dkxx.f_xmid,
            zgck_xmxx.f_xmmc,
            zgck_xmxx.f_xmbh,
            zgck_xmxx.f_xmxzqdm,
            zgck_xmxx.f_xmxzqmc,
            zgck_xmxx.f_xbcgdsl,
            zgck_xmxx.f_xbcstgm
           FROM tb_zbph_zgck_bcgddkxx zgck_dkxx
             LEFT JOIN tb_zbph_zgck_xmxx zgck_xmxx ON zgck_dkxx.f_xmid::text = zgck_xmxx.f_id::text
          WHERE zgck_xmxx.f_processstate::text = 'p51'::text) zgck ON zgck.f_zbid::text = rkmx.f_id::text
     LEFT JOIN tb_zbph_zbk_sytj sytj ON sytj.f_zbid::text = rkmx.f_id::text
  GROUP BY zgck.f_xmid, rkmx.f_id, zgck.f_xmbh, zgck.f_xmxzqdm, zgck.f_xmxzqmc;




  -- public.v_zbph_zbk_dkmx_sytj source
drop view if exists v_zbph_zbk_dkmx_sytj;
CREATE OR REPLACE VIEW v_zbph_zbk_dkmx_sytj
AS SELECT rk.zbid,
    rk.zbxzqdm,
    rk.zbxzqmc,
    rk.czxzqdm,
    rk.czxzqmc,
    rk.czlx,
    rk.zblx,
    rk.gdmj,
    rk.stmj,
    rk.cnzb,
    rk.gddb,
    rk.xmbh,
    rk.xmmc,
    rk.xmjgysrq,
    rk.dkbh,
    rk.dkmc,
    rk.dkxzqmc,
    rk.dkxzqdm,
    rk.date,
    rk.userid,
    rk.username,
    rk.zy,
    rk.sid,
    rk.lyid,
    rk.dkid,
    rk.gdmjyy,
    rk.gdmjsy,
    rk.gdmjsd,
    rk.stmjyy,
    rk.stmjsy,
    rk.stmjsd,
    rk.cnzbyy,
    rk.cnzbsy,
    rk.cnzbsd,
    rk.dlbm,
    rk.dlmc,
    rk.gdmjzzsy,
    rk.stmjzzsy,
    rk.cnzbzzsy,
    rk.rklx,
    ck.ggxmgs
   FROM ( SELECT rkmx.f_id AS zbid,
            rkmx.f_zbxzqdm AS zbxzqdm,
            rkmx.f_zbxzqmc AS zbxzqmc,
            rkmx.f_czxzqdm AS czxzqdm,
            rkmx.f_czxzqmc AS czxzqmc,
            rkmx.f_czlx AS czlx,
            rkmx.f_zblx AS zblx,
            rkmx.f_gdmj AS gdmj,
            rkmx.f_stmj AS stmj,
            rkmx.f_cnzb AS cnzb,
            rkmx.f_gddb AS gddb,
            rkmx.f_xmbh AS xmbh,
            rkmx.f_xmmc AS xmmc,
            rkmx.f_xmjgysrq AS xmjgysrq,
            rkmx.f_dkbh AS dkbh,
            rkmx.f_dkmc AS dkmc,
            rkmx.f_rklx AS rklx,
            rkmx.f_dkxzqmc AS dkxzqmc,
            rkmx.f_dkxzqdm AS dkxzqdm,
            rkmx.f_date AS date,
            rkmx.f_userid AS userid,
            rkmx.f_username AS username,
            rkmx.f_zy AS zy,
            rkmx.f_sid AS sid,
            rkmx.f_lyid AS lyid,
            rkmx.f_dkid AS dkid,
            sytj.f_gdmj_yy AS gdmjyy,
            sytj.f_gdmj_sy AS gdmjsy,
            sytj.f_gdmj_sd AS gdmjsd,
            sytj.f_stmj_yy AS stmjyy,
            sytj.f_stmj_sy AS stmjsy,
            sytj.f_stmj_sd AS stmjsd,
            sytj.f_cnzb_yy AS cnzbyy,
            sytj.f_cnzb_sy AS cnzbsy,
            sytj.f_cnzb_sd AS cnzbsd,
            rkmx.f_dlbm AS dlbm,
            rkmx.f_dlmc AS dlmc,
            sytj.f_gdmj_sd + sytj.f_gdmj_sy AS gdmjzzsy,
            sytj.f_stmj_sd + sytj.f_stmj_sy AS stmjzzsy,
            sytj.f_cnzb_sd + sytj.f_cnzb_yy AS cnzbzzsy
           FROM tb_zbph_zbk_rkmx rkmx
             LEFT JOIN tb_zbph_zbk_sytj sytj ON rkmx.f_id::text = sytj.f_zbid::text) rk
     LEFT JOIN ( SELECT rkmx.f_id AS zbid,
            count(DISTINCT ckmx.f_xmid) AS ggxmgs
           FROM tb_zbph_zgck_bcgddkxx ckmx
             LEFT JOIN tb_zbph_zbk_rkmx rkmx ON rkmx.f_id::text = ckmx.f_zbid::text
             LEFT JOIN tb_zbph_zgck_xmxx ckxmxx ON ckmx.f_xmid::text = ckxmxx.f_id::text
          WHERE ckxmxx.f_processstate::text = 'p51'::text
          GROUP BY rkmx.f_id) ck ON rk.zbid::text = ck.zbid::text;


drop view  if exists  v_zbph_zbk_xmmx_ggxm;
          CREATE OR REPLACE VIEW public.v_zbph_zbk_xmmx_ggxm
AS SELECT zgck.f_xmid AS xmid,
    min(zgck.f_xmmc::text) AS xmmc,
    min(zgck.f_xmbh::text) AS xmbh,
    min(zgck.f_xmxzqdm::text) AS xmxzqdm,
    min(zgck.f_xmxzqmc::text) AS xmxzqmc,
    rkmx.f_sid AS sid,
    sum(zgck.f_bcgdmj) AS bcgdmj,
    avg(zgck.f_xbcgdsl) AS xbcgdmj,
    sum(zgck.f_bcstmj) AS bcstmj,
    avg(zgck.f_xbcstgm) AS xbcstmj
   FROM tb_zbph_zbk_rkmx rkmx
     JOIN ( SELECT zgck_dkxx.f_bcgdmj,
            zgck_dkxx.f_bcstmj,
            zgck_dkxx.f_zbid,
            zgck_dkxx.f_xmid,
            zgck_xmxx.f_xmmc,
            zgck_xmxx.f_xmbh,
            zgck_xmxx.f_xmxzqdm,
            zgck_xmxx.f_xmxzqmc,
            zgck_xmxx.f_xbcgdsl,
            zgck_xmxx.f_xbcstgm
           FROM tb_zbph_zgck_bcgddkxx zgck_dkxx
             LEFT JOIN tb_zbph_zgck_xmxx zgck_xmxx ON zgck_dkxx.f_xmid::text = zgck_xmxx.f_id::text
          WHERE zgck_xmxx.f_processstate::text = 'p51'::text) zgck ON zgck.f_zbid::text = rkmx.f_id::text
  GROUP BY zgck.f_xmid, rkmx.f_sid, zgck.f_xmbh, zgck.f_xmxzqdm, zgck.f_xmxzqmc;


-- public.v_zbph_zbk_xmmx_sytj source
drop view if exists  v_zbph_zbk_xmmx_sytj;
CREATE OR REPLACE VIEW v_zbph_zbk_xmmx_sytj
AS SELECT rk.zbxzqdm,
    rk.zbxzqmc,
    rk.zblx,
    rk.xmbh,
    rk.xmmc,
    rk.sid,
    rk.rklx,
    rk.xmjgysrq,
    rk.gdmj,
    rk.gdmjyy,
    rk.gdmjsy,
    rk.gdmjsd,
    rk.gdmjzzsy,
    rk.stmj,
    rk.stmjyy,
    rk.stmjsy,
    rk.stmjsd,
    rk.stmjzzsy,
    rk.cnzb,
    rk.cnzbyy,
    rk.cnzbsy,
    rk.cnzbsd,
    rk.cnzbzzsy,
    ck.ggxmgs
   FROM ( SELECT rkmx.f_zbxzqdm AS zbxzqdm,
            rkmx.f_zbxzqmc AS zbxzqmc,
            rkmx.f_zblx AS zblx,
            rkmx.f_xmbh AS xmbh,
            rkmx.f_xmmc AS xmmc,
            rkmx.f_sid AS sid,
            rkmx.f_rklx AS rklx,
            min(rkmx.f_xmjgysrq) AS xmjgysrq,
            sum(sytj.f_gdmj) AS gdmj,
            sum(sytj.f_gdmj_yy) AS gdmjyy,
            sum(sytj.f_gdmj_sy) AS gdmjsy,
            sum(sytj.f_gdmj_sd) AS gdmjsd,
            sum(sytj.f_gdmj_sd) + sum(sytj.f_gdmj_sy) AS gdmjzzsy,
            sum(sytj.f_stmj) AS stmj,
            sum(sytj.f_stmj_yy) AS stmjyy,
            sum(sytj.f_stmj_sy) AS stmjsy,
            sum(sytj.f_stmj_sd) AS stmjsd,
            sum(sytj.f_stmj_sd) + sum(sytj.f_stmj_sy) AS stmjzzsy,
            sum(sytj.f_cnzb) AS cnzb,
            sum(sytj.f_cnzb_yy) AS cnzbyy,
            sum(sytj.f_cnzb_sy) AS cnzbsy,
            sum(sytj.f_cnzb_sd) AS cnzbsd,
            sum(sytj.f_cnzb_sd) + sum(sytj.f_cnzb_yy) AS cnzbzzsy
           FROM tb_zbph_zbk_rkmx rkmx
             LEFT JOIN tb_zbph_zbk_sytj sytj ON rkmx.f_id::text = sytj.f_zbid::text
          GROUP BY rkmx.f_zbxzqdm, rkmx.f_zbxzqmc, rkmx.f_sid, rkmx.f_xmbh, rkmx.f_xmmc, rkmx.f_rklx, rkmx.f_zblx) rk
     LEFT JOIN ( SELECT rkmx.f_sid AS sid,
            rkmx.f_xmbh AS xmbh,
            count(DISTINCT ckmx.f_xmid) AS ggxmgs
           FROM tb_zbph_zgck_bcgddkxx ckmx
             LEFT JOIN tb_zbph_zbk_rkmx rkmx ON rkmx.f_id::text = ckmx.f_zbid::text
             LEFT JOIN tb_zbph_zgck_xmxx ckxmxx ON ckmx.f_xmid::text = ckxmxx.f_id::text
          WHERE ckxmxx.f_processstate::text = 'p51'::text
          GROUP BY rkmx.f_sid, rkmx.f_xmbh) ck ON rk.sid::text = ck.sid::text AND rk.xmbh::text = ck.xmbh::text;


delete from tb_model_fields where f_tablename in ('v_zbph_zbk_dkmx_sytj','v_zbph_zbk_xmmx_sytj');
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989924', 'v_zbph_zbk_dkmx_sytj', 'dkid', '地块id', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989925', 'v_zbph_zbk_dkmx_sytj', 'gdmjyy', '耕地面积已用', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989926', 'v_zbph_zbk_dkmx_sytj', 'gdmjsy', '耕地面积剩余', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989927', 'v_zbph_zbk_dkmx_sytj', 'gdmjsd', '耕地面积锁定', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989928', 'v_zbph_zbk_dkmx_sytj', 'stmjyy', '水田面积已用', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989929', 'v_zbph_zbk_dkmx_sytj', 'stmjsy', '水田面积剩余', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989930', 'v_zbph_zbk_dkmx_sytj', 'stmjsd', '水田面积锁定', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989931', 'v_zbph_zbk_dkmx_sytj', 'cnzbyy', '产能指标已用', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989932', 'v_zbph_zbk_dkmx_sytj', 'cnzbsy', '产能指标剩余', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569898', 'v_zbph_zbk_xmmx_sytj', 'zbxzqdm', '指标所在行政区代码', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569818', 'v_zbph_zbk_xmmx_sytj', 'zbxzqmc', '指标所在行政区名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569828', 'v_zbph_zbk_xmmx_sytj', 'zblx', '指标类型', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569838', 'v_zbph_zbk_xmmx_sytj', 'xmbh', '项目编号', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569848', 'v_zbph_zbk_xmmx_sytj', 'xmmc', '项目名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569858', 'v_zbph_zbk_xmmx_sytj', 'sid', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569868', 'v_zbph_zbk_xmmx_sytj', 'rklx', '入库类型', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569878', 'v_zbph_zbk_xmmx_sytj', 'xmjgysrq', '项目验收时间', 0, 'timestamp', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569888', 'v_zbph_zbk_xmmx_sytj', 'gdmj', '入库耕地面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569108', 'v_zbph_zbk_xmmx_sytj', 'gdmjyy', '已用耕地面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569138', 'v_zbph_zbk_xmmx_sytj', 'gdmjzzsy', '剩余耕地面积（包含锁定面积）', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569148', 'v_zbph_zbk_xmmx_sytj', 'stmj', '入库水田面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698991', 'v_zbph_zbk_dkmx_sytj', 'zbxzqdm', '指标所在行政区代码', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569168', 'v_zbph_zbk_xmmx_sytj', 'stmjsy', '入库水田面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569178', 'v_zbph_zbk_xmmx_sytj', 'stmjsd', '锁定水田面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569188', 'v_zbph_zbk_xmmx_sytj', 'stmjzzsy', '剩余水田面积（包含锁定面积）', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569198', 'v_zbph_zbk_xmmx_sytj', 'cnzb', '入库产能指标', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569208', 'v_zbph_zbk_xmmx_sytj', 'cnzbyy', '已用产能指标', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569218', 'v_zbph_zbk_xmmx_sytj', 'cnzbsy', '剩余产能指标', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569228', 'v_zbph_zbk_xmmx_sytj', 'cnzbsd', '锁定产能指标', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569238', 'v_zbph_zbk_xmmx_sytj', 'cnzbzzsy', '剩余产能指标（包含锁定面积）', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569248', 'v_zbph_zbk_xmmx_sytj', 'ggxmgs', '挂钩项目个数', 0, 'int4', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569118', 'v_zbph_zbk_xmmx_sytj', 'gdmjsy', '剩余', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569128', 'v_zbph_zbk_xmmx_sytj', 'gdmjsd', '锁定耕地面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698992', 'v_zbph_zbk_dkmx_sytj', 'zbxzqmc', '指标所在行政区名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698993', 'v_zbph_zbk_dkmx_sytj', 'czxzqdm', '操作行政区代码', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698994', 'v_zbph_zbk_dkmx_sytj', 'czxzqmc', '操作行政区名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698995', 'v_zbph_zbk_dkmx_sytj', 'czlx', '操作类型', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698996', 'v_zbph_zbk_dkmx_sytj', 'zblx', '指标类型', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698997', 'v_zbph_zbk_dkmx_sytj', 'gdmj', '耕地面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698998', 'v_zbph_zbk_dkmx_sytj', 'stmj', '水田面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('25698999', 'v_zbph_zbk_dkmx_sytj', 'cnzb', '产能指标', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989910', 'v_zbph_zbk_dkmx_sytj', 'gddb', '耕地等别', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989911', 'v_zbph_zbk_dkmx_sytj', 'xmbh', '项目编号', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989912', 'v_zbph_zbk_dkmx_sytj', 'xmmc', '项目名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989913', 'v_zbph_zbk_dkmx_sytj', 'xmjgysrq', '项目竣工时间', 0, 'timestamp', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989914', 'v_zbph_zbk_dkmx_sytj', 'dkbh', '地块编号', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989915', 'v_zbph_zbk_dkmx_sytj', 'dkmc', '地块名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989916', 'v_zbph_zbk_dkmx_sytj', 'dkxzqmc', '地块行政区名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989917', 'v_zbph_zbk_dkmx_sytj', 'dkxzqdm', '地块行政区代码', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989918', 'v_zbph_zbk_dkmx_sytj', 'date', '入库时间', 0, 'timestamp', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989919', 'v_zbph_zbk_dkmx_sytj', 'userid', '用户id', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989920', 'v_zbph_zbk_dkmx_sytj', 'username', '用户名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989921', 'v_zbph_zbk_dkmx_sytj', 'zy', '摘要', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989922', 'v_zbph_zbk_dkmx_sytj', 'sid', '流水号', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989923', 'v_zbph_zbk_dkmx_sytj', 'lyid', '来源id', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989933', 'v_zbph_zbk_dkmx_sytj', 'cnzbsd', '产能指标锁定', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989934', 'v_zbph_zbk_dkmx_sytj', 'dlbm', '地类编码', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989935', 'v_zbph_zbk_dkmx_sytj', 'dlmc', '地类名称', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989936', 'v_zbph_zbk_dkmx_sytj', 'gdmjzzsy', '耕地面积剩余(包含锁定面积)', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989937', 'v_zbph_zbk_dkmx_sytj', 'stmjzzsy', '水田面积剩余(包含锁定面积)', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989938', 'v_zbph_zbk_dkmx_sytj', 'cnzbzzsy', '产能指标剩余(包含锁定面积)', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989939', 'v_zbph_zbk_dkmx_sytj', 'ggxmgs', '挂钩项目个数', 0, 'int4', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989940', 'v_zbph_zbk_dkmx_sytj', 'zbid', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('2569158', 'v_zbph_zbk_xmmx_sytj', 'stmjyy', '已用水田面积', 0, 'numeric', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);
INSERT INTO public.tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('256989941', 'v_zbph_zbk_dkmx_sytj', 'rklx', '入库类型', 0, 'varchar', 64, NULL, 0, 'uuid', NULL, NULL, 1, '1', NULL, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL);

delete from tb_model_objectinfo where f_id in ('505','506','507','508');
INSERT INTO public.tb_model_objectinfo (f_id, f_typename, f_tablename, f_tablealias, f_isspatial, f_spatialtype, f_srid, f_remark, f_order, f_version, f_state, f_tableversion, f_configinfo, f_parentid, f_servicename) VALUES('506', '指标库-补充耕地挂钩出库', 'v_zbph_zbk_xmmx_ggxm', '指标库-补充耕地挂钩出库', 0, NULL, NULL, NULL, 29, '1', '1', 1, NULL, NULL, 'zbk_xmmx_ggxm');
INSERT INTO public.tb_model_objectinfo (f_id, f_typename, f_tablename, f_tablealias, f_isspatial, f_spatialtype, f_srid, f_remark, f_order, f_version, f_state, f_tableversion, f_configinfo, f_parentid, f_servicename) VALUES('507', '指标库-地块使用明细', 'v_zbph_zbk_dkmx_sytj', '指标库-项目使用明细', 0, NULL, NULL, NULL, 29, '1', '1', 1, NULL, NULL, 'zbk_dkmx_sytj');
INSERT INTO public.tb_model_objectinfo (f_id, f_typename, f_tablename, f_tablealias, f_isspatial, f_spatialtype, f_srid, f_remark, f_order, f_version, f_state, f_tableversion, f_configinfo, f_parentid, f_servicename) VALUES('508', '指标库-补充耕地挂钩出库(地块)', 'v_zbph_zbk_dkmx_ggxm', '指标库-补充耕地挂钩出库', 0, NULL, NULL, NULL, 29, '1', '1', 1, NULL, NULL, 'zbk_dkmx_ggxm');
INSERT INTO public.tb_model_objectinfo (f_id, f_typename, f_tablename, f_tablealias, f_isspatial, f_spatialtype, f_srid, f_remark, f_order, f_version, f_state, f_tableversion, f_configinfo, f_parentid, f_servicename) VALUES('505', '指标库-项目使用明细', 'v_zbph_zbk_xmmx_sytj', '指标库-项目使用明细', 0, NULL, NULL, NULL, 29, '1', '1', 1, NULL, NULL, 'zbk_xmmx_sytj');
