-- 关联流水号
alter table tb_zbph_zbk_czmx add column f_gllsh varchar;
-- 同步状态(0:未同步  1:同步中  2:已同步)
alter table tb_zbph_zbk_czmx add column f_sync_flag varchar default '0';
-- 同步完成时间
alter table tb_zbph_zbk_czmx add column f_sync_time timestamp;


-- 部级指标操作明细同步数据
create table tb_zbph_sync_bjzbczmx
(
    f_id        varchar(32) primary key not null,
    f_lsh       varchar,                -- 部级流水号
    f_cbzbxzqdm varchar,                -- 储备指标行政区代码
    f_cbzbxzqmc varchar,                -- 储备指标行政区名称
    f_czxzqdm   varchar,                -- 操作行政区代码
    f_czxzqmc   varchar,                -- 操作行政区名称
    f_czlx      varchar,                -- 操作类型
    f_zblx      varchar,                -- 指标类型
    f_zbgm      numeric(20, 4),         -- 指标规模
    f_stgm      numeric(20, 4),         -- 水田规模
    f_czr       varchar,                -- 操作人
    f_zy        varchar,                -- 摘要
    f_czrq      timestamp,              -- 操作日期
    f_czlxzw    varchar,                -- 操作类型名称
    f_zblxzw    varchar,                -- 指标类型名称
    f_gllsh     varchar,                -- 关联流水号
    f_czzt      int       default 0,    -- 操作状态（0：未处理 1：处理中 2：已处理）
    f_sync_time timestamp default now() -- 同步时间
);
