-- 新增已用图形、是否已经破图斑字段
DO
$do$
BEGIN
	if (select exists( SELECT column_name FROM information_schema.columns WHERE table_name = 'tb_project_gdbh_cbbcgd_fnzygd_bcgddetail' AND column_name = 'f_shape' )) = false
	then	
		ALTER TABLE public.tb_project_gdbh_cbbcgd_fnzygd_bcgddetail ADD f_shape public.geometry(geometry, 4490) NULL;
		COMMENT ON COLUMN public.tb_project_gdbh_cbbcgd_fnzygd_bcgddetail.f_shape IS '入库地块破图斑';
		ALTER TABLE public.tb_project_gdbh_cbbcgd_fnzygd_bcgddetail ADD f_is_split int2 NULL;
		COMMENT ON COLUMN public.tb_project_gdbh_cbbcgd_fnzygd_bcgddetail.f_is_split IS '是否已经破图斑（1已经、0未破）';
    end if;
END
$do$;

-- 新增已用图斑表【指标入库地块空间表—剩余未挂接空间几何（临时表）】
DROP TABLE IF EXISTS "public"."tb_zbph_zbk_rkdk_temp";
CREATE TABLE tb_zbph_zbk_rkdk_temp (
	f_zbid varchar(255) NOT NULL, -- 指标id
	f_shape public.geometry NULL, -- 剩余未挂接空间几何
	f_symj numeric(20, 4) NULL, -- 剩余面积
	CONSTRAINT tb_zbph_zbk_rkdk_temp_pk PRIMARY KEY (f_zbid)
);
CREATE INDEX tb_zbph_zbk_rkdk_temp_shape_idx ON public.tb_zbph_zbk_rkdk_temp USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_zbk_rkdk_temp IS '指标入库地块空间表—剩余未挂接空间几何（临时表）';
-- Column comments
COMMENT ON COLUMN public.tb_zbph_zbk_rkdk_temp.f_zbid IS '指标id';
COMMENT ON COLUMN public.tb_zbph_zbk_rkdk_temp.f_shape IS '剩余未挂接空间几何';
COMMENT ON COLUMN public.tb_zbph_zbk_rkdk_temp.f_symj IS '剩余面积';