-- 立项增加字段
DO
$do$
BEGIN
	if (select exists( SELECT column_name FROM information_schema.columns WHERE table_name = 'tb_zbph_bcgdlx_xmxx' AND column_name = 'f_xmxzqdm' )) = false
	then	
	
	ALTER TABLE tb_zbph_bcgdlx_xmxx ADD f_xmxzqdm varchar(32) NULL;
	COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xmxzqdm IS '项目行政区代码';
	ALTER TABLE tb_zbph_bcgdlx_xmxx ADD f_xmxzqmc varchar(64) NULL;
	COMMENT ON COLUMN public.tb_zbph_bcgdlx_xmxx.f_xmxzqmc IS '项目行政区名称';

	INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20032', 'tb_zbph_bcgdlx_xmxx', 'f_xmxzqdm', '项目所在行政区代码', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
	INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('20033', 'tb_zbph_bcgdlx_xmxx', 'f_xmxzqmc', '项目所在行政区', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
    
	end if;
END
$do$;

-- 新增验收库表

-- 验收项目信息表
CREATE TABLE tb_zbph_bcgdys_xmxx (
	f_id varchar(64) NOT NULL, -- 主键
	f_type varchar(50) NULL, -- 项目类型
	f_xmmc varchar(100) NULL, -- 项目名称
	f_xzqmc varchar(255) NULL, -- 项目所在地
	f_xmbh varchar(100) NULL, -- 验收备案编号
	f_create_time timestamp(6) NULL, -- 创建时间
	f_userid varchar(64) NULL, -- 创建人ID
	f_processid varchar(64) NULL, -- 流程实例ID
	f_xzqdm varchar(20) NULL, -- 行政区代码
	f_xmzgbm varchar(50) NULL, -- 项目主管部门
	f_pf_pfwh varchar(255) NULL, -- 项目立项批复文号
	f_ys_yswh varchar(255) NULL, -- 项目竣工验收文号
	f_jgysfzr varchar(255) NULL, -- 项目竣工验收负责人
	f_bcgdmj numeric(12, 4) NULL, -- 补充耕地面积（公顷）
	f_jzgdmj numeric(12, 4) NULL, -- 净增耕地面积（公顷）
	f_jzstmj numeric(12, 4) NULL, -- 净增水田面积（公顷）
	f_bcgdpjzldb varchar(255) NULL, -- 补充耕地平均质量等别
	f_ys_gm_zgm numeric(12, 4) NULL, -- 项目建设总规模（公顷）
	f_tzgzgdmj numeric(12, 4) NULL, -- 提质改造耕地面积（公顷）
	f_tzgzstmj numeric(12, 4) NULL, -- 提质改造水田面积（公顷）
	f_tzgzqzldb varchar(255) NULL, -- 提质改造前平均质量等别
	f_tzgzhzldb varchar(255) NULL, -- 提质改造后平均质量等别
	f_ys_tz_ztz numeric(12, 4) NULL, -- 项目总投资（万元）
	f_pf_pfrq timestamp(6) NULL, -- 项目立项批复日期
	f_ys_ysrq timestamp(6) NULL, -- 项目竣工验收日期
	f_box_type int2 NULL, -- 结果，1通过箱，2终止箱，3退回箱
	f_check_state varchar(16) NULL, -- 审核状态，0拟件，1待审核，2通过，3终止，4退回
	f_pid varchar(64) NULL, -- 退回整改关联ID
	f_state int2 NULL, -- 0 不可用  1 可用
	f_newattach int2 NULL, -- 0: 没有新附件，复用pid的附件   null值或者其他值表示新上传了酿热物包有新附件
	f_xzgd_shp_meta varchar(255) NULL, -- 新增耕地shp元信息
	f_xzgd_cord_count int4 NULL, -- 新增耕地坐标数量
	f_jzcnzb numeric(14, 4) NULL, -- 新增耕地-净增粮食产能
	f_tzgzcnzb numeric(14, 4) NULL, -- 提质改造-净增粮食产能
	f_lx_code varchar(100) NULL, -- 立项备案编号
	f_jgysdw varchar(255) NULL, -- 项目竣工验收单位
	f_bcstmj numeric(12, 4) NULL, -- 验收补充水田面积
	f_tzjzgdmj numeric(12, 4) NULL, -- 验收提质改造净耕地面积
	f_tzjzstmj numeric(12, 4) NULL, -- 验收提质改造净水田面积
	f_ysxzslzb numeric(12, 4) NULL, -- 验收新增数量指标
	f_ysxzstzb numeric(12, 4) NULL, -- 验收新增水田指标
	f_ysxzclzb numeric(12, 4) NULL, -- 验收新增产能指标
	f_rk_bcgdmj numeric(12, 4) NULL, -- 入库补充耕地面积
	f_rk_jzgdmj numeric(12, 4) NULL, -- 入库净增耕地面积
	f_rk_bcstmj numeric(12, 4) NULL, -- 入库补充水田面积
	f_rk_jzstmj numeric(12, 4) NULL, -- 入库净增水田面积
	f_rk_bcgdpjzldb numeric(12, 4) NULL, -- 入库新增耕地平均质量等别
	f_rk_jzcnzb numeric(12, 4) NULL, -- 入库净增产能指标
	f_rk_tzgzgdmj numeric(12, 4) NULL, -- 入库提质改造耕地面积
	f_rk_tzjzgdmj numeric(12, 4) NULL, -- 入库提质改造净耕地面积
	f_rk_tzgzstmj numeric(12, 4) NULL, -- 入库提质改造水田面积
	f_rk_tzjzstmj numeric(12, 4) NULL, -- 入库提质改造净水田面积
	f_rk_tzgzqzldb numeric(12, 4) NULL, -- 入库提质改造前耕地平均质量等别
	f_rk_tzgzhzldb numeric(12, 4) NULL, -- 入库提质改造后耕地平均质量等别
	f_rk_tzgzcnzb numeric(12, 4) NULL, -- 入库提质改造净产能指标
	f_rk_xzslzb numeric(12, 4) NULL, -- 入库新增数量指标
	f_rk_xzstzb numeric(12, 4) NULL, -- 入库新增水田指标
	f_rk_xzclzb numeric(12, 4) NULL, -- 入库新增产能指标
	f_iswy int2 NULL, -- 是否执行过外业核查：0无外业成果，1有外业成果
	f_username varchar(64) NULL, -- 填报人姓名
	f_usertel varchar(50) NULL, -- 填报人电话
	f_bz text NULL, -- 备注
	f_update_time timestamp NULL, -- 操作时间
	f_finish_time timestamp NULL, -- 完成时间
	f_processstatestr varchar(64) NULL, -- 流程状态描述
	f_processstate varchar(64) NULL, -- 流程状态
	f_xmxzqdm varchar(32) NULL, -- 项目行政区代码
	f_xmxzqmc varchar(64) NULL, -- 项目行政区名称
	CONSTRAINT tb_zbph_bcgdys_xmxx_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_type IS '项目类型';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xzqmc IS '项目所在地';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xmbh IS '验收备案编号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_create_time IS '创建时间';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_userid IS '创建人ID';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_processid IS '流程实例ID';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xmzgbm IS '项目主管部门';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_pf_pfwh IS '项目立项批复文号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ys_yswh IS '项目竣工验收文号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_jgysfzr IS '项目竣工验收负责人';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_bcgdmj IS '补充耕地面积（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_jzgdmj IS '净增耕地面积（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_jzstmj IS '净增水田面积（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_bcgdpjzldb IS '补充耕地平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ys_gm_zgm IS '项目建设总规模（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzgzgdmj IS '提质改造耕地面积（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzgzstmj IS '提质改造水田面积（公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzgzqzldb IS '提质改造前平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzgzhzldb IS '提质改造后平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ys_tz_ztz IS '项目总投资（万元）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_pf_pfrq IS '项目立项批复日期';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ys_ysrq IS '项目竣工验收日期';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_box_type IS '结果，1通过箱，2终止箱，3退回箱';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_check_state IS '审核状态，0拟件，1待审核，2通过，3终止，4退回';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_pid IS '退回整改关联ID';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_state IS '0 不可用  1 可用';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_newattach IS '0: 没有新附件，复用pid的附件   null值或者其他值表示新上传了酿热物包有新附件';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xzgd_shp_meta IS '新增耕地shp元信息';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xzgd_cord_count IS '新增耕地坐标数量';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_jzcnzb IS '新增耕地-净增粮食产能';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzgzcnzb IS '提质改造-净增粮食产能';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_lx_code IS '立项备案编号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_jgysdw IS '项目竣工验收单位';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_bcstmj IS '验收补充水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzjzgdmj IS '验收提质改造净耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_tzjzstmj IS '验收提质改造净水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ysxzslzb IS '验收新增数量指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ysxzstzb IS '验收新增水田指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_ysxzclzb IS '验收新增产能指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_bcgdmj IS '入库补充耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_jzgdmj IS '入库净增耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_bcstmj IS '入库补充水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_jzstmj IS '入库净增水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_bcgdpjzldb IS '入库新增耕地平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_jzcnzb IS '入库净增产能指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzgzgdmj IS '入库提质改造耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzjzgdmj IS '入库提质改造净耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzgzstmj IS '入库提质改造水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzjzstmj IS '入库提质改造净水田面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzgzqzldb IS '入库提质改造前耕地平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzgzhzldb IS '入库提质改造后耕地平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_tzgzcnzb IS '入库提质改造净产能指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_xzslzb IS '入库新增数量指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_xzstzb IS '入库新增水田指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_rk_xzclzb IS '入库新增产能指标';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_iswy IS '是否执行过外业核查：0无外业成果，1有外业成果';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_username IS '填报人姓名';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_usertel IS '填报人电话';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_update_time IS '操作时间';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_finish_time IS '完成时间';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_processstatestr IS '流程状态描述';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_processstate IS '流程状态';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xmxzqdm IS '项目行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmxx.f_xmxzqmc IS '项目行政区名称';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30101', 'tb_zbph_bcgdys_xmxx', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30102', 'tb_zbph_bcgdys_xmxx', 'f_type', '项目类型', 0, 'varchar', 50, NULL, 0, '', '', '', 2, '8', NULL, 0, NULL, '{"Z":"自然资源部整治项目","G":"农业农村部高标准农田项目","J":"增减挂钩结余指标项目","Q":"其他项目"}', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30103', 'tb_zbph_bcgdys_xmxx', 'f_xmmc', '项目名称', 0, 'varchar', 100, NULL, 0, '', '', '', 3, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30104', 'tb_zbph_bcgdys_xmxx', 'f_xzqmc', '项目所在地', 0, 'varchar', 255, NULL, 0, '', '', '', 5, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30105', 'tb_zbph_bcgdys_xmxx', 'f_xmbh', '验收备案编号', 0, 'varchar', 100, NULL, 0, '', '', '', 6, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30106', 'tb_zbph_bcgdys_xmxx', 'f_create_time', '创建时间', 0, 'timestamp', 6, NULL, 0, 'currentTime', '', '', 4, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30107', 'tb_zbph_bcgdys_xmxx', 'f_userid', '创建人ID', 0, 'varchar', 64, NULL, 0, 'currentUser', '', '', 7, '8', NULL, NULL, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30108', 'tb_zbph_bcgdys_xmxx', 'f_processid', '流程ID', 0, 'varchar', 64, NULL, 0, '', '', '', 8, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30109', 'tb_zbph_bcgdys_xmxx', 'f_xzqdm', '行政区代码', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '8', NULL, NULL, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30110', 'tb_zbph_bcgdys_xmxx', 'f_xmzgbm', '项目主管部门', 0, 'varchar', 50, NULL, 0, '', '', '', 10, '8', NULL, NULL, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30111', 'tb_zbph_bcgdys_xmxx', 'f_pf_pfwh', '项目立项批复文号', 0, 'varchar', 255, NULL, 0, '', '', '', 12, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30112', 'tb_zbph_bcgdys_xmxx', 'f_ys_yswh', '项目竣工验收文号', 0, 'varchar', 255, NULL, 0, '', '', '', 14, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30113', 'tb_zbph_bcgdys_xmxx', 'f_jgysfzr', '项目竣工验收负责人', 0, 'varchar', 255, NULL, 0, '', '', '', 15, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30114', 'tb_zbph_bcgdys_xmxx', 'f_bcgdmj', '补充耕地面积（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 17, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30115', 'tb_zbph_bcgdys_xmxx', 'f_jzgdmj', '净增耕地面积（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 18, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30116', 'tb_zbph_bcgdys_xmxx', 'f_jzstmj', '净增水田面积（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 19, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30117', 'tb_zbph_bcgdys_xmxx', 'f_bcgdpjzldb', '补充耕地平均质量等别', 0, 'varchar', 255, NULL, 0, '', '', '', 20, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30118', 'tb_zbph_bcgdys_xmxx', 'f_ys_gm_zgm', '项目建设总规模（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 21, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30119', 'tb_zbph_bcgdys_xmxx', 'f_tzgzgdmj', '提质改造耕地面积（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 22, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30120', 'tb_zbph_bcgdys_xmxx', 'f_tzgzstmj', '提质改造水田面积（公顷）', 0, 'numeric', 12, NULL, 0, '', '', '', 23, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30121', 'tb_zbph_bcgdys_xmxx', 'f_tzgzqzldb', '提质改造前平均质量等别', 0, 'varchar', 255, NULL, 0, '', '', '', 24, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30122', 'tb_zbph_bcgdys_xmxx', 'f_tzgzhzldb', '提质改造后平均质量等别', 0, 'varchar', 255, NULL, 0, '', '', '', 25, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30123', 'tb_zbph_bcgdys_xmxx', 'f_ys_tz_ztz', '项目总投资（万元）', 0, 'numeric', 12, NULL, 0, '', '', '', 26, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30124', 'tb_zbph_bcgdys_xmxx', 'f_pf_pfrq', '项目立项批复日期', 0, 'timestamp', 6, NULL, 0, '', '', '', 11, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30125', 'tb_zbph_bcgdys_xmxx', 'f_ys_ysrq', '项目竣工验收日期', 0, 'timestamp', 6, NULL, 0, '', '', '', 13, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30126', 'tb_zbph_bcgdys_xmxx', 'f_box_type', '结果', 0, 'int2', 16, NULL, 0, '', '', '', 27, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30127', 'tb_zbph_bcgdys_xmxx', 'f_check_state', '项目状态', 0, 'varchar', 16, NULL, 0, 'p0', '', '', 28, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30128', 'tb_zbph_bcgdys_xmxx', 'f_pid', '退回整改关联ID', 0, 'varchar', 64, NULL, 0, '', '', '', 32, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30129', 'tb_zbph_bcgdys_xmxx', 'f_state', '分析状态', 0, 'int2', 10, NULL, 0, '1', '', '', 6, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30130', 'tb_zbph_bcgdys_xmxx', 'f_newattach', '整改项目 是否上传了新附件', 0, 'int2', 10, NULL, 0, '', '', '', 6, '8', NULL, NULL, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30131', 'tb_zbph_bcgdys_xmxx', 'f_xzgd_shp_meta', '新增耕地shp元信息', 0, 'varchar', 255, NULL, 0, '', '', '', 36, '8', NULL, 0, NULL, '', 0, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30132', 'tb_zbph_bcgdys_xmxx', 'f_xzgd_cord_count', '新增耕地shp坐标数', 0, 'int4', 32, NULL, 0, '', '', '', 37, '8', NULL, 0, NULL, '', 0, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30133', 'tb_zbph_bcgdys_xmxx', 'f_jzcnzb', '新增耕地-净增粮食产能', 0, 'numeric', 12, NULL, 0, '', '', '', 53, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30134', 'tb_zbph_bcgdys_xmxx', 'f_tzgzcnzb', '提质改造-净增粮食产能', 0, 'numeric', 12, NULL, 0, '', '', '', 53, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30135', 'tb_zbph_bcgdys_xmxx', 'f_lx_code', '立项备案编号', 0, 'varchar', 100, NULL, 0, '', '', '', 39, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30136', 'tb_zbph_bcgdys_xmxx', 'f_jgysdw', '项目竣工验收单位', 0, 'varchar', 255, NULL, 0, '', '', '', 40, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30137', 'tb_zbph_bcgdys_xmxx', 'f_bcstmj', '验收补充水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 41, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30138', 'tb_zbph_bcgdys_xmxx', 'f_tzjzgdmj', '验收提质改造净耕地面积', 0, 'numeric', 12, NULL, 0, '', '', '', 42, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30139', 'tb_zbph_bcgdys_xmxx', 'f_tzjzstmj', '验收提质改造净水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 43, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30140', 'tb_zbph_bcgdys_xmxx', 'f_ysxzslzb', '验收新增数量指标', 0, 'numeric', 12, NULL, 0, '', '', '', 44, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30141', 'tb_zbph_bcgdys_xmxx', 'f_ysxzstzb', '验收新增水田指标', 0, 'numeric', 12, NULL, 0, '', '', '', 45, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30142', 'tb_zbph_bcgdys_xmxx', 'f_ysxzclzb', '验收新增产能指标', 0, 'numeric', 12, NULL, 0, '', '', '', 46, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30143', 'tb_zbph_bcgdys_xmxx', 'f_rk_bcgdmj', '入库补充耕地面积', 0, 'numeric', 12, NULL, 0, '', '', '', 47, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30144', 'tb_zbph_bcgdys_xmxx', 'f_rk_jzgdmj', '入库净增耕地面积', 0, 'numeric', 12, NULL, 0, '', '', '', 48, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30145', 'tb_zbph_bcgdys_xmxx', 'f_rk_bcstmj', '入库补充水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 49, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30146', 'tb_zbph_bcgdys_xmxx', 'f_rk_jzstmj', '入库净增水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 50, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30147', 'tb_zbph_bcgdys_xmxx', 'f_rk_bcgdpjzldb', '入库新增耕地平均质量等别', 0, 'numeric', 12, NULL, 0, '', '', '', 51, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30148', 'tb_zbph_bcgdys_xmxx', 'f_rk_jzcnzb', '入库净增产能指标', 0, 'numeric', 12, NULL, 0, '', '', '', 52, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30149', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzgzgdmj', '入库提质改造耕地面积', 0, 'numeric', 12, NULL, 0, '', '', '', 53, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30150', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzjzgdmj', '入库提质改造净耕地面积', 0, 'numeric', 12, NULL, 0, '', '', '', 54, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30151', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzgzstmj', '入库提质改造水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 55, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30152', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzjzstmj', '入库提质改造净水田面积', 0, 'numeric', 12, NULL, 0, '', '', '', 56, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30153', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzgzqzldb', '入库提质改造前耕地平均质量等别', 0, 'numeric', 12, NULL, 0, '', '', '', 57, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30154', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzgzhzldb', '入库提质改造后耕地平均质量等别', 0, 'numeric', 12, NULL, 0, '', '', '', 58, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30155', 'tb_zbph_bcgdys_xmxx', 'f_rk_tzgzcnzb', '入库提质改造净产能指标', 0, 'numeric', 12, NULL, 0, '', '', '', 59, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30156', 'tb_zbph_bcgdys_xmxx', 'f_rk_xzslzb', '入库新增数量指标', 0, 'numeric', 12, NULL, 0, '', '', '', 60, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30157', 'tb_zbph_bcgdys_xmxx', 'f_rk_xzstzb', '入库新增水田指标', 0, 'numeric', 12, NULL, 0, '', '', '', 61, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30158', 'tb_zbph_bcgdys_xmxx', 'f_rk_xzclzb', '入库新增产能指标', 0, 'numeric', 12, NULL, 0, '', '', '', 62, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30159', 'tb_zbph_bcgdys_xmxx', 'f_iswy', '是否外业核查过', 0, 'int2', 16, NULL, 0, '0', '', '', 63, '8', NULL, 0, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30160', 'tb_zbph_bcgdys_xmxx', 'f_username', '填报人姓名', 0, 'varchar', 64, NULL, 0, '', '', '', 33, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30161', 'tb_zbph_bcgdys_xmxx', 'f_usertel', '填报人电话', 0, 'varchar', 64, NULL, 0, '', '', '', 33, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30162', 'tb_zbph_bcgdys_xmxx', 'f_bz', '备注', 0, 'varchar', 10000, NULL, 0, '', '', '', 33, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30163', 'tb_zbph_bcgdys_xmxx', 'f_update_time', '操作时间', 0, 'timestamp', 6, NULL, 0, '', '', '', 11, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30164', 'tb_zbph_bcgdys_xmxx', 'f_finish_time', '完成时间', 0, 'timestamp', 6, NULL, 0, '', '', '', 11, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30165', 'tb_zbph_bcgdys_xmxx', 'f_processstatestr', '流程状态描述', 0, 'varchar', 64, NULL, 0, '', '', '', 33, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30166', 'tb_zbph_bcgdys_xmxx', 'f_processstate', '流程状态', 0, 'varchar', 64, NULL, 0, '', '', '', 33, '8', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30167', 'tb_zbph_bcgdys_xmxx', 'f_xmxzqdm', '项目所在行政区代码', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30168', 'tb_zbph_bcgdys_xmxx', 'f_xmxzqmc', '项目所在行政区', 0, 'varchar', 20, NULL, 0, '', '', '', 9, '6', NULL, 1, NULL, '', NULL, NULL, 1, NULL, NULL);


-- 验收项目范围空间表

CREATE TABLE tb_zbph_bcgdys_xmfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_project_id varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	xzqmc varchar(50) NULL, -- 行政区名称
	xzqdm varchar(50) NULL, -- 行政区代码
	f_objectid int4 NULL,
	f_jbxx_xmmc varchar(255) NULL, -- 基本信息_项目名称
	f_jbxx_xzqmc varchar(255) NULL, -- 基本信息_行政区名称
	f_jbxx_xzqdm varchar(255) NULL, -- 行政区代码
	f_ys_xmbh varchar(255) NULL, -- 项目编号
	f_xmlx varchar(50) NULL, -- 项目类型
	f_dkmj numeric NULL, -- 面积
	f_shp_name varchar(255) NULL, -- shp文件名
	f_jzds int2 NULL, -- 界址点数
	f_dkbh varchar(200) NULL, -- 地块编号
	f_dkmc varchar(200) NULL, -- 地块名称
	f_txsx varchar(32) NULL, -- 图形属性
	f_tfh varchar(200) NULL, -- 图幅号
	f_dkyt varchar(200) NULL, -- 地块用途
	f_bz varchar(200) NULL, -- 备注
	CONSTRAINT tb_zbph_bcgdys_xmxx_xmfw_pkey PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_bcgdys_xmxx_xmfw_shpae_index ON public.tb_zbph_bcgdys_xmfw USING gist (f_shape);
COMMENT ON TABLE public.tb_zbph_bcgdys_xmfw IS '验收项目范围空间表';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_project_id IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_jbxx_xmmc IS '基本信息_项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_jbxx_xzqmc IS '基本信息_行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_jbxx_xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_ys_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_xmlx IS '项目类型';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_dkmj IS '面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_shp_name IS 'shp文件名';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_jzds IS '界址点数';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_dkbh IS '地块编号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_tfh IS '图幅号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_dkyt IS '地块用途';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xmfw.f_bz IS '备注';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30201', 'tb_zbph_bcgdys_xmfw', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30202', 'tb_zbph_bcgdys_xmfw', 'f_project_id', '项目ID', 1, 'varchar', 64, NULL, 0, '', '', '', 3, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30203', 'tb_zbph_bcgdys_xmfw', 'f_shape', '项目范围', 1, 'geometry', NULL, NULL, 0, '', '', '', 2, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30204', 'tb_zbph_bcgdys_xmfw', 'xzqmc', '行政区名称', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30205', 'tb_zbph_bcgdys_xmfw', 'xzqdm', '行政区代码', 0, 'varchar', 50, NULL, 0, '', '', '', 5, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30206', 'tb_zbph_bcgdys_xmfw', 'f_objectid', '序号', 0, 'int4', 32, NULL, 0, '', '', '', 6, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30207', 'tb_zbph_bcgdys_xmfw', 'f_jbxx_xmmc', '基本信息_项目名称', 0, 'varchar', 255, NULL, 0, '', '', '', 7, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30208', 'tb_zbph_bcgdys_xmfw', 'f_jbxx_xzqmc', '基本信息_行政区名称', 0, 'varchar', 255, NULL, 0, '', '', '', 8, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30209', 'tb_zbph_bcgdys_xmfw', 'f_jbxx_xzqdm', '基本信息_行政区代码', 0, 'varchar', 255, NULL, 0, '', '', '', 9, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30210', 'tb_zbph_bcgdys_xmfw', 'f_ys_xmbh', '项目编号', 0, 'varchar', 255, NULL, 0, '', '', '', 10, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30211', 'tb_zbph_bcgdys_xmfw', 'f_xmlx', '项目类型', 0, 'varchar', 50, NULL, 0, '', '', '', 11, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30212', 'tb_zbph_bcgdys_xmfw', 'f_shp_name', 'shp文件名', 0, 'varchar', 255, NULL, 0, '', '', '', 12, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30213', 'tb_zbph_bcgdys_xmfw', 'f_dkmj', '面积', 0, 'numeric', 0, NULL, 0, '', '', '', 13, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30214', 'tb_zbph_bcgdys_xmfw', 'f_jzds', '界址点数', 0, 'int4', 16, NULL, 0, '', '', '', 14, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30215', 'tb_zbph_bcgdys_xmfw', 'f_dkbh', '地块编号', 0, 'varchar', 200, NULL, 0, '', '', '', 15, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30216', 'tb_zbph_bcgdys_xmfw', 'f_dkmc', '地块名称', 0, 'varchar', 200, NULL, 0, '', '', '', 16, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30217', 'tb_zbph_bcgdys_xmfw', 'f_txsx', '图形属性', 0, 'varchar', 32, NULL, 0, '', '', '', 17, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30218', 'tb_zbph_bcgdys_xmfw', 'f_tfh', '图幅号', 0, 'varchar', 200, NULL, 0, '', '', '', 18, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30219', 'tb_zbph_bcgdys_xmfw', 'f_dkyt', '地块用途', 0, 'varchar', 200, NULL, 0, '', '', '', 19, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30220', 'tb_zbph_bcgdys_xmfw', 'f_bz', '地块用途', 0, 'varchar', 200, NULL, 0, '', '', '', 20, '7', NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL);

-- 验收新增耕地范围空间表

CREATE TABLE tb_zbph_bcgdys_xzgdfw (
	f_id varchar(64) NOT NULL, -- 主键
	f_project_id varchar(64) NULL, -- 项目ID
	f_shape public.geometry(geometry, 4490) NULL, -- 图斑数据
	xzqmc varchar(50) NULL, -- 行政区名称
	xzqdm varchar(50) NULL, -- 行政区代码
	f_ys_xmbh varchar(255) NULL, -- 项目编号
	f_jbxx_xmmc varchar(255) NULL, -- 项目名称
	f_objectid int4 NULL,
	f_dkbh varchar(50) NULL, -- 地块号
	f_dkmc varchar(255) NULL, -- 地块名称
	f_dkmj numeric NULL, -- 地块面积（默认单位：公顷）
	f_dkyt varchar(255) NULL, -- 用途
	f_tfh varchar(255) NULL, -- 图幅号（多个图幅号之间不能出现空格，通过顿号进行分割）
	f_tblx varchar(50) NULL, -- 图斑类型（新增、提质、改造、提质改造）
	f_dlbm varchar(50) NULL, -- 地类（水田、水浇地、旱地）
	f_gzqpjzldb varchar(50) NULL, -- 耕地平均质量等别（改造前平均质量等别）
	f_gzhpjzldb varchar(50) NULL, -- 改造后平均质量等别
	f_shp_name varchar(255) NULL, -- shp文件名
	f_yuliu varchar(255) NULL, -- 预留字段
	f_txsx varchar(32) NULL, -- 图形属性
	f_xzgdmj numeric NULL, -- 新增耕地面积
	f_xzstmj numeric NULL, -- 新增水田面积
	CONSTRAINT "bcgdys_bcgdfw-proid-dkno" UNIQUE (f_project_id, f_dkbh),
	CONSTRAINT tb_zbph_bcgdys_bcgdfw_pkey1 PRIMARY KEY (f_id)
);
CREATE INDEX tb_zbph_bcgdys_bcgdfw_shape_idx ON public.tb_zbph_bcgdys_xzgdfw USING gist (f_shape);

-- Column comments

COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_id IS '主键';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_project_id IS '项目ID';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_shape IS '图斑数据';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.xzqmc IS '行政区名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.xzqdm IS '行政区代码';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_ys_xmbh IS '项目编号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_jbxx_xmmc IS '项目名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_dkbh IS '地块号';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_dkmc IS '地块名称';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_dkmj IS '地块面积（默认单位：公顷）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_dkyt IS '用途';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_tfh IS '图幅号（多个图幅号之间不能出现空格，通过顿号进行分割）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_tblx IS '图斑类型（新增、提质、改造、提质改造）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_dlbm IS '地类（水田、水浇地、旱地）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_gzqpjzldb IS '耕地平均质量等别（改造前平均质量等别）';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_gzhpjzldb IS '改造后平均质量等别';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_shp_name IS 'shp文件名';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_yuliu IS '预留字段';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_txsx IS '图形属性';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_xzgdmj IS '新增耕地面积';
COMMENT ON COLUMN public.tb_zbph_bcgdys_xzgdfw.f_xzstmj IS '新增水田面积';

INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30301', 'tb_zbph_bcgdys_xzgdfw', 'f_id', '主键', 1, 'varchar', 64, NULL, 0, 'uuid', '', '', 1, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30302', 'tb_zbph_bcgdlx_xzgdfw', 'f_ys_xmbh', '项目编号', 0, 'varchar', 255, NULL, 0, '', '', '', 6, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30303', 'tb_zbph_bcgdlx_xzgdfw', 'f_objectid', '序号', 0, 'int4', 32, NULL, 0, '', '', '', 8, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30304', 'tb_zbph_bcgdlx_xzgdfw', 'f_shp_name', 'shp文件名', 0, 'varchar', 255, NULL, 0, '', '', '', 18, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30305', 'tb_zbph_bcgdlx_xzgdfw', 'f_tblx', '图斑类型', 0, 'varchar', 50, NULL, 0, '', '', '', 14, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30306', 'tb_zbph_bcgdlx_xzgdfw', 'f_dlbm', '地类', 0, 'varchar', 50, NULL, 0, '', '', '', 15, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30307', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkbh', '地块号', 0, 'varchar', 50, NULL, 0, '', '', '', 9, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30308', 'tb_zbph_bcgdlx_xzgdfw', 'f_shape', '图斑数据', 0, 'geometry', 0, NULL, 0, '', '', '', 3, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30309', 'tb_zbph_bcgdlx_xzgdfw', 'xzqdm', '行政区代码', 0, 'varchar', 50, NULL, 0, '', '', '', 5, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30310', 'tb_zbph_bcgdlx_xzgdfw', 'f_jbxx_xmmc', '项目名称', 0, 'varchar', 255, NULL, 0, '', '', '', 7, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30311', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkmc', '地块名称', 0, 'varchar', 255, NULL, 0, '', '', '', 10, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30312', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkyt', '用途', 0, 'varchar', 255, NULL, 0, '', '', '', 12, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30313', 'tb_zbph_bcgdlx_xzgdfw', 'f_tfh', '图幅号', 0, 'varchar', 255, NULL, 0, '', '', '', 13, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30314', 'tb_zbph_bcgdlx_xzgdfw', 'f_dkmj', '地块面积', 0, 'numeric', 0, NULL, 0, '', '', '', 11, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30315', 'tb_zbph_bcgdlx_xzgdfw', 'f_gzhpjzldb', '改造后平均质量等别', 0, 'varchar', 50, NULL, 0, '', '', '', 17, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30316', 'tb_zbph_bcgdlx_xzgdfw', 'f_project_id', '项目ID', 0, 'varchar', 64, NULL, 0, '', '', '', 2, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30317', 'tb_zbph_bcgdlx_xzgdfw', 'xzqmc', '行政区名称', 0, 'varchar', 50, NULL, 0, '', '', '', 4, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30318', 'tb_zbph_bcgdlx_xzgdfw', 'f_yuliu', '预留', 0, 'varchar', 200, NULL, 0, '', '', '', 19, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30319', 'tb_zbph_bcgdlx_xzgdfw', 'f_gzqpjzldb', '耕地平均质量等别（改造前平均质量等别）', 0, 'varchar', 50, NULL, 0, '', '', '', 16, '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30320', 'tb_zbph_bcgdlx_xzgdfw', 'f_xzgdmj', '新增耕地面积', 0, 'numeric', 0, NULL, 0, '', '', '', 20, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tb_model_fields (f_id, f_tablename, f_fieldname, f_alias, f_isprimary, f_fieldtype, f_length, f_precision, f_nullable, f_defaultvalue, f_codetableid, f_remark, f_order, f_tableid, f_isbase, f_islistshow, f_iswebedit, f_metainfo, f_displaytype, f_unique, f_ismust, f_diclevel, f_ischopredic) VALUES('30321', 'tb_zbph_bcgdlx_xzgdfw', 'f_xzstmj', '新增水田面积', 0, 'numeric', 0, NULL, 0, '', '', '', 20, '22', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
