/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.domain.gus;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserInfo
implements Serializable {
    private static String SEPARATOR = ",";
    protected String userId;
    protected String userName;
    protected String roles;
    protected String alias;
    protected String regionCode;
    protected String regionName;

    public boolean checkRole(String role) {
        if (StringUtils.isEmpty((CharSequence)role)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.roles)) {
            String[] checkArr = role.split(SEPARATOR);
            String[] containerArr = this.roles.split(SEPARATOR);
            HashSet<String> set = new HashSet<String>(Arrays.asList(checkArr));
            set.retainAll(Arrays.asList(containerArr));
            return set.size() > 0;
        }
        return false;
    }

    public boolean checkRegion(String regionReg) {
        if (StringUtils.isEmpty((CharSequence)regionReg)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)this.regionCode)) {
            return false;
        }
        Pattern r = Pattern.compile(regionReg);
        Matcher m = r.matcher(this.regionCode);
        return m.matches();
    }

    public boolean checkUser(String user) {
        if (StringUtils.isEmpty((CharSequence)user)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.userId)) {
            String[] userArr = user.split(SEPARATOR);
            return Arrays.asList(userArr).contains(this.userId);
        }
        return false;
    }

    public boolean check() {
        return !StringUtils.isEmpty((CharSequence)this.userId);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoles() {
        return this.roles;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$roles = this.getRoles();
        String other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !this$roles.equals(other$roles)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        String this$regionName = this.getRegionName();
        String other$regionName = other.getRegionName();
        return !(this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : $roles.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        String $regionName = this.getRegionName();
        result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
        return result;
    }

    public String toString() {
        return "UserInfo(userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", roles=" + this.getRoles() + ", alias=" + this.getAlias() + ", regionCode=" + this.getRegionCode() + ", regionName=" + this.getRegionName() + ")";
    }
}

