/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.domain.gus;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geoway.stxf.domain.gus.MenuAction;
import com.geoway.stxf.domain.gus.MenuCatalog;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@DynamicInsert
@DynamicUpdate
@EntityListeners(value={AuditingEntityListener.class})
@ApiModel(value="gus_menu_obj", description="\u83dc\u5355\u5b9e\u4f53")
@Table(name="gus_menu_obj")
@JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer", "fieldHandler", "catalog", "actions", "userid", "roleid"})
public class Menu
implements Serializable {
    private static final long serialVersionUID = 7805286727803927444L;
    @Id
    @GenericGenerator(name="idGenerator", strategy="com.geoway.base.support.SnowFlakeIdGenerator")
    @GeneratedValue(generator="idGenerator")
    @Column(name="ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="catalog")
    private MenuCatalog catalog;
    @Column(name="NAME")
    private String name;
    @Column(name="CODE")
    private String code;
    @Column(name="TYPE")
    private Integer type;
    @Column(name="PARID")
    private Long parid;
    @Column(name="SORT")
    private Integer sort;
    @Column(name="ICON")
    private String icon;
    @ApiModelProperty(value="0:\u4e0d\u53ef\u7528  1\uff1a\u53ef\u7528")
    @Column(name="STATE")
    private Integer state;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.MERGE}, mappedBy="menu")
    @OrderBy(value="id asc")
    private List<MenuAction> actions;
    @ApiModelProperty(value="\u7ed1\u5b9a\u7684\u7528\u6237id")
    @Column(name="USERID")
    private String userid;
    @ApiModelProperty(value="\u7ed1\u5b9a\u7684\u89d2\u8272id")
    @Column(name="ROLEID")
    private String roleid;
    @ApiModelProperty(value="\u7ed1\u5b9a\u7684\u533a\u57df\u7f16\u7801\u6b63\u5219")
    @Column(name="REGION")
    private String region;
    @Transient
    private Map props;
    @Transient
    protected List<Menu> children = new ArrayList<Menu>();

    public Map getProps() {
        HashMap<String, String> map = new HashMap<String, String>();
        int size = this.actions.size();
        for (int i = 0; i < size; ++i) {
            MenuAction action = this.actions.get(i);
            String code = action.getCode();
            String value = action.getValue();
            map.put(code, value);
        }
        return map;
    }

    public void setProps(Map props) {
        this.props = props;
    }

    public Long getId() {
        return this.id;
    }

    public MenuCatalog getCatalog() {
        return this.catalog;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getType() {
        return this.type;
    }

    public Long getParid() {
        return this.parid;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getIcon() {
        return this.icon;
    }

    public Integer getState() {
        return this.state;
    }

    public List<MenuAction> getActions() {
        return this.actions;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getRoleid() {
        return this.roleid;
    }

    public String getRegion() {
        return this.region;
    }

    public List<Menu> getChildren() {
        return this.children;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCatalog(MenuCatalog catalog) {
        this.catalog = catalog;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setParid(Long parid) {
        this.parid = parid;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setActions(List<MenuAction> actions) {
        this.actions = actions;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setRoleid(String roleid) {
        this.roleid = roleid;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Menu)) {
            return false;
        }
        Menu other = (Menu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        MenuCatalog this$catalog = this.getCatalog();
        MenuCatalog other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Long this$parid = this.getParid();
        Long other$parid = other.getParid();
        if (this$parid == null ? other$parid != null : !((Object)this$parid).equals(other$parid)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        List<MenuAction> this$actions = this.getActions();
        List<MenuAction> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        String this$userid = this.getUserid();
        String other$userid = other.getUserid();
        if (this$userid == null ? other$userid != null : !this$userid.equals(other$userid)) {
            return false;
        }
        String this$roleid = this.getRoleid();
        String other$roleid = other.getRoleid();
        if (this$roleid == null ? other$roleid != null : !this$roleid.equals(other$roleid)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        Map this$props = this.getProps();
        Map other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        List<Menu> this$children = this.getChildren();
        List<Menu> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Menu;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        MenuCatalog $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Long $parid = this.getParid();
        result = result * 59 + ($parid == null ? 43 : ((Object)$parid).hashCode());
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        List<MenuAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        String $userid = this.getUserid();
        result = result * 59 + ($userid == null ? 43 : $userid.hashCode());
        String $roleid = this.getRoleid();
        result = result * 59 + ($roleid == null ? 43 : $roleid.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        Map $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        List<Menu> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "Menu(id=" + this.getId() + ", catalog=" + this.getCatalog() + ", name=" + this.getName() + ", code=" + this.getCode() + ", type=" + this.getType() + ", parid=" + this.getParid() + ", sort=" + this.getSort() + ", icon=" + this.getIcon() + ", state=" + this.getState() + ", actions=" + this.getActions() + ", userid=" + this.getUserid() + ", roleid=" + this.getRoleid() + ", region=" + this.getRegion() + ", props=" + this.getProps() + ", children=" + this.getChildren() + ")";
    }
}

