package com.geoway.schedulerstart;


import com.geoway.atlas.license.authorize.LicenseCheck;
import com.geoway.web.listener.LoadMessageListener;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableCaching
@EnableScheduling
@ServletComponentScan(basePackages = "com.geoway.web.config")
@ComponentScan({"com.geoway.base","com.geoway.web","com.geoway.onemap","com.geoway.stxf","com.geoway.zhgd","com.geoway.schedual"})
@SpringBootApplication
public class SchedulerApplication {
    public static void main(String[] args) {
        SpringApplication app=new SpringApplication(SchedulerApplication.class);
        try {
            LicenseCheck.isValid(65040);
        } catch (Exception ex) {
            throw new RuntimeException("系统未授权，不能启动，请联系管理员");
        }
        app.addListeners(new LoadMessageListener(" 占补平衡定时任务"));
        app.run(args);
    }
}
