/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.supoort.GtyYnApiUtil;
import com.geoway.schedual.service.BusinessVerifyService;
import com.geoway.schedual.service.impl.AbstracGtyVerifyServiceImpl;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty-yn")
public class GtyYnVerifyServiceImpl
extends AbstracGtyVerifyServiceImpl
implements BusinessVerifyService {
    @Autowired
    private GtyYnApiUtil gtyYnApiUtil;
    @Autowired
    private IBaseFileDao baseFileDao;

    @Override
    public void start() {
        this.startVerify();
    }

    @Override
    public boolean syncTb(String bsm, String dkid, String xmjd) {
        return false;
    }

    @Override
    public void manageInfo(String importId, List<OutCheckGty> gtyList) {
        JSONObject object = this.gtyYnApiUtil.httpGetInfo(importId);
        Integer uploadCount = object.getInteger("uploadCount");
        Integer succeedCount = object.getInteger("succeedCount");
        if (succeedCount != uploadCount) {
            gtyList.forEach(f -> {
                f.setState(Integer.valueOf(3));
                f.setRemark(object.getString("failNote"));
                f.setUpdateTime(new Date());
            });
        } else {
            OutCheckGty gty = gtyList.get(0);
            JSONArray array = this.gtyYnApiUtil.httpGetSuccess(importId, gty.getXmjd());
            if (array.size() == succeedCount.intValue()) {
                List ids = array.toJavaList(String.class);
                List<OutCheckGty> collect = gtyList.stream().filter(f -> ids.contains(f.getBsm())).collect(Collectors.toList());
                collect.forEach(f -> {
                    try {
                        f.setState(Integer.valueOf(2));
                        f.setUpdateTime(new Date());
                        this.manageGtyList((OutCheckGty)f, importId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException();
                    }
                });
                this.outCheckGtyDao.saveAll(collect);
            }
        }
    }

    @Override
    public Boolean isComplete(List<OutCheckGty> gtyList) {
        boolean unSuccess = gtyList.stream().anyMatch(f -> f.getState() == 1);
        return !unSuccess;
    }

    private void manageGtyList(OutCheckGty gty, String logId) {
        String bsm = gty.getBsm();
        JSONArray medias = this.gtyYnApiUtil.httpGetFj(logId, bsm, gty.getXmjd());
        if (medias.size() > 0) {
            String dkId = gty.getDkId();
            Date now = new Date();
            ArrayList<BaseFile> baseFiles = new ArrayList<BaseFile>();
            for (Object media : medias) {
                JSONObject mediaRs = (JSONObject)media;
                int fjlx = mediaRs.getInteger("fileType");
                String rowKey = mediaRs.getString("rowKey");
                String fjmc = mediaRs.getString("fjmc");
                try {
                    Map<String, String> header = this.getHeader();
                    String url = this.gtyYnApiUtil.downloadUrl + "/streams/v1/" + this.gtyYnApiUtil.downloadIndex + "/" + rowKey + "/_stream/first";
                    this.downloadFj(url, "yn", dkId, fjmc, header);
                }
                catch (Exception e) {
                    System.out.println("\u3010" + gty.getId() + "\u3011\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
                    continue;
                }
                BaseFile baseFile = new BaseFile();
                baseFiles.add(baseFile);
                baseFile.setRelationId(dkId);
                baseFile.setUploadTime(now);
                if (fjlx == 1) {
                    baseFile.setMediaType("ZP");
                    baseFile.setFileType(Integer.valueOf(1));
                    this.setMetaData(baseFile, mediaRs);
                } else if (fjlx == 2) {
                    baseFile.setMediaType("SP");
                    baseFile.setFileType(Integer.valueOf(3));
                    this.setMetaData(baseFile, mediaRs);
                } else {
                    baseFile.setMediaType("FJ");
                    baseFile.setFileType(Integer.valueOf(4));
                }
                baseFile.setFileName(fjmc);
                baseFile.setCreatePath(File.separator + "fruit" + File.separator + "yn" + File.separator + dkId + File.separator + fjmc);
                baseFile.setFileFormat(fjmc.substring(fjmc.lastIndexOf(".") + 1));
                String code = gty.getXmjd();
                baseFile.setRelationType(XmxxType.YS.type.equals(code) || XmxxType.YS.gtyType.equals(code) ? "CCJZ" : "JHJZ");
            }
            if (baseFiles.size() > 0) {
                this.baseFileDao.saveAll(baseFiles);
            }
        }
    }

    private void setMetaData(BaseFile baseFile, JSONObject mediaRs) {
        JSONObject metaData = new JSONObject();
        metaData.put("psjd", (Object)mediaRs.getDouble("psjd"));
        metaData.put("latitude", (Object)mediaRs.getDouble("lat"));
        metaData.put("longitude", (Object)mediaRs.getDouble("lon"));
        metaData.put("psry", (Object)mediaRs.getString("psry"));
        metaData.put("pssj", (Object)mediaRs.getString("pssj"));
        baseFile.setMetaData(metaData.toJSONString());
    }

    private Map<String, String> getHeader() {
        String auth = this.gtyYnApiUtil.downloadUserKey;
        byte[] encode = Base64.getEncoder().encode(auth.getBytes());
        String authorization = new String(encode);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + authorization);
        return headers;
    }

    protected static enum GtyYnStatuEnum {
        UPLOADING("\u4e0a\u4f20\u4e2d", 1),
        UPLOAD_FAIL("\u4e0a\u4f20\u5931\u8d25", 2),
        UPLOAD_SUCCEED("\u4e0a\u4f20\u6210\u529f", 3),
        INSERT_SUCCEED("\u5165\u5e93\u6210\u529f", 9),
        ROLLBACK("\u5df2\u5220\u9664", 10);

        protected String name;
        protected int value;

        private GtyYnStatuEnum(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }
}

