/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.HttpConnectionUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmxx;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.schedual.service.BusinessVerifyService;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.dao.OutCheckGtyDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty")
public class GtyVerifyServiceImpl
implements BusinessVerifyService {
    private final String GTY_TOKEN = "gty_token";
    @Value(value="${project.uploadDir}")
    private String uploadDir;
    @Value(value="${scheduler.outcheckgty.state}")
    private String outcheckgtyState;
    @Value(value="${project.gty.dir:''}")
    protected String gtyDir;
    @Value(value="${gty.base.url:'https://www.landcloud.org.cn:9553'}")
    protected String gtyUrl;
    @Value(value="${gty.store.url:'/mdc/v2/storage/tempurl'}")
    protected String gtyStore;
    @Value(value="${gty.token.url:'/mdc/v2/auth/tokenByKey'}")
    protected String gtyTokenUrl;
    @Value(value="${gty.import.log.url:'/mdc/v2/taskData/import/log'}")
    protected String importLog;
    @Value(value="${gty.queryresult.url:'/mdc/v2/taskData/queryDataDetail2'}")
    protected String queryResult;
    @Value(value="${gty.sign.url:'/mdc/v2/storage/signUrl'}")
    protected String signUrl;
    @Value(value="${gty.ak:'gwbe549e73-7d2b-4a5d-b090-450b22505ed0'}")
    protected String appKey;
    @Value(value="${gty.sk:'0a18f48-4f97-4559-9624-353752757dd2'}")
    protected String appSecret;
    @Value(value="${gty.bizId:'6c0f1af9-747a-4cc0-9652-4ae31ee3179f'}")
    protected String bizId;
    @Autowired
    private OutCheckGtyDao outCheckGtyDao;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private XfsbcgdLxXmxxService lxXmxxService;
    @Autowired
    private XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    private IBaseFileDao baseFileDao;
    @Autowired
    private ProcessInstanceService processInstanceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start() {
        if (!"true".equals(this.outcheckgtyState)) {
            return;
        }
        List outCheckGties = this.outCheckGtyDao.findByState(Integer.valueOf(1));
        if (outCheckGties.size() == 0) {
            return;
        }
        Map<String, List<OutCheckGty>> gtyGroup = outCheckGties.stream().collect(Collectors.groupingBy(OutCheckGty::getImportId));
        for (String importId : gtyGroup.keySet()) {
            JSONObject importResult = this.getImportResult(importId);
            Integer state = importResult.getInteger("state");
            if (state != 2 && state != 3) continue;
            List<OutCheckGty> gtyList = gtyGroup.get(importId);
            for (OutCheckGty outCheckGty : gtyList) {
                if (state == 2) {
                    try {
                        boolean result = this.parseOutResult(outCheckGty);
                        if (!result) continue;
                        outCheckGty.setState(Integer.valueOf(2));
                        outCheckGty.setUpdateTime(new Date());
                        this.outCheckGtyDao.save((Object)outCheckGty);
                    }
                    catch (Exception ex) {
                        outCheckGty.setState(Integer.valueOf(3));
                        outCheckGty.setRemark(ex.getLocalizedMessage());
                        outCheckGty.setUpdateTime(new Date());
                        this.outCheckGtyDao.save((Object)outCheckGty);
                    }
                    continue;
                }
                if (state != 3) continue;
                JSONObject result = importResult.getJSONObject("result");
                outCheckGty.setRemark(result.getString("detailError"));
                outCheckGty.setState(Integer.valueOf(3));
                this.outCheckGtyDao.save((Object)outCheckGty);
            }
        }
        Map<String, List<OutCheckGty>> projectGroup = outCheckGties.stream().collect(Collectors.groupingBy(OutCheckGty::getProjectId));
        for (String projectId : projectGroup.keySet()) {
            List<OutCheckGty> checkGties = projectGroup.get(projectId);
            OutCheckGty noChecked = checkGties.stream().filter(f -> f.getState() == 1).findAny().orElse(null);
            if (noChecked != null) continue;
            this.doFlow(checkGties.get(0).getXmjd(), checkGties.get(0).getProjectId());
        }
    }

    @Override
    public boolean syncTb(String bsm, String dkid, String xmjd) {
        return false;
    }

    private void doFlow(String code, String pid) {
        if (code.equals(XmxxType.LX.gtyType)) {
            XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(pid);
            SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
            this.lxXmxxService.pass(Arrays.asList(pid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
            xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(pid);
            xmxx.setIswy(Double.valueOf(1.0));
            this.lxXmxxService.saveOrUpdate((Object)xmxx, null);
        } else {
            XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(pid);
            SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
            this.ysXmxxService.pass(Arrays.asList(pid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
            xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(pid);
            xmxx.setIswy(Double.valueOf(1.0));
            this.ysXmxxService.saveOrUpdate((Object)xmxx, null);
        }
    }

    private SysUser getUser(String xzqdm, String name, String processId) {
        ProcessStep processStep = this.processInstanceService.getCurrentStep(processId);
        SysUser sysUser = new SysUser();
        sysUser.setAlisname(name);
        sysUser.setUsername(name);
        sysUser.setXzqdm(xzqdm);
        sysUser.setId(name);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        SimpleRole simpleRole = new SimpleRole();
        simpleRole.setRolename((String)processStep.getRelatedRoles().get(0));
        roles.add(simpleRole);
        sysUser.setRoles(roles);
        return sysUser;
    }

    public Boolean parseOutResult(OutCheckGty outCheckGty) throws Exception {
        JSONObject jsonObject = this.queryResult(outCheckGty.getBsm());
        JSONArray medias = jsonObject.getJSONArray("medias");
        if (medias.size() == 0) {
            return false;
        }
        String dkId = outCheckGty.getDkId();
        Date now = new Date();
        ArrayList<BaseFile> baseFiles = new ArrayList<BaseFile>();
        for (Object media : medias) {
            JSONObject mediaRs = (JSONObject)media;
            String serverPath = mediaRs.getString("serverpath");
            if (StringUtils.isBlank((CharSequence)serverPath)) {
                System.out.println("\u6210\u679c\u5730\u5740\u4e3a\u7a7a\uff1a" + mediaRs.toJSONString());
                continue;
            }
            serverPath = this.getSignUrl(serverPath);
            String[] serverPathSplit = serverPath.split("\\?")[0].split("/");
            String fileName = serverPathSplit[serverPathSplit.length - 1];
            String localFolder = this.uploadDir + "/fruit/" + dkId;
            new File(localFolder).mkdirs();
            HttpConnectionUtil.downLoadFromUrl((String)serverPath, (String)fileName, (String)localFolder);
            BaseFile baseFile = new BaseFile();
            baseFiles.add(baseFile);
            baseFile.setRelationId(dkId);
            baseFile.setUploadTime(now);
            int fjlx = mediaRs.getInteger("type");
            if (fjlx == 1) {
                baseFile.setMediaType("ZP");
                baseFile.setFileType(Integer.valueOf(1));
                JSONObject metaData = new JSONObject();
                metaData.put("psjd", (Object)mediaRs.getDouble("azimuth"));
                metaData.put("latitude", (Object)mediaRs.getDouble("lat"));
                metaData.put("longitude", (Object)mediaRs.getDouble("lon"));
                metaData.put("psry", (Object)mediaRs.getString("username"));
                String pssj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mediaRs.getLong("time"));
                metaData.put("pssj", (Object)pssj);
                baseFile.setMetaData(metaData.toJSONString());
            } else if (fjlx == 2) {
                baseFile.setMediaType("SP");
                baseFile.setFileType(Integer.valueOf(3));
                baseFile.setMetaData(mediaRs.getString("metarecord"));
            }
            baseFile.setFileName(fileName);
            baseFile.setCreatePath("/fruit/" + dkId + "/" + fileName);
            baseFile.setFileFormat(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        if (baseFiles.size() > 0) {
            this.setFilesRelationType(outCheckGty.getXmjd(), baseFiles);
        }
        return true;
    }

    private void setFilesRelationType(String code, List<BaseFile> baseFiles) {
        String relationType = null;
        relationType = XmxxType.YS.type.equals(code) || XmxxType.YS.gtyType.equals(code) ? "CCJZ" : "JHJZ";
        for (BaseFile baseFile : baseFiles) {
            baseFile.setRelationType(relationType);
        }
        this.baseFileDao.saveAll(baseFiles);
    }

    public String getSignUrl(String url) {
        HttpRequest request = this.getRequest(this.signUrl, Method.POST);
        request.form("url", (Object)url);
        return (String)this.getRes(request.execute(), this.signUrl, String.class);
    }

    public JSONObject queryResult(String bsm) {
        HttpRequest request = this.getRequest(this.queryResult, Method.POST);
        request.form("bizId", (Object)this.bizId);
        request.form("bsm", (Object)bsm);
        return (JSONObject)this.getRes(request.execute(), this.queryResult, null);
    }

    public JSONObject getImportResult(String id) {
        HttpRequest request = this.getRequest(this.importLog, Method.GET);
        request.form("id", (Object)id);
        return (JSONObject)this.getRes(request.execute(), this.importLog, null);
    }

    private JSONObject getTempUrl() {
        HttpRequest request = this.getRequest(this.gtyStore, Method.POST);
        request.form("type", (Object)"gty");
        return (JSONObject)this.getRes(request.execute(), this.gtyStore, null);
    }

    public String getToken() {
        String token = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)"gty_token");
        if (obj != null) {
            JSONObject jsonObject = JSON.parseObject((String)obj.toString());
            Long currTime = System.currentTimeMillis();
            Long expireTime = jsonObject.getLong("expireTime");
            if (currTime > expireTime) {
                JSONObject tokenInfo = this.httpGetToken();
                if (tokenInfo != null) {
                    token = tokenInfo.getString("accessToken");
                    this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
                }
            } else {
                token = jsonObject.getString("accessToken");
            }
        } else {
            JSONObject tokenInfo = this.httpGetToken();
            token = tokenInfo.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
        }
        return token;
    }

    private JSONObject httpGetToken() {
        HttpRequest post = HttpUtil.createPost((String)(this.gtyUrl + this.gtyTokenUrl));
        post.header("appKey", this.appKey);
        post.header("appSecret", this.appSecret);
        return (JSONObject)this.getRes(post.execute(), this.gtyTokenUrl, null);
    }

    private Object getRes(HttpResponse execute, String path, Class clazz) {
        JSONObject jsonObject = JSONObject.parseObject((String)execute.body());
        String status = jsonObject.getString("status");
        if (!"true".equalsIgnoreCase(status)) {
            throw new RuntimeException("gty\u63a5\u53e3\u3010" + path + "\u3011\u8bf7\u6c42\u5f02\u5e38\uff0c" + jsonObject.getString("msg"));
        }
        return clazz == null ? jsonObject.getJSONObject("data") : jsonObject.getObject("data", clazz);
    }

    private HttpRequest getRequest(String path, Method method) {
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(this.gtyUrl + path));
        request.header("sysToken", this.getToken());
        return request;
    }
}

