/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service.impl;

import com.geoway.onemap.zbph.service.base.VerifyTaskManageService;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.geoway.zhgd.dao.VerifyTaskDao;
import com.geoway.zhgd.domain.VerifyTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRuleVerify {
    @Autowired
    private VerifyTaskDao verifyTaskDao;
    @Autowired
    private GeoserverUtil geoserverUtil;
    @Value(value="${verifyTask.limit:100}")
    private int limit;

    protected void verifyTask() {
        Specification & Serializable specification = (Specification & Serializable)(entry, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> list = new ArrayList<Predicate>();
            list.add(criteriaBuilder.equal(entry.get("status").as(Integer.class), (Object)0));
            return criteriaBuilder.and(list.toArray(new Predicate[list.size()]));
        };
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.limit);
        Page all = this.verifyTaskDao.findAll((Specification)specification, (Pageable)pageRequest);
        List tasks = all.getContent();
        VerifyTaskManageService bean = null;
        for (VerifyTask task : tasks) {
            try {
                int status = this.geoserverUtil.httpFindTaskStatus(task.getTaskId());
                if (status != 200 && status != 500) continue;
                bean = this.getTaskBean(task.getCustomClass());
                Boolean ruleStatus = this.geoserverUtil.httpFindStatus(task.getTaskId());
                task.setRuleStatus(Integer.valueOf(ruleStatus != false ? 1 : 2));
                task.setStatus(Integer.valueOf(status));
                try {
                    bean.verifyManage(task);
                }
                catch (Exception e) {
                    task.setStatus(Integer.valueOf(0));
                    task.setRuleStatus(null);
                    task.setMessage(e.getMessage());
                    e.printStackTrace();
                }
                this.updateStatus(task);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract VerifyTaskManageService getTaskBean(String var1) throws Exception;

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(VerifyTask task) {
        this.verifyTaskDao.save((Object)task);
    }
}

