/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.util;

import com.alibaba.fastjson.JSONObject;
import com.geoway.schedual.util.JsonUtils;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateUtil {
    public static JSONObject get(String url, String token) throws Exception {
        RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            headers.set("loginToken", token);
            headers.set("accept", "application/json");
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity res = restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
        return (JSONObject)res.getBody();
    }

    public static JSONObject post(String url, Object params, String ContentType, String token) throws Exception {
        RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            headers.set("loginToken", token);
            headers.set("accept", "application/json");
        }
        HttpEntity requestEntity = new HttpEntity((Object)JsonUtils.objectToJson(params), (MultiValueMap)headers);
        ResponseEntity res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return (JSONObject)res.getBody();
    }

    public static synchronized JSONObject postJson(String url, Object params) throws Exception {
        try {
            RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)JsonUtils.objectToJson(params), (MultiValueMap)headers);
            ResponseEntity res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            return (JSONObject)res.getBody();
        }
        catch (Exception ex) {
            System.out.println("\u9519\u8bef\u4fe1\u606f:" + ex.getMessage());
            throw new Exception(ex.getMessage());
        }
    }

    public static JSONObject postJson(String url, Object params, String token) throws Exception {
        RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            headers.set("loginToken", token);
            headers.set("accept", "application/json");
        }
        HttpEntity requestEntity = new HttpEntity((Object)JsonUtils.objectToJson(params), (MultiValueMap)headers);
        ResponseEntity res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return (JSONObject)res.getBody();
    }

    public static JSONObject postJsonWithHeader(String url, Object params, Map<String, String> headerMap) throws Exception {
        RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            headers.set(entry.getKey(), entry.getValue());
        }
        HttpEntity requestEntity = new HttpEntity((Object)JsonUtils.objectToJson(params), (MultiValueMap)headers);
        ResponseEntity res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return (JSONObject)res.getBody();
    }

    public static InputStream getInputStream(String url) throws Exception {
        RestTemplate restTemplate = RestTemplateUtil.getRestTemplate(url);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url);
        URI uri = uriComponentsBuilder.build(true).toUri();
        ResponseEntity entity = restTemplate.getForEntity(uri, Resource.class);
        InputStream in = ((Resource)entity.getBody()).getInputStream();
        return in;
    }

    private static RestTemplate getRestTemplate(String url) {
        RestTemplate restTemplate = new RestTemplate();
        List converters = restTemplate.getMessageConverters();
        if (converters != null && !converters.isEmpty()) {
            for (int i = 0; i < converters.size(); ++i) {
                if (!(converters.get(i) instanceof StringHttpMessageConverter)) continue;
                StringHttpMessageConverter converter = (StringHttpMessageConverter)converters.get(i);
                converter.setDefaultCharset(Charset.forName("UTF-8"));
                break;
            }
        }
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }
}

