/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{token}")
public class AnalStatWebSocketServer {
    private static Logger log = LoggerFactory.getLogger(AnalStatWebSocketServer.class);
    private Session session;
    private static Map<String, Session> sessionPools = new HashMap<String, Session>();

    @PostConstruct
    public void init() {
        System.out.println("websocket loading");
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="token") String userToken) {
        if (userToken != null) {
            sessionPools.put(userToken, session);
        }
        this.session = session;
    }

    @OnClose
    public void onClose(@PathParam(value="token") String userToken) {
        this.session = null;
        if (userToken != null) {
            sessionPools.remove(userToken);
        }
        log.info("webSocket\u5173\u95ed!");
    }

    @OnMessage
    public void onMessage(String message) {
        for (Session session : sessionPools.values()) {
            try {
                this.sendMessage(message, session);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info("\u6536\u5230\u6d88\u606f:" + message);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        error.printStackTrace();
        log.error(error.getMessage());
    }

    public void sendMessage(String message, Session session) throws IOException {
        if (session == null) {
            session = this.session;
        }
        if (session != null) {
            this.session.getBasicRemote().sendText(message);
        }
        log.info("\u53d1\u9001\u6d88\u606f:" + message);
    }
}

