/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.support.HttpConnectionUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.supoort.GtyGWApiUtil;
import com.geoway.schedual.service.BusinessVerifyService;
import com.geoway.schedual.service.impl.AbstracGtyVerifyServiceImpl;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty-yngcy")
public class GtyYngcyVerifyServiceImpl
extends AbstracGtyVerifyServiceImpl
implements BusinessVerifyService {
    private static final Logger log = LoggerFactory.getLogger(GtyYngcyVerifyServiceImpl.class);
    @Value(value="${project.uploadDir}")
    private String uploadDir;
    @Autowired
    private GtyGWApiUtil gtyGWApiUtil;
    @Autowired
    private IBaseFileDao baseFileDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start() {
        this.startVerify();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean syncTb(String bsm, String dkid, String xmjd) throws Exception {
        OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).dkId(dkid).xmjd(xmjd).build();
        return this.parseOutResult(outCheckGty);
    }

    @Override
    public void manageInfo(String importId, List<OutCheckGty> gtyList) {
        JSONObject importResult = this.gtyGWApiUtil.getImportResult(importId);
        log.info("\u6839\u636eimportId\u67e5\u8be2\u5bfc\u5165\u8fdb\u5ea6\u7ed3\u679c\uff1a{}", (Object)importResult);
        Integer state = importResult.getInteger("state");
        if (state == 3 || state == 4) {
            log.info("\u5bfc\u5165\u72b6\u6001\uff1a{}", (Object)state);
            for (OutCheckGty outCheckGty : gtyList) {
                if (state == 3) {
                    try {
                        boolean result = this.parseOutResult(outCheckGty);
                        log.info("\u5bfc\u5165\u72b6\u6001\uff1a{},\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)state, (Object)result);
                        if (!result) break;
                        outCheckGty.setState(Integer.valueOf(2));
                        outCheckGty.setUpdateTime(new Date());
                        this.outCheckGtyDao.save((Object)outCheckGty);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        outCheckGty.setState(Integer.valueOf(1));
                        outCheckGty.setRemark(ex.getLocalizedMessage());
                        outCheckGty.setUpdateTime(new Date());
                        this.outCheckGtyDao.save((Object)outCheckGty);
                    }
                    continue;
                }
                if (state != 4) continue;
                outCheckGty.setRemark(importResult.getString("remark"));
                outCheckGty.setState(Integer.valueOf(1));
                this.outCheckGtyDao.save((Object)outCheckGty);
            }
        }
    }

    @Override
    public Boolean isComplete(List<OutCheckGty> gtyList) {
        boolean success = gtyList.stream().allMatch(f -> f.getState() == 2);
        return success;
    }

    public Boolean parseOutResult(OutCheckGty outCheckGty) throws Exception {
        JSONObject jsonObject = this.gtyGWApiUtil.queryResult(outCheckGty.getBsm());
        log.info("\u89e3\u6790\u6838\u67e5\u7ed3\u679c{},\u6807\u8bc6\u7801\uff1a{}", (Object)jsonObject, (Object)outCheckGty.getBsm());
        JSONArray medias = jsonObject.getJSONArray("medias");
        if (medias.size() == 0) {
            return false;
        }
        String dkId = outCheckGty.getDkId();
        log.info("\u89e3\u6790\u7ed3\u679c\uff0c\u51c6\u5907\u5b58\u50a8\uff01dkid:{}", (Object)dkId);
        Date now = new Date();
        ArrayList<BaseFile> baseFiles = new ArrayList<BaseFile>();
        for (Object media : medias) {
            String pssj;
            JSONObject metaData;
            JSONObject mediaRs = (JSONObject)media;
            String serverPath = mediaRs.getString("serverpath");
            log.info("\u83b7\u53d6\u4e0b\u8f7d\u6210\u679c\u5730\u5740{}", (Object)serverPath);
            if (StringUtils.isBlank((CharSequence)serverPath)) {
                log.info("\u6210\u679c\u5730\u5740\u4e3a\u7a7a\uff1a" + mediaRs.toJSONString());
                continue;
            }
            String[] serverPathSplit = serverPath.split("\\?")[0].split("/");
            String fileName = serverPathSplit[serverPathSplit.length - 1];
            String localFolder = this.uploadDir + "/fruit/" + dkId;
            new File(localFolder).mkdirs();
            HttpConnectionUtil.downLoadFromUrl((String)serverPath, (String)fileName, (String)localFolder);
            BaseFile baseFile = new BaseFile();
            baseFiles.add(baseFile);
            baseFile.setRelationId(dkId);
            baseFile.setUploadTime(now);
            int type = mediaRs.getInteger("type");
            int typetype = mediaRs.getInteger("typetype");
            if (typetype != 5 && type == 1) {
                baseFile.setMediaType("ZP");
                baseFile.setFileType(Integer.valueOf(1));
                metaData = new JSONObject();
                metaData.put("psjd", (Object)mediaRs.getDouble("azimuth"));
                metaData.put("latitude", (Object)mediaRs.getDouble("lat"));
                metaData.put("longitude", (Object)mediaRs.getDouble("lon"));
                metaData.put("psry", (Object)mediaRs.getString("username"));
                pssj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mediaRs.getLong("time"));
                metaData.put("pssj", (Object)pssj);
                baseFile.setMetaData(metaData.toJSONString());
            } else if (typetype != 5 && type == 2) {
                baseFile.setMediaType("SP");
                baseFile.setFileType(Integer.valueOf(3));
                metaData = new JSONObject();
                metaData.put("psjd", (Object)mediaRs.getDouble("azimuth"));
                metaData.put("latitude", (Object)mediaRs.getDouble("lat"));
                metaData.put("longitude", (Object)mediaRs.getDouble("lon"));
                metaData.put("psry", (Object)mediaRs.getString("username"));
                pssj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mediaRs.getLong("time"));
                metaData.put("pssj", (Object)pssj);
                baseFile.setMetaData(metaData.toJSONString());
            } else if (typetype == 5) {
                baseFile.setMediaType("FJ");
                baseFile.setFileType(Integer.valueOf(4));
            } else {
                baseFile.setMediaType("QT");
                baseFile.setFileType(Integer.valueOf(5));
            }
            baseFile.setFileName(fileName);
            baseFile.setCreatePath("/fruit/" + dkId + "/" + fileName);
            baseFile.setFileFormat(fileName.substring(fileName.lastIndexOf(".") + 1));
            String code = outCheckGty.getXmjd();
            baseFile.setRelationType(XmxxType.YS.type.equals(code) || XmxxType.YS.gtyType.equals(code) ? "CCJZ" : "JHJZ");
        }
        if (baseFiles.size() > 0) {
            this.baseFileDao.saveAll(baseFiles);
        }
        return true;
    }
}

